/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ranker<T> {
    public abstract double rank(T var1);

    static <T> List<T> sortByRanker(List<T> list, Ranker<T> ranker) {
        int i;
        ArrayList<T> ret = new ArrayList<T>(list.size());
        double[] ranks = new double[list.size()];
        boolean[] used = new boolean[list.size()];
        for (i = 0; i < list.size(); ++i) {
            ranks[i] = ranker.rank(list.get(i));
            used[i] = false;
        }
        for (i = 0; i < list.size(); ++i) {
            int bestIndex = -1;
            double bestRank = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < list.size(); ++j) {
                if (used[j] || !(ranks[j] > bestRank)) continue;
                bestRank = ranks[j];
                bestIndex = j;
            }
            if (bestIndex == -1) break;
            ret.add(list.get(bestIndex));
            used[bestIndex] = true;
        }
        return ret;
    }

    static <T> T bestByRanker(List<T> list, Ranker<T> ranker) {
        T bestT = null;
        double bestRank = Double.NEGATIVE_INFINITY;
        for (T t : list) {
            double rank = ranker.rank(t);
            if (!(rank > bestRank)) continue;
            bestRank = rank;
            bestT = t;
        }
        return bestT;
    }
}

