/*
 * Decompiled with CFR 0.152.
 */
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.unit.UnitCastle;
import com.sillysoft.vox.unit.UnitKnight;
import com.sillysoft.vox.unit.UnitPawn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polymath
implements VoxAgent {
    VoxWorld world;
    int id;
    Player me;
    Unit infantryUnitMe;
    Unit knightUnitMe;
    Unit castleUnitMe;
    Team us;
    List<Team> teams;
    List<Team> enemyTeams;
    Util2 util;
    Troops troops;
    Pathfinder2 pathfinder;
    Random rand;
    Country[] countryArray;
    List<Country> countryList;
    List<Country> ourCountries;
    int numCountries;
    boolean finishedGeneralDefense;
    Ranker<Path2> twoTurnKnightPathRanker = new Ranker<Path2>(){

        @Override
        public double rank(Path2 path) {
            if (path.turnsForKnight(Polymath.this.troops) > 2) {
                return Double.NEGATIVE_INFINITY;
            }
            return -path.getEnemyUnitStackGroup(path.get(0).getTeam(), Polymath.this.troops).getTotalUnitCount();
        }
    };
    Ranker<Country> targetRanker = new Ranker<Country>(){

        @Override
        public double rank(Country target) {
            return Polymath.this.rankWithExtra(target, new UnitStackGroup());
        }
    };
    Ranker<Country> recruitCastleRanker = new Ranker<Country>(){

        @Override
        public double rank(Country castle) {
            if (Polymath.this.countryInDanger(castle)) {
                Polymath.this.debug("recruitCastleRanker: " + castle + " in danger");
                return -9.99999999E8;
            }
            Path2 pathToEnemy = Polymath.this.pathfinder.shortestPathToEnemy(castle, Polymath.this.countryList);
            if (pathToEnemy == null) {
                Polymath.this.debug("recruitCastleRanker: " + castle + " has no path to enemy");
                return -99999.0;
            }
            Polymath.this.debug("recruitCastleRanker: " + castle + " has path to enemy of length " + pathToEnemy.size());
            return -pathToEnemy.size();
        }
    };
    Ranker<UnitStackGroup> threatRanker = new Ranker<UnitStackGroup>(){

        @Override
        public double rank(UnitStackGroup g) {
            return Polymath.this.requiredDefenders(g, new UnitStackGroup(), true, 2);
        }
    };

    @Override
    public void declareMoves(Country[] countryArray) {
        this.initTurn(countryArray);
        int[] desiredDefenders = this.doSpecialDefense();
        this.doSpecialAttacks();
        this.doGeneralAttacks();
        desiredDefenders = this.doGeneralDefense(desiredDefenders);
        this.doGeneralAttacks();
        this.doRecruitment(desiredDefenders);
        this.finishMovement(countryArray, desiredDefenders);
    }

    void initTurn(Country[] countryArray) {
        this.countryArray = countryArray;
        this.countryList = Arrays.asList(countryArray);
        this.numCountries = countryArray.length;
        this.ourCountries = Util2.teamCountries(this.us, this.countryList);
        this.teams = new ArrayList<Team>();
        for (int i = 0; i < this.numCountries; ++i) {
            if (this.teams.contains(countryArray[i].getTeam())) continue;
            this.teams.add(countryArray[i].getTeam());
        }
        this.enemyTeams = new ArrayList<Team>(this.teams);
        this.enemyTeams.remove(this.us);
        this.troops.initTurn();
        this.util.initMap();
        this.finishedGeneralDefense = false;
    }

    int[] doSpecialDefense() {
        int[] desiredDefenders = this.calculateDesiredDefenders();
        desiredDefenders = this.allocateDefensiveInfantry(desiredDefenders, Util2.teamCastles(this.us, this.countryList));
        this.allocateDefensiveKnights(desiredDefenders);
        List<Country> ourCastles = Ranker.sortByRanker(Util2.teamCastles(this.us, this.countryList), this.recruitCastleRanker);
        for (Country c : ourCastles) {
            desiredDefenders = this.defendTwoTurnCastleThreats(c, desiredDefenders);
        }
        return desiredDefenders;
    }

    void doSpecialAttacks() {
        this.debug("DOING SPECIAL ATTACKS");
        for (Country c : this.ourCountries) {
            this.knightCastleRaid(c);
        }
    }

    void doGeneralAttacks() {
        this.debug("DOING GENERAL ATTACKS");
        ArrayList<Country> targets = new ArrayList<Country>();
        for (Country c : Util2.hostileCountries(this.us, this.countryList)) {
            if (this.safeAttackers(c).getTotalUnitCount() <= 0 || Util2.teamSubgroup(this.troops.incomingGroup(c), this.us).size() != 0) continue;
            targets.add(c);
        }
        this.debug("" + targets.size() + " potential targets; beginning attacks");
        while (true) {
            Country target = Ranker.bestByRanker(targets, this.targetRanker);
            this.debug("popped target " + target);
            if (target == null) break;
            if (this.targetRanker.rank(target) <= 0.0) {
                this.debug("finishing after popping target " + target + " with rank " + this.targetRanker.rank(target));
                break;
            }
            this.attackTarget(target);
            targets.remove(target);
        }
    }

    int[] doGeneralDefense(int[] desiredDefenders) {
        this.debug("DOING GENERAL DEFENSE");
        desiredDefenders = this.allocateDefensiveInfantry(desiredDefenders, this.ourCountries);
        this.finishedGeneralDefense = true;
        return desiredDefenders;
    }

    void doRecruitment(int[] desiredDefenders) {
        this.debug("DOING RECRUITMENT");
        Country bestCastle = this.safeFrontlineCastle();
        if (bestCastle == null) {
            this.buyCastle();
        } else {
            int income = this.world.getPlayerMoney(this.id);
            this.debug("income before spending: " + this.world.getPlayerMoney(this.id));
            int totalDesiredDefenders = 0;
            for (int i = 0; i < this.numCountries; ++i) {
                totalDesiredDefenders += desiredDefenders[i];
            }
            this.debug("totalDesiredDefeners = " + (totalDesiredDefenders -= Util2.groupInfantry(this.troops.combinedRemainingGroup(this.ourCountries)).getTotalUnitCount()));
            if (totalDesiredDefenders <= 0) {
                this.placeInRatio(bestCastle, income, 1.0);
            } else if (3 * totalDesiredDefenders > income) {
                this.placeInRatio(bestCastle, income, 0.0);
            } else {
                this.placeInRatio(bestCastle, income, 1.0 - 3.0 * (double)totalDesiredDefenders / (double)income);
            }
            this.debug("income after spending: " + this.world.getPlayerMoney(this.id));
        }
    }

    void finishMovement(Country[] countryArray, int[] desiredDefenders) {
        this.debug("FINISHING MOVEMENT");
        for (Country c : this.ourCountries) {
            this.reinforceAttacks(c);
        }
        int[] extraKnightsNeeded = this.getTargetExtraKnightsNeeded();
        for (Country c : this.ourCountries) {
            this.fortifyTowardBorder(c, false, desiredDefenders);
            this.repositionKnights(c, extraKnightsNeeded);
        }
    }

    boolean needsDefenders(Country c) {
        if (c.hasCastle()) {
            this.debug("" + c + " is castle, so needs defenders");
            return true;
        }
        if (this.world.getContinent(c.getContinentID()).getBonus() > 0 && this.us.equals(this.util.continentOwner(c.getContinentID()))) {
            this.debug("" + c + " is in an owned continent, so needs defenders");
            return true;
        }
        for (Country n : this.util.realOutgoingList(c)) {
            if (!this.util.isBorder(n) && this.world.getContinent(n.getContinentID()).getBonus() > 0 && this.us.equals(this.util.continentOwner(n.getContinentID()))) {
                this.debug("" + c + " defends " + n + ", so needs defenders");
                return true;
            }
            this.debug("" + c + " doesn't defend " + n + ": " + !this.util.isBorder(n) + " " + (this.world.getContinent(n.getContinentID()).getBonus() > 0) + " " + this.us.equals(this.util.continentOwner(n.getContinentID())));
        }
        this.debug("" + c + " doesn't need defenders");
        return false;
    }

    int[] calculateDesiredDefenders() {
        int[] desiredDefenders = new int[this.numCountries];
        for (Country c : this.ourCountries) {
            int cid = c.getID();
            UnitStackGroup potentialAttackers = this.util.potentialAttackers(c);
            if (this.needsDefenders(c)) {
                ArrayList<UnitStackGroup> attackGroups = Util2.splitByTeam(potentialAttackers, this.enemyTeams);
                UnitStackGroup biggestThreat = Ranker.bestByRanker(attackGroups, this.threatRanker);
                if (!c.hasCastle()) {
                    biggestThreat = Util2.combine(Simulation2.clone(Util2.groupInfantry(biggestThreat), 0.5), Util2.groupKnights(biggestThreat));
                }
                int simType = c.hasCastle() ? 2 : 4;
                desiredDefenders[cid] = this.requiredDefenders(biggestThreat, this.troops.incomingGroup(c), true, simType);
            } else {
                int n = desiredDefenders[cid] = potentialAttackers.getTotalUnitCount() > 0 ? 1 : 0;
            }
            if (desiredDefenders[cid] <= 0) continue;
            this.debug(c.getName() + " desires " + desiredDefenders[cid] + " defenders");
        }
        return desiredDefenders;
    }

    int[] allocateDefensiveInfantry(int[] desiredDefenders, List<Country> toDefend) {
        for (Country c : toDefend) {
            if (desiredDefenders[c.getID()] <= 0 || !this.allocateOneDefender(c, desiredDefenders)) continue;
            int n = c.getID();
            desiredDefenders[n] = desiredDefenders[n] - 1;
        }
        boolean[] unhelpable = new boolean[this.numCountries];
        while (true) {
            int mostDesired = 0;
            Country neediestCountry = null;
            for (int i = 0; i < this.numCountries; ++i) {
                if (!toDefend.contains(this.countryArray[i]) || unhelpable[i] || desiredDefenders[i] <= mostDesired) continue;
                mostDesired = desiredDefenders[i];
                neediestCountry = this.countryArray[i];
            }
            if (neediestCountry == null) break;
            if (this.allocateOneDefender(neediestCountry, desiredDefenders)) {
                int n = neediestCountry.getID();
                desiredDefenders[n] = desiredDefenders[n] - 1;
                continue;
            }
            unhelpable[neediestCountry.getID()] = true;
        }
        return desiredDefenders;
    }

    boolean allocateOneDefender(Country c, int[] desiredDefenders) {
        ArrayList<Country> donors = new ArrayList<Country>();
        donors.add(c);
        donors.addAll(this.util.friendlyIncomingNeighbors(c));
        int biggestSurplus = Integer.MIN_VALUE;
        Country bestDonor = null;
        for (Country d : donors) {
            int surplus;
            int remainingInfantry = this.troops.remainingInfantry(d).getTotalUnitCount();
            if (remainingInfantry <= 0 || (surplus = remainingInfantry - desiredDefenders[d.getID()]) <= biggestSurplus) continue;
            biggestSurplus = surplus;
            bestDonor = d;
        }
        if (bestDonor == null) {
            this.debug(c.getName() + " is now unhelpable");
            return false;
        }
        this.debug("moving a defensive infantry from " + bestDonor.getName() + " to " + c.getName());
        this.troops.moveInfantry(bestDonor, c, 1);
        return true;
    }

    int requiredDefenders(UnitStackGroup attackers, UnitStackGroup existingDefenders, boolean infantry, int simType) {
        if (!Simulation2.winnable(attackers, existingDefenders, simType)) {
            return 0;
        }
        UnitStack extraDefenders = infantry ? new UnitStack(this.infantryUnitMe, 1) : new UnitStack(this.knightUnitMe, 1);
        int moreThan = 0;
        int atMost = Integer.MAX_VALUE;
        while (Simulation2.winnable(attackers, Util2.combine(existingDefenders, Util2.groupFromStack(extraDefenders)), simType)) {
            extraDefenders.setCount(2 * extraDefenders.getCount());
        }
        atMost = extraDefenders.getCount();
        while (moreThan + 1 < atMost) {
            int testCount = (moreThan + atMost + 1) / 2;
            extraDefenders.setCount(testCount);
            if (Simulation2.winnable(attackers, Util2.combine(existingDefenders, Util2.groupFromStack(extraDefenders)), simType)) {
                moreThan = testCount;
                continue;
            }
            atMost = testCount;
        }
        return atMost;
    }

    void allocateDefensiveKnights(int[] desiredDefenders) {
        for (Country c : this.ourCountries) {
            if (!c.hasCastle() || desiredDefenders[c.getID()] <= 0) continue;
            this.debug("allocateDefensiveKnights: distressed castle at " + c);
            UnitStackGroup potentialAttackers = this.util.potentialAttackers(c);
            ArrayList<UnitStackGroup> attackGroups = Util2.splitByTeam(potentialAttackers, this.enemyTeams);
            UnitStackGroup biggestThreat = Ranker.bestByRanker(attackGroups, this.threatRanker);
            int requiredKnights = this.requiredDefenders(biggestThreat, this.troops.incomingGroup(c), false, 2);
            int localKnights = Util2.groupKnights(this.util.potentialDefenders(c)).getTotalUnitCount();
            this.debug("localKnights: " + localKnights + "; requiredKnights: " + requiredKnights);
            if (localKnights < requiredKnights) continue;
            this.debug("reserving knights to defend " + c);
            this.gatherKnightsEvenly(c, requiredKnights, Util2.teamCountries(this.us, this.util.knightSources(c)));
        }
    }

    void knightCastleRaid(Country c) {
        int knights = this.troops.remainingKnights(c).getTotalUnitCount();
        if (knights <= 1) {
            return;
        }
        int shortestDistance = Integer.MAX_VALUE;
        Country bestRaidMove = null;
        for (Country castle : this.countryList) {
            int defenders;
            Path2 attackPath;
            if (!castle.hasCastle() || castle.getTeam().equals(this.us) || !Simulation2.winnable(this.troops.remainingKnights(c), this.util.potentialDefenders(castle), 4) || (attackPath = this.pathfinder.bestPathBetween(c, castle, false, this.getKnightCastleRaidPathRanker((double)knights / 10.0, knights))) == null || knights <= (defenders = attackPath.getEnemyUnitStackGroup(this.us, this.troops).getTotalUnitCount()) || attackPath.size() >= shortestDistance) continue;
            shortestDistance = attackPath.size();
            this.debug("possible knight raid with " + knights + " in " + c + " to " + castle + "!");
            if (attackPath.size() >= 3 && this.world.unitCanReach(new UnitStack(this.knightUnitMe), c, attackPath.get(2))) {
                bestRaidMove = attackPath.get(2);
                continue;
            }
            bestRaidMove = attackPath.get(1);
        }
        if (bestRaidMove != null) {
            this.debug("moving all knights in " + c + " to " + bestRaidMove + " for castle raid");
            if (bestRaidMove.hasCastle()) {
                this.attackTarget(bestRaidMove);
            } else {
                this.troops.moveRemainingKnights(c, bestRaidMove);
            }
        }
    }

    void fortifyTowardBorder(Country c, boolean fortifyKnights, int[] desiredDefenders) {
        Cluster2 cluster = Cluster2.clusterFromSeed(c, this.ourCountries, this.util);
        ArrayList<Country> border = cluster.getBorder(this.util);
        Ranker<Country> borderFortifyRanker = this.getBorderFortifyRanker(c, desiredDefenders);
        Country borderFortifyDest = Ranker.bestByRanker(border, borderFortifyRanker);
        Path2 toBorder = this.pathfinder.shortestPathBetween(c, borderFortifyDest, true);
        this.debug("fortifying toward border along path " + toBorder);
        if (toBorder == null && ((toBorder = this.pathfinder.shortestPathToEnemy(c, this.countryList).exceptLast()) == null || toBorder.size() <= 1)) {
            return;
        }
        if (toBorder.size() == 1) {
            return;
        }
        this.troops.moveRemainingInfantry(c, toBorder.get(1));
        if (fortifyKnights) {
            if (toBorder.size() > 2) {
                this.troops.moveRemainingKnights(c, toBorder.get(2));
            } else {
                this.troops.moveRemainingKnights(c, toBorder.get(1));
            }
        }
    }

    void repositionKnights(Country c, int[] extraKnightsNeeded) {
        if (this.troops.remainingKnights(c).getTotalUnitCount() == 0) {
            return;
        }
        this.debug("reposition knights in " + c);
        Country bestDest = Ranker.bestByRanker(this.ourCountries, this.getKnightRepositionDestinationRanker(c, extraKnightsNeeded));
        if (bestDest != null) {
            Path2 fortifyPath = this.pathfinder.shortestPathBetween(c, bestDest, true);
            if (fortifyPath != null) {
                if (fortifyPath.size() >= 3) {
                    this.troops.moveRemainingKnights(c, fortifyPath.get(2));
                    this.debug("repositioning knights from " + c + " to " + bestDest + " through " + fortifyPath.get(2));
                } else if (fortifyPath.size() == 2) {
                    this.troops.moveRemainingKnights(c, fortifyPath.get(1));
                    this.debug("repositioning knights from " + c + " to " + bestDest + " through " + fortifyPath.get(1));
                } else {
                    this.debug("decided it's best to leave knights in " + c + " where they are");
                }
            } else {
                this.debug("NULL FORTIFY PATH FOR REPOSITION " + c + " -> " + bestDest);
            }
        } else {
            this.debug("NULL REPOSITION DEST FOR " + c);
        }
    }

    void reinforceAttacks(Country c) {
        int numDefenders;
        Country bestTarget;
        int mostDefenders;
        if (this.troops.remainingInfantry(c).getTotalUnitCount() > 0) {
            mostDefenders = -1;
            bestTarget = null;
            for (Country target : this.util.hostileOutgoingNeighbors(c)) {
                if (Util2.teamSubgroup(this.troops.incomingGroup(target), this.us).getTotalUnitCount() <= 0 || (numDefenders = this.troops.originalGroup(target).getTotalUnitCount()) <= mostDefenders) continue;
                mostDefenders = numDefenders;
                bestTarget = target;
            }
            if (bestTarget != null) {
                this.debug("reinforcing attack on " + bestTarget.getName() + " with infantry from " + c.getName());
                this.troops.moveRemainingInfantry(c, bestTarget);
            }
        }
        if (this.troops.remainingKnights(c).getTotalUnitCount() > 0) {
            mostDefenders = -1;
            bestTarget = null;
            for (Country target : Util2.hostileCountries(this.us, this.util.knightDestinations(c))) {
                if (Util2.teamSubgroup(this.troops.incomingGroup(target), this.us).getTotalUnitCount() <= 0 || (numDefenders = this.troops.originalGroup(target).getTotalUnitCount()) <= mostDefenders) continue;
                mostDefenders = numDefenders;
                bestTarget = target;
            }
            if (bestTarget != null) {
                this.debug("reinforcing attack on " + bestTarget.getName() + " with knights from " + c.getName());
                this.troops.moveRemainingKnights(c, bestTarget);
            }
        }
    }

    Country safeFrontlineCastle() {
        List castles = this.world.getCastleCountriesOwnedBy(this.id);
        Country ret = Ranker.bestByRanker(castles, this.recruitCastleRanker);
        this.debug("safeFrontlineCastle: " + ret);
        return ret;
    }

    void placeInRatio(Country where, int income, double knightRatio) {
        int infantryCost = this.infantryUnitMe.getCost();
        int knightCost = this.knightUnitMe.getCost();
        if (where == null) {
            return;
        }
        int numUnits = (int)((double)income / ((double)infantryCost * (1.0 - knightRatio) + (double)knightCost * knightRatio));
        int numKnights = (int)(knightRatio * (double)numUnits);
        int numInfantry = (income - numKnights * knightCost) / infantryCost;
        this.troops.placeInfantry(where, numInfantry);
        this.troops.placeKnights(where, numKnights);
    }

    boolean countryInDanger(Country c) {
        return Simulation2.winnable(this.util.potentialAttackers(c), this.util.potentialDefenders(c), 2);
    }

    void attackTarget(Country target) {
        this.debug("attacking target: " + target);
        UnitStackGroup maxDefenders = this.util.potentialDefenders(target);
        int desiredKnights = (int)Math.round(Math.ceil(0.1 + 1.2 * (double)maxDefenders.getTotalUnitCount()));
        int desiredInfantry = (int)Math.round(Math.ceil(0.1 + 1.8 * (double)maxDefenders.getTotalUnitCount()));
        this.debug("maxDefenders " + maxDefenders.getTotalUnitCount() + ": " + maxDefenders);
        UnitStackGroup maxAttackers = this.safeAttackers(target);
        int maxKnights = Util2.numKnights(maxAttackers);
        int maxInfantry = Util2.numInfantry(maxAttackers);
        this.debug("maxAttackers " + maxKnights + "K+" + maxInfantry + "I: " + maxAttackers);
        int realKnights = Math.min(desiredKnights, maxKnights);
        int realInfantry = Math.min(desiredInfantry, maxInfantry);
        ArrayList<Country> knightSources = Util2.teamCountries(this.us, this.util.knightSources(target));
        ArrayList<Country> infantrySources = this.infantryAttackSources(target);
        int numKnights = this.gatherKnightsEvenly(target, realKnights, knightSources);
        int numInfantry = this.gatherInfantryEvenly(target, realInfantry, infantrySources);
        this.debug("sent " + numKnights + "K+" + numInfantry + "I");
    }

    int gatherKnightsEvenly(Country target, int maxKnights, List<Country> sources) {
        int numKnights = 0;
        boolean depleted = false;
        while (!depleted) {
            depleted = true;
            for (Country c : sources) {
                if (this.troops.remainingKnights(c).getTotalUnitCount() <= 0) continue;
                this.troops.moveKnights(c, target, 1);
                depleted = false;
                if (++numKnights != maxKnights) continue;
                return maxKnights;
            }
        }
        return numKnights;
    }

    int gatherInfantryEvenly(Country target, int maxInfantry, List<Country> sources) {
        int numInfantry = 0;
        boolean depleted = false;
        while (!depleted) {
            depleted = true;
            for (Country c : sources) {
                if (this.troops.remainingInfantry(c).getTotalUnitCount() <= 0) continue;
                this.troops.moveInfantry(c, target, 1);
                depleted = false;
                if (++numInfantry != maxInfantry) continue;
                return maxInfantry;
            }
        }
        return maxInfantry;
    }

    UnitStackGroup safeAttackers(Country target) {
        UnitStackGroup knights = Util2.groupKnights(Util2.teamSubgroup(this.util.potentialAttackers(target), this.us));
        UnitStackGroup infantry = Util2.groupInfantry(this.troops.combinedRemainingGroup(this.infantryAttackSources(target)));
        return Util2.combine(infantry, knights);
    }

    UnitStackGroup safeAttackersInContinent(Country target) {
        UnitStackGroup knights = Util2.groupKnights(Util2.teamSubgroup(this.util.potentialAttackersFromContinent(target, target.getContinentID()), this.us));
        UnitStackGroup infantry = Util2.groupInfantry(this.troops.combinedRemainingGroup(Util2.continentCountries(target.getContinentID(), this.infantryAttackSources(target))));
        return Util2.combine(infantry, knights);
    }

    ArrayList<Country> getUndistractedAllies(Country target) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country n : Util2.teamCountries(this.us, this.util.realIncomingList(target))) {
            ArrayList<Country> distractors = this.util.hostileIncomingNeighbors(n);
            if (!target.hasCastle() && distractors.size() != 0 && (distractors.size() != 1 || !((Country)distractors.get(0)).equals(target))) continue;
            ret.add(n);
        }
        return ret;
    }

    ArrayList<Country> infantryAttackSources(Country target) {
        if (!this.finishedGeneralDefense) {
            return this.getUndistractedAllies(target);
        }
        return Util2.teamCountries(this.us, this.util.realIncomingList(target));
    }

    int[] defendTwoTurnCastleThreats(Country castle, int[] desiredDefenders) {
        boolean depleted;
        Country threat = Ranker.bestByRanker(this.countryList, this.getTwoTurnKnightThreatRanker(castle));
        this.debug("defendTurnTurnCastleThreats: biggest threat to " + castle + " is " + threat);
        if (threat == null) {
            return desiredDefenders;
        }
        ArrayList<Country> core = this.util.countriesInIncomingRange(castle, 1, true);
        this.allocateDefensiveInfantry(desiredDefenders, core);
        int requiredInfantry = this.requiredDefenders(this.troops.originalKnights(threat), this.troops.originalCastles(castle), true, 2);
        int reservedInfantry = Util2.groupInfantry(this.troops.combinedIncomingGroup(core)).getTotalUnitCount();
        this.debug("requiredInfantry = " + requiredInfantry + "; reservedInfantry = " + reservedInfantry);
        if (reservedInfantry >= requiredInfantry) {
            return desiredDefenders;
        }
        this.debug("reserving core infantry; core = " + Util2.listToString(core));
        do {
            depleted = true;
            for (Country c : core) {
                if (this.troops.remainingInfantry(c).getTotalUnitCount() <= 0) continue;
                this.debug("reserving infantry in " + c);
                this.troops.reserveInfantry(c, 1);
                ++reservedInfantry;
                if (desiredDefenders[c.getID()] > 0) {
                    int n = c.getID();
                    desiredDefenders[n] = desiredDefenders[n] - 1;
                }
                if (reservedInfantry == requiredInfantry) {
                    return desiredDefenders;
                }
                depleted = false;
            }
        } while (!depleted);
        List<Country> outerCore = Util2.setSubtract(this.util.countriesInIncomingRange(castle, 2, true), core);
        this.debug("still need some more; puling in outer core infantry; outer core = " + Util2.listToString(outerCore));
        do {
            depleted = true;
            for (Country c : outerCore) {
                if (this.troops.remainingInfantry(c).getTotalUnitCount() <= 0) continue;
                Country coreNeighbor = Util2.setIntersect(this.util.realOutgoingList(c), core).get(0);
                this.debug("sending infantry from " + c + " to " + coreNeighbor);
                this.troops.moveInfantry(c, coreNeighbor, 1);
                ++reservedInfantry;
                if (desiredDefenders[coreNeighbor.getID()] > 0) {
                    int n = coreNeighbor.getID();
                    desiredDefenders[n] = desiredDefenders[n] - 1;
                }
                if (reservedInfantry == requiredInfantry) {
                    return desiredDefenders;
                }
                depleted = false;
            }
        } while (!depleted);
        if (castle.getOwner().equals(this.me)) {
            int deficit = requiredInfantry - reservedInfantry;
            int income = this.world.getPlayerMoney(this.id);
            this.debug("my castle still needs more: deficit=" + deficit + " income=" + income + " desiredDefenders=" + desiredDefenders[castle.getID()]);
            if (desiredDefenders[castle.getID()] == 0 && deficit * this.infantryUnitMe.getCost() <= income) {
                this.debug("filling out remaining requiredInfantry (" + requiredInfantry + ") with recruits");
                this.troops.placeInfantry(castle, income / this.infantryUnitMe.getCost());
            }
        }
        this.debug("didn't get enough :( - requiredInfantry = " + requiredInfantry + "; reservedInfantry = " + reservedInfantry);
        return desiredDefenders;
    }

    boolean weControlContinent(int contID, int extraTroops) {
        ArrayList<Country> contCountries = Util2.continentCountries(contID, this.countryList);
        UnitStackGroup totalOriginalGroup = this.troops.combinedOriginalGroup(contCountries);
        UnitStackGroup totalRemainingGroup = this.troops.combinedRemainingGroup(contCountries);
        UnitStackGroup totalIncomingGroup = this.troops.combinedIncomingGroup(contCountries);
        int totalEnemies = totalOriginalGroup.getTotalUnitCount() - Util2.teamSubgroup(totalOriginalGroup, this.us).getTotalUnitCount();
        int totalAllies = Util2.teamSubgroup(totalRemainingGroup, this.us).getTotalUnitCount() + Util2.teamSubgroup(totalIncomingGroup, this.us).getTotalUnitCount() + extraTroops;
        return totalAllies > 2 * totalEnemies;
    }

    int[] getTargetExtraKnightsNeeded() {
        this.debug("doing getTargetExtraKnights()...");
        int[] extraKnightsNeeded = new int[this.numCountries];
        block0: for (Country target : Util2.hostileCountries(this.us, this.countryList)) {
            if (Util2.teamCountries(this.us, this.util.knightSources(target)).size() <= 0) continue;
            int numExtra = 0;
            UnitStack attackKnights = new UnitStack(this.knightUnitMe);
            while (true) {
                attackKnights.setCount(numExtra);
                double rank = this.rankWithExtra(target, Util2.groupFromStack(attackKnights));
                if (rank > 0.0) {
                    extraKnightsNeeded[target.getID()] = numExtra;
                    this.debug("" + target + " ranks " + rank + " with " + numExtra + " extra knights)");
                    continue block0;
                }
                ++numExtra;
            }
        }
        return extraKnightsNeeded;
    }

    Ranker<Country> getKnightRepositionDestinationRanker(final Country c, final int[] extraKnightsNeeded) {
        return new Ranker<Country>(){

            @Override
            public double rank(Country dest) {
                Path2 fortifyPath = Polymath.this.pathfinder.shortestPathBetween(c, dest, true);
                if (fortifyPath == null) {
                    return Double.NEGATIVE_INFINITY;
                }
                int fortifyTurns = fortifyPath.turnsForKnight(Polymath.this.troops);
                int numKnights = Polymath.this.troops.remainingKnights(c).getTotalUnitCount();
                ArrayList<Country> alreadyInRange = Polymath.this.util.knightDestinations(c);
                ArrayList<Country> targets = Util2.hostileCountries(Polymath.this.us, Polymath.this.util.knightDestinations(dest));
                double bestScore = Double.NEGATIVE_INFINITY;
                for (Country target : targets) {
                    int n = alreadyInRange.contains(target) ? 0 : numKnights;
                    int availableExtraKnights = n;
                    int knightDeficit = Math.max(0, extraKnightsNeeded[target.getID()] - availableExtraKnights);
                    UnitStackGroup extraAttackers = Util2.groupFromStack(new UnitStack(Polymath.this.knightUnitMe, availableExtraKnights + knightDeficit));
                    double rank = Polymath.this.rankWithExtra(target, extraAttackers);
                    double score = 100.0 * rank - (double)(1000000 * knightDeficit);
                    if (!(score > bestScore)) continue;
                    bestScore = score;
                }
                double ret = bestScore - (double)(10 * fortifyTurns) + (double)Polymath.this.troops.remainingKnights(dest).getTotalUnitCount() + (double)Polymath.this.troops.incomingKnights(dest).getTotalUnitCount();
                Polymath.this.debug("rank " + ret + " for reposition destination " + dest + " for " + numKnights + " knights in " + c + " (" + fortifyTurns + " away)");
                return ret;
            }
        };
    }

    Ranker<Path2> getKnightCastleRaidPathRanker(final double defendersPerMove, final int maxDefenders) {
        return new Ranker<Path2>(){

            @Override
            public double rank(Path2 path) {
                int defenders = path.getEnemyUnitStackGroup(Polymath.this.us, Polymath.this.troops).getTotalUnitCount();
                int length = path.turnsForKnight(Polymath.this.troops);
                return (double)(-defenders) - defendersPerMove * (double)length - (double)(defenders > maxDefenders ? 999999999 : 0);
            }
        };
    }

    Ranker<Country> getTwoTurnKnightThreatRanker(final Country target) {
        return new Ranker<Country>(){

            @Override
            public double rank(Country source) {
                if (Polymath.this.us.equals(source.getTeam())) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (Polymath.this.troops.originalKnights(source).getTotalUnitCount() == 0) {
                    return Double.NEGATIVE_INFINITY;
                }
                Path2 attackPath = Polymath.this.pathfinder.bestPathBetween(source, target, false, Polymath.this.twoTurnKnightPathRanker);
                Polymath.this.debug("getTwoTurnKnightThreatRanker(target=" + target + ", source=" + source + ") attackPath = " + attackPath);
                if (attackPath == null) {
                    return Double.NEGATIVE_INFINITY;
                }
                double rank = Polymath.this.troops.originalKnights(source).getTotalUnitCount() - attackPath.getEnemyUnitStackGroup(source.getTeam(), Polymath.this.troops).getTotalUnitCount();
                return rank;
            }
        };
    }

    double rankWithExtra(Country target, UnitStackGroup extra) {
        int consolidationIndex;
        double rank = 0.0;
        UnitStackGroup attackerGroup = Util2.combine(this.safeAttackers(target), extra);
        UnitStackGroup defenderGroup = this.troops.originalGroup(target);
        UnitStackGroup maxDefenders = this.util.potentialDefenders(target);
        if (!Simulation2.winnable(attackerGroup, defenderGroup, 4)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (target.hasCastle()) {
            if (!Simulation2.winnable(attackerGroup, maxDefenders, 4)) {
                return Double.NEGATIVE_INFINITY;
            }
            rank += 10000.0;
        }
        int targetCont = target.getContinentID();
        double bonusPartial = target.getContinentBonusPartial(this.world);
        int remainingCountries = Util2.continentCountries(targetCont, this.countryList).size() - Util2.continentCountries(targetCont, this.ourCountries).size();
        if (bonusPartial > 0.0) {
            if (this.weControlContinent(targetCont, 0)) {
                rank += (double)(2000 - 5 * remainingCountries) + bonusPartial;
            } else {
                UnitStackGroup localAttackerGroup = this.safeAttackersInContinent(target);
                int foreignAid = attackerGroup.getTotalUnitCount() - localAttackerGroup.getTotalUnitCount() + extra.getTotalUnitCount();
                if (this.weControlContinent(targetCont, foreignAid)) {
                    rank += (double)(1000 - 5 * remainingCountries) + bonusPartial;
                }
            }
        }
        if ((consolidationIndex = this.getUndistractedAllies(target).size()) >= 2 && attackerGroup.getTotalUnitCount() > 2 * defenderGroup.getTotalUnitCount()) {
            rank += (double)(100 + consolidationIndex);
        } else if (consolidationIndex == 1 && attackerGroup.getTotalUnitCount() > 2 * maxDefenders.getTotalUnitCount()) {
            rank += 50.0;
        }
        if (rank == 0.0 && attackerGroup.getTotalUnitCount() > 2 * Util2.numInfantry(maxDefenders)) {
            rank += 1.0;
        }
        return rank;
    }

    Ranker<Country> getBorderFortifyRanker(final Country c, final int[] desiredDefenders) {
        return new Ranker<Country>(){

            @Override
            public double rank(Country dest) {
                Path2 pathToDest = Polymath.this.pathfinder.shortestPathBetween(c, dest, true);
                if (pathToDest == null) {
                    return -9.99999999E8;
                }
                return desiredDefenders[dest.getID()] * 1000 - pathToDest.size();
            }
        };
    }

    @Override
    public void setPrefs(int newID, VoxWorld theworld) {
        this.id = newID;
        this.world = theworld;
        this.me = this.world.getPlayer(this.id);
        this.us = this.me.getTeam();
        this.infantryUnitMe = new UnitPawn(this.me);
        this.knightUnitMe = new UnitKnight(this.me);
        this.castleUnitMe = new UnitCastle(this.me);
        this.util = new Util2(this);
        this.troops = new Troops(this);
        this.pathfinder = new Pathfinder2(this.util);
        this.rand = new Random(new Date().getTime());
    }

    @Override
    public String name() {
        return "Polymath";
    }

    @Override
    public float version() {
        return 2.0f;
    }

    @Override
    public String description() {
        return "Polymath is a Castle Vox AI by Greg McGlynn.";
    }

    @Override
    public String youWon() {
        String[] messages = new String[]{"Ah, distinctly I remember\nIt was in the bleak December\nAnd each separate dying ember\nWrought its ghost upon the floor...", "Tell all the Truth but tell it slant--\nSuccess in Circuit lies\nToo bright for our infirm Delight\nThe Truth's superb surprise.\nAs Lightning to the Children eased\nWith explanation kind\nThe Truth must dazzle gradually\nOr every man be blind--", "In Xanadu did Kubla Khan\nA stately pleasure dome decree:\nWhere Alph, the sacred river, ran\nThrough caverns measureless to man\nDown to a sunless sea.", "Lay on, Macduff\nAnd damn'd be him that first cries,\n'Hold! Enough!'", "The Sea of Faith,\nWas once, too, at the full, ...\nBut now I only hear\n Its melancholy, long, withdrawing roar,", "Tiger! tiger! burning bright,\nIn the forests of the night,\nWhat immortal hand or eye\nDare frame thy fearful symmetry?", "Oft, in the stilly night\nEre slumber's chain has bound me,\nFond memory brings the light\nOf other days around me.", "Some say the world will end in fire\nSome say in ice.\nFrom what I've tasted of desire,\nI hold with those who favor fire.\nBut if it had to perish twice,\nI think I know enough of hate\nTo know that for destruction ice\nIs also great\nAnd would suffice.", "'Twas brillig, and the slithy toves\nDid gyre and gimble in the wabe:\nAll mimsy were the borogroves,\nAnd the mome raths outgrabe.", "Hear the loud alarum bells --\nBrazen bells!\nWhat a tale of terror, now, their turbulency tells!\nIn the startled ear of night\nHow they scream out their affright!"};
        return messages[this.rand.nextInt(messages.length)];
    }

    @Override
    public String message(String message, Object data) {
        return null;
    }

    void debug(String x) {
    }

    void pause() {
    }

    public boolean buyCastle() {
        Country country;
        UnitCastle castle = new UnitCastle(this.world.getPlayer(this.id));
        if (this.world.getPlayerMoney(this.id) >= castle.getCost() && (country = this.getBestCastleBuildCountry()) != null) {
            this.world.placeUnits(new UnitStack(castle, 1), country);
            return true;
        }
        return false;
    }

    public Country getBestCastleBuildCountry() {
        int bestValue = 0;
        Country bestCountry = null;
        for (int i = 0; i < this.countryArray.length; ++i) {
            Country c = this.countryArray[i];
            if (c.getOwner().getID() != this.id || c.getUnitStackGroup().getTotalUnitCount() <= 4) continue;
            int value = c.getUnitStackGroup().getCost();
            if ((value += c.getBonus()) <= bestValue) continue;
            bestValue = value;
            bestCountry = c;
        }
        return bestCountry;
    }
}

