/*
 * Decompiled with CFR 0.152.
 */
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Team;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pathfinder2 {
    Util2 util;
    static Ranker<Path2> shortestPathRanker = new Ranker<Path2>(){

        @Override
        public double rank(Path2 p) {
            return -p.size();
        }
    };

    public Pathfinder2(Util2 util) {
        this.util = util;
    }

    static Ranker<Path2> fewestEnemyDefendersRanker(final Team team, final Troops troops) {
        return new Ranker<Path2>(){

            @Override
            public double rank(Path2 path) {
                return -path.getEnemyUnitStackGroup(team, troops).getTotalUnitCount();
            }
        };
    }

    public Path2 bestPathToCollection(Country start, Collection<Country> col, boolean safe, Ranker<Path2> ranker) {
        RankerPriorityQueue<Path2> pathQueue = new RankerPriorityQueue<Path2>(ranker);
        pathQueue.push(new Path2(start));
        boolean[] done = new boolean[this.util.bot.countryArray.length];
        Team startTeam = start.getTeam();
        while (pathQueue.size() > 0) {
            Path2 partial = pathQueue.pop();
            Country last = partial.getLast();
            if (safe && !startTeam.equals(last.getTeam()) || done[last.getID()]) continue;
            if (col.contains(last)) {
                return partial;
            }
            done[last.getID()] = true;
            for (Country n : this.util.realOutgoingList(last)) {
                pathQueue.push(new Path2(partial, n));
            }
        }
        return null;
    }

    public Path2 shortestPathBetween(Country start, Country end, boolean safe) {
        return this.bestPathToCollection(start, Collections.singletonList(end), safe, shortestPathRanker);
    }

    public Path2 shortestPathToEnemy(Country start, List<Country> countries) {
        return this.bestPathToCollection(start, Util2.hostileCountries(start.getTeam(), countries), false, shortestPathRanker);
    }

    public Path2 leastDefendedPathBetween(Country start, Country end, Team t, Troops troops) {
        return this.bestPathToCollection(start, Collections.singletonList(end), false, Pathfinder2.fewestEnemyDefendersRanker(t, troops));
    }

    public Path2 leastDefendedPathToGroup(Country start, List<Country> group, Team t, Troops troops) {
        return this.bestPathToCollection(start, group, false, Pathfinder2.fewestEnemyDefendersRanker(t, troops));
    }

    public Path2 bestPathBetween(Country start, Country end, boolean safe, Ranker<Path2> ranker) {
        return this.bestPathToCollection(start, Collections.singletonList(end), safe, ranker);
    }
}

