/*
 * Decompiled with CFR 0.152.
 */
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Team;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pathfinder {
    Util util;

    public Pathfinder(Util util) {
        this.util = util;
    }

    public Path pathToCollection(Country start, Collection<Country> col, boolean safe) {
        if (col.contains(start)) {
            return new Path(start);
        }
        ArrayDeque<Path> pathQueue = new ArrayDeque<Path>();
        pathQueue.add(new Path(start));
        boolean[] seen = new boolean[this.util.bot.countryArray.length];
        seen[start.getID()] = true;
        Team startTeam = start.getTeam();
        while (pathQueue.size() > 0) {
            Path partial = (Path)pathQueue.remove();
            Country last = partial.getLast();
            for (Country n : this.util.realAdjoiningList(last)) {
                if (seen[n.getID()] || safe && !n.getTeam().equals(startTeam)) continue;
                Path expanded = new Path(partial, n);
                if (col.contains(n)) {
                    return expanded;
                }
                pathQueue.add(expanded);
                seen[n.getID()] = true;
            }
        }
        return null;
    }

    public Path pathBetween(Country start, Country end, boolean safe) {
        return this.pathToCollection(start, Collections.singletonList(end), safe);
    }

    public Path pathToEnemy(Country start, List<Country> countries) {
        return this.pathToCollection(start, Util.hostileCountries(start.getTeam(), countries), false);
    }
}

