/*
 * Decompiled with CFR 0.152.
 */
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.UnitStackGroup;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path2 {
    private ArrayList<Country> countries;

    public Path2() {
        this.countries = new ArrayList();
    }

    public Path2(Country c) {
        this.countries = new ArrayList();
        this.countries.add(c);
    }

    public Path2(Path2 head, Country tail) {
        this.countries = new ArrayList<Country>(head.countries);
        this.countries.add(tail);
    }

    public Path2(ArrayList<Country> countries) {
        this.countries = new ArrayList<Country>(countries);
    }

    public void add(Country c) {
        this.countries.add(c);
    }

    public Country get(int i) {
        return this.countries.get(i);
    }

    public Country getLast() {
        return this.countries.get(this.countries.size() - 1);
    }

    public Path2 exceptLast() {
        ArrayList<Country> newCountries = new ArrayList<Country>();
        for (int i = 0; i < this.countries.size() - 1; ++i) {
            newCountries.add(this.countries.get(i));
        }
        return new Path2(newCountries);
    }

    public int size() {
        return this.countries.size();
    }

    public int turnsForKnight(Troops troops) {
        Team startTeam = this.countries.get(0).getTeam();
        int ret = 0;
        boolean skipped = false;
        for (int i = 1; i < this.countries.size(); ++i) {
            Country c = this.countries.get(i);
            if (i == this.countries.size() - 1 || skipped || troops.originalGroup(c).getTotalUnitCount() > 0 && !c.getTeam().equals(startTeam)) {
                ++ret;
                skipped = false;
                continue;
            }
            skipped = true;
        }
        return ret;
    }

    public int turnsForInfantry() {
        return this.countries.size() - 1;
    }

    public UnitStackGroup getUnitStackGroup(Troops troops) {
        UnitStackGroup ret = new UnitStackGroup();
        for (Country c : this.countries) {
            ret.add(troops.remainingGroup(c));
            ret.add(troops.incomingGroup(c));
        }
        return ret;
    }

    public UnitStackGroup getEnemyUnitStackGroup(Team t, Troops troops) {
        return Util2.excludeTeam(this.getUnitStackGroup(troops), t);
    }

    public Path2 reverse() {
        Path2 ret = new Path2();
        for (int i = this.countries.size() - 1; i >= 0; --i) {
            ret.add(this.countries.get(i));
        }
        return ret;
    }

    public String toString() {
        String ret = "<Path:";
        for (int i = 0; i < this.countries.size(); ++i) {
            ret = ret + " " + this.countries.get(i);
            if (i >= this.countries.size() - 1) continue;
            ret = ret + " ->";
        }
        return ret;
    }
}

