/*
 * Decompiled with CFR 0.152.
 */
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.unit.UnitCastle;
import com.sillysoft.vox.unit.UnitKnight;
import com.sillysoft.vox.unit.UnitPawn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hawk
implements VoxAgent {
    VoxWorld world;
    Country[] countryArray;
    List<Country> countryList;
    Unit infantryUnitMe;
    Unit knightUnitMe;
    Unit castleUnitMe;
    int id;
    Player me;
    Team us;
    Util util;
    Pathfinder pathfinder;
    Random rand;
    int numCountries;
    UnitStackGroup[] incoming;
    UnitStackGroup[] reserved;

    @Override
    public void declareMoves(Country[] countryArray) {
        this.initTurn(countryArray);
        this.doRecruitment();
        this.doMovement(countryArray);
    }

    void initTurn(Country[] countryArray) {
        this.countryArray = countryArray;
        this.countryList = Arrays.asList(countryArray);
        this.numCountries = countryArray.length;
        for (int i = 0; i < this.numCountries; ++i) {
            this.debug("Country " + i + ": " + countryArray[i].getName() + " - " + countryArray[i].getUnitStackGroup());
        }
        this.util.initTurn();
    }

    void doRecruitment() {
        Country bestCastle = this.safeFrontlineCastle();
        if (bestCastle == null) {
            this.buyCastle();
        } else {
            int income = this.world.getPlayerMoney(this.id);
            this.placeInRatio(bestCastle, income, 0.5);
        }
    }

    void doMovement(Country[] countryArray) {
        this.allocateDefensiveInfantry();
        ArrayList<Cluster> clusters = Cluster.teamClusters(this.us, this.countryList, this.util);
        for (Cluster cluster : clusters) {
            ArrayList<Country> border = cluster.getFriendlyBorder(this.util);
            for (Country c : cluster) {
                if (this.util.remainingGroup(c).getTotalUnitCount() == 0) continue;
                this.hitUndefendedNeighbors(c);
                if (!border.contains(c)) {
                    this.knightAttack(c);
                    this.fortifyTowardBorder(c, border, true);
                    continue;
                }
                this.attackConsolidate(c);
                this.attackFanOut(c);
                this.knightAttack(c);
            }
        }
    }

    void allocateDefensiveInfantry() {
        int[] desiredDefenders = new int[this.numCountries];
        for (Country c : Util.teamCountries(this.us, this.countryList)) {
            int cid = c.getID();
            UnitStackGroup potentialAttackers = this.util.potentialAttackers(c);
            desiredDefenders[cid] = c.hasCastle(this.me) || this.world.getContinent(c.getContinentID()).getBonus() > 0 && this.util.isContinentBorder(c) && this.us.equals(this.util.continentOwner(c.getContinentID())) ? Math.max(2, 1 + this.requiredInfantryDefenders(potentialAttackers, 1.5)) : (potentialAttackers.getTotalUnitCount() > 0 ? 1 : 0);
            int n = cid;
            desiredDefenders[n] = desiredDefenders[n] - this.util.incomingInfantry(c).getTotalUnitCount();
        }
        boolean[] unhelpable = new boolean[this.numCountries];
        while (true) {
            int mostDesired = 0;
            Country neediestCountry = null;
            for (int i = 0; i < this.numCountries; ++i) {
                if (unhelpable[i] || desiredDefenders[i] <= mostDesired) continue;
                mostDesired = desiredDefenders[i];
                neediestCountry = this.countryArray[i];
            }
            if (neediestCountry == null) break;
            ArrayList<Country> donors = new ArrayList<Country>();
            donors.add(neediestCountry);
            donors.addAll(this.util.realAdjoiningList(neediestCountry));
            int biggestSurplus = Integer.MIN_VALUE;
            Country bestDonor = null;
            for (Country d : donors) {
                int surplus;
                int remainingInfantry = this.util.remainingInfantry(d).getTotalUnitCount();
                if (remainingInfantry <= 0 || (surplus = remainingInfantry - desiredDefenders[d.getID()]) <= biggestSurplus) continue;
                biggestSurplus = surplus;
                bestDonor = d;
            }
            if (bestDonor == null) {
                this.debug(neediestCountry.getName() + " is now unhelpable");
                unhelpable[neediestCountry.getID()] = true;
                continue;
            }
            this.debug("moving a defensive infantry from " + bestDonor.getName() + " to " + neediestCountry.getName());
            this.util.moveInfantry(bestDonor, neediestCountry, 1);
            int n = neediestCountry.getID();
            desiredDefenders[n] = desiredDefenders[n] - 1;
        }
    }

    int requiredInfantryDefenders(UnitStackGroup attackers, double margin) {
        int attackerInfantry = Util.numInfantry(attackers);
        int attackerKnights = Util.numKnights(attackers);
        int defenderInfantry = 1;
        while (Simulation.winnable(attackerInfantry, attackerKnights, defenderInfantry, 0, 2)) {
            defenderInfantry *= 2;
        }
        for (int step = defenderInfantry / 2; step > 0; step /= 2) {
            if (Simulation.winnable(attackerInfantry, attackerKnights, defenderInfantry, 0, 2)) {
                defenderInfantry += step;
                continue;
            }
            defenderInfantry -= step;
        }
        return (int)((double)defenderInfantry * margin);
    }

    void fortifyTowardBorder(Country c, List<Country> border, boolean fortifyKnights) {
        Path toBorder = this.pathfinder.pathToCollection(c, border, true);
        this.debug("fortifying toward border along path " + toBorder);
        this.util.moveRemainingInfantry(c, toBorder.get(1));
        if (fortifyKnights) {
            if (toBorder.size() > 2) {
                this.util.moveRemainingKnights(c, toBorder.get(2));
            } else {
                this.util.moveRemainingKnights(c, toBorder.get(1));
            }
        }
    }

    void hitUndefendedNeighbors(Country c) {
        int localInfantry = this.util.remainingInfantry(c).getTotalUnitCount();
        int localKnights = this.util.remainingKnights(c).getTotalUnitCount();
        List<Country> reachableHostiles = Util.hostileCountries(this.us, this.util.reachableByKnight(c));
        reachableHostiles = this.sortCountryListByValue(reachableHostiles);
        ArrayList<Country> adjacentHostiles = this.util.hostileNeighbors(c);
        for (Country h : reachableHostiles) {
            if (h.getUnitStackGroup().getTotalUnitCount() != 0 || this.util.incomingGroup(h).getTotalUnitCount() != 0) continue;
            if (adjacentHostiles.contains(h) && localInfantry > 0) {
                this.debug("single infantry from " + c.getName() + " to undefended " + h.getName());
                this.util.moveInfantry(c, h, 1);
                --localInfantry;
                continue;
            }
            if (localKnights <= 0) continue;
            this.debug("single knight from " + c.getName() + " to undefended " + h.getName());
            this.util.moveKnights(c, h, 1);
            --localKnights;
        }
    }

    boolean knightAttack(Country c) {
        ArrayList<Country> targets = Util.hostileCountries(this.us, this.util.reachableByKnight(c));
        float bestScore = -2.1474836E9f;
        Country bestTarget = null;
        for (Country target : targets) {
            if (!Simulation.winnable(this.util.remainingKnights(c), target.getUnitStackGroup(), 3)) continue;
            int n = target.hasCastle() ? 1000 : 0;
            float score = (float)(n + target.getBonus()) + target.getContinentBonusPartial(this.world);
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestTarget = target;
        }
        if (bestTarget == null) {
            return false;
        }
        this.debug("knight attack from " + c.getName() + " to " + bestTarget.getName() + " with score " + bestScore);
        this.util.moveRemainingKnights(c, bestTarget);
        return true;
    }

    boolean attackFanOut(Country c) {
        ArrayList<Country> hostileNeighbors = this.util.hostileNeighbors(c);
        int numEnemies = hostileNeighbors.size();
        UnitStackGroup localTroops = this.util.remainingGroup(c);
        for (Country n : hostileNeighbors) {
            UnitStackGroup hostileTroops = n.getUnitStackGroup();
            if (Simulation.winnable(localTroops, hostileTroops, 1.0 / (double)numEnemies, 3)) continue;
            return false;
        }
        this.debug("attack fan out from " + c.getName());
        this.evenFanOut(c, hostileNeighbors, true);
        return true;
    }

    void evenFanOut(Country c, List<Country> neighbors, boolean includeKnights) {
        this.debug("splitting units from " + c.getName() + " to neighboring countries: " + Util.listToString(neighbors));
        int infantry = this.util.remainingInfantry(c).getTotalUnitCount();
        int knights = this.util.remainingKnights(c).getTotalUnitCount();
        this.debug("...splitting " + infantry + " infantry and " + knights + " knights");
        int neighborsLeft = neighbors.size();
        for (Country n : neighbors) {
            this.debug("...sending " + infantry / neighborsLeft + " infantry and " + knights / neighborsLeft + " to " + n.getName());
            this.util.moveInfantry(c, n, infantry / neighborsLeft);
            if (includeKnights) {
                this.util.moveKnights(c, n, knights / neighborsLeft);
            }
            infantry -= infantry / neighborsLeft;
            knights -= knights / neighborsLeft;
            --neighborsLeft;
        }
    }

    boolean attackConsolidate(Country c) {
        ArrayList<Country> hostileNeighbors = this.util.hostileNeighbors(c);
        int numEnemies = hostileNeighbors.size();
        if (numEnemies != 1) {
            return false;
        }
        Country target = (Country)hostileNeighbors.get(0);
        UnitStackGroup attackers = new UnitStackGroup();
        attackers.add(this.util.remainingGroup(c));
        List<Country> targetNeighbors = this.util.realAdjoiningList(target);
        ArrayList<Country> participants = new ArrayList<Country>();
        for (Country tn : targetNeighbors) {
            if (!tn.getTeam().equals(this.us) || this.util.hostileNeighbors(tn).size() != 1) continue;
            attackers.add(this.util.remainingGroup(tn));
            participants.add(tn);
        }
        if (Simulation.winnable(attackers, target.getUnitStackGroup(), 3)) {
            this.debug("consolidation attack " + c.getName() + " -> " + target.getName());
            for (Country participant : participants) {
                if (!participant.getOwner().equals(this.me)) continue;
                this.util.moveRemainingInfantry(participant, target);
                this.util.moveRemainingKnights(participant, target);
            }
            return true;
        }
        return false;
    }

    Country safeFrontlineCastle() {
        List castles = this.world.getCastleCountriesOwnedBy(this.id);
        if (castles.size() == 0) {
            return null;
        }
        Country bestCastle = null;
        int bestDistToEnemy = 10000;
        for (Country castle : castles) {
            int distToEnemy;
            if (this.countryInDanger(castle) || (distToEnemy = this.pathfinder.pathToEnemy(castle, this.countryList).size()) >= bestDistToEnemy) continue;
            bestDistToEnemy = distToEnemy;
            bestCastle = castle;
        }
        if (bestCastle == null) {
            bestCastle = (Country)castles.get(0);
        }
        return bestCastle;
    }

    void placeInRatio(Country where, int income, double knightRatio) {
        int infantryCost = this.infantryUnitMe.getCost();
        int knightCost = this.knightUnitMe.getCost();
        if (where == null) {
            return;
        }
        int numUnits = (int)((double)income / ((double)infantryCost * (1.0 - knightRatio) + (double)knightCost * knightRatio));
        int numKnights = (int)(knightRatio * (double)numUnits);
        int numInfantry = (income - numKnights * knightCost) / infantryCost;
        this.util.placeInfantry(where, numInfantry);
        this.util.placeKnights(where, numKnights);
    }

    boolean countryInDanger(Country c) {
        return Simulation.winnable(this.util.potentialAttackers(c), this.util.originalGroup(c), 2);
    }

    List<Country> sortCountryListByValue(List<Country> countries) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (int i = 0; i < countries.size(); ++i) {
            float bestScore = -2.1474836E9f;
            Country bestCountry = null;
            for (Country c : countries) {
                if (ret.contains(c)) continue;
                int n = c.hasCastle() ? 100000 : 0;
                float score = (float)(n + c.getBonus()) + c.getContinentBonusPartial(this.world);
                if (!(score > bestScore)) continue;
                bestScore = score;
                bestCountry = c;
            }
            if (bestCountry == null) continue;
            ret.add(bestCountry);
        }
        return ret;
    }

    @Override
    public void setPrefs(int newID, VoxWorld theworld) {
        this.id = newID;
        this.world = theworld;
        this.me = this.world.getPlayer(this.id);
        this.us = this.me.getTeam();
        this.infantryUnitMe = new UnitPawn(this.me);
        this.knightUnitMe = new UnitKnight(this.me);
        this.castleUnitMe = new UnitCastle(this.me);
        this.util = new Util(this);
        this.pathfinder = new Pathfinder(this.util);
        this.rand = new Random(new Date().getTime());
    }

    @Override
    public String name() {
        return "Hawk";
    }

    @Override
    public float version() {
        return 1.0f;
    }

    @Override
    public String description() {
        return "A Vox AI by Greg McGlynn.";
    }

    @Override
    public String youWon() {
        String[] messages = new String[]{"Ah, distinctly I remember\nIt was in the bleak December\nAnd each separate dying ember\nWrought its ghost upon the floor", "Tell all the Truth but tell it slant--\nSuccess in Circuit lies\nToo bright for our infirm Delight\nThe Truth's superb surprise", "As Lightning to the Children eased\nWith explanation kind\nThe Truth must dazzle gradually\nOr every man be blind--", "In Xanadu did Kubla Khan\nA stately pleasure dome decree:\nWhere Alph, the sacred river, ran\nThrough caverns measureless to man\nDown to a sunless sea", "Lay on Macduff\nAnd damn'd be him that first cries,\n\"Hold! Enough!\"", "The Sea of Faith,\nWas once, too, at the full, ...\nBut now I only hear\n Its melancholy, long, withdrawing roar,", "But at my back I always hear\nTime's winged chariot hurrying near"};
        return messages[this.rand.nextInt(messages.length)];
    }

    @Override
    public String message(String message, Object data) {
        return null;
    }

    void debug(String x) {
    }

    void pause() {
    }

    public boolean buyCastle() {
        Country country;
        UnitCastle castle = new UnitCastle(this.world.getPlayer(this.id));
        if (this.world.getPlayerMoney(this.id) >= castle.getCost() && (country = this.getBestCastleBuildCountry()) != null) {
            this.world.placeUnits(new UnitStack(castle, 1), country);
            return true;
        }
        return false;
    }

    public Country getBestCastleBuildCountry() {
        int bestValue = 0;
        Country bestCountry = null;
        for (int i = 0; i < this.countryArray.length; ++i) {
            Country c = this.countryArray[i];
            if (c.getOwner().getID() != this.id || c.getUnitStackGroup().getTotalUnitCount() <= 4) continue;
            int value = c.getUnitStackGroup().getCost();
            if ((value += c.getBonus()) <= bestValue) continue;
            bestValue = value;
            bestCountry = c;
        }
        return bestCountry;
    }
}

