/*
 * Decompiled with CFR 0.152.
 */
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements Collection<Country> {
    ArrayList<Country> countries = new ArrayList();

    public static ArrayList<Cluster> findClusters(List<Country> countries, Util util) {
        ArrayList<Cluster> ret = new ArrayList<Cluster>();
        for (Country seed : countries) {
            boolean unclustered = true;
            for (Cluster existing : ret) {
                if (!existing.contains(seed)) continue;
                unclustered = false;
                break;
            }
            if (!unclustered) continue;
            Cluster newCluster = Cluster.clusterFromSeed(seed, countries, util);
            ret.add(newCluster);
        }
        return ret;
    }

    public static Cluster clusterFromSeed(Country seed, List<Country> countries, Util util) {
        Cluster ret = new Cluster();
        ArrayDeque<Country> newMembers = new ArrayDeque<Country>();
        ret.add(seed);
        newMembers.add(seed);
        while (newMembers.size() > 0) {
            Country newMember = (Country)newMembers.remove();
            for (Country n : util.realAdjoiningList(newMember)) {
                if (ret.contains(n) || !countries.contains(n)) continue;
                ret.add(n);
                newMembers.add(n);
            }
        }
        return ret;
    }

    public static ArrayList<Cluster> playerClusters(Player p, List<Country> countries, Util util) {
        return Cluster.findClusters(Util.playerCountries(p, countries), util);
    }

    public static ArrayList<Cluster> teamClusters(Team t, List<Country> countries, Util util) {
        return Cluster.findClusters(Util.teamCountries(t, countries), util);
    }

    public ArrayList<Country> getEdge(Util util) {
        ArrayList<Country> ret = new ArrayList<Country>();
        block0: for (Country c : this.countries) {
            for (Country n : util.realAdjoiningList(c)) {
                if (this.countries.contains(n)) continue;
                ret.add(c);
                continue block0;
            }
        }
        return ret;
    }

    public ArrayList<Country> getFriendlyBorder(Util util) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country c : this.countries) {
            if (!util.isBorder(c)) continue;
            ret.add(c);
        }
        return ret;
    }

    public ArrayList<Country> getHostileBorder(Util util) {
        ArrayList<Country> ret = new ArrayList<Country>();
        Team clusterTeam = this.countries.get(0).getTeam();
        block0: for (Country c : this.countries) {
            for (Country n : util.hostileNeighbors(c)) {
                if (n.getTeam().equals(clusterTeam) || ret.contains(n)) continue;
                ret.add(n);
                continue block0;
            }
        }
        return ret;
    }

    @Override
    public boolean add(Country c) {
        return this.countries.add(c);
    }

    @Override
    public boolean remove(Object c) {
        return this.countries.remove(c);
    }

    public void remove(int i) {
        this.countries.remove(i);
    }

    @Override
    public int size() {
        return this.countries.size();
    }

    public Country get(int i) {
        return this.countries.get(i);
    }

    @Override
    public boolean contains(Object c) {
        return this.countries.contains(c);
    }

    public String toString() {
        return Util.listToString(this.countries);
    }

    @Override
    public void clear() {
        this.countries.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.countries.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.countries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.countries.toArray(a);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.countries.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.countries.retainAll(c);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.countries.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Country> c) {
        return this.countries.addAll(c);
    }

    @Override
    public Iterator<Country> iterator() {
        return new ClusterIterator(this);
    }
}

