(function($) {
    var cultures = $.cultures,
        en = cultures.en,
        standard = en.calendars.standard,
        culture = cultures["syr"] = $.extend(true, {}, en, {
        name: "syr",
        englishName: "Syriac",
        nativeName: "ܣܘܪܝܝܐ",
        language: "syr",
        isRTL: true,
        numberFormat: {
            currency: {
                pattern: ["$n-","$ n"],
                symbol: "ل.س.‏"
            }
        },
        calendars: {
            standard: $.extend(true, {}, standard, {
                firstDay: 6,
                days: {
                    names: ["ܚܕ ܒܫܒܐ","ܬܪܝܢ ܒܫܒܐ","ܬܠܬܐ ܒܫܒܐ","ܐܪܒܥܐ ܒܫܒܐ","ܚܡܫܐ ܒܫܒܐ","ܥܪܘܒܬܐ","ܫܒܬܐ"],
                    namesAbbr: ["܏ܐ ܏ܒܫ","܏ܒ ܏ܒܫ","܏ܓ ܏ܒܫ","܏ܕ ܏ܒܫ","܏ܗ ܏ܒܫ","܏ܥܪܘܒ","܏ܫܒ"],
                    namesShort: ["ܐ","ܒ","ܓ","ܕ","ܗ","ܥ","ܫ"]
                },
                months: {
                    names: ["ܟܢܘܢ ܐܚܪܝ","ܫܒܛ","ܐܕܪ","ܢܝܣܢ","ܐܝܪ","ܚܙܝܪܢ","ܬܡܘܙ","ܐܒ","ܐܝܠܘܠ","ܬܫܪܝ ܩܕܝܡ","ܬܫܪܝ ܐܚܪܝ","ܟܢܘܢ ܩܕܝܡ",""],
                    namesAbbr: ["܏ܟܢ ܏ܒ","ܫܒܛ","ܐܕܪ","ܢܝܣܢ","ܐܝܪ","ܚܙܝܪܢ","ܬܡܘܙ","ܐܒ","ܐܝܠܘܠ","܏ܬܫ ܏ܐ","܏ܬܫ ܏ܒ","܏ܟܢ ܏ܐ",""]
                },
                AM: ["ܩ.ܛ","ܩ.ܛ","ܩ.ܛ"],
                PM: ["ܒ.ܛ","ܒ.ܛ","ܒ.ܛ"],
                patterns: {
                    d: "dd/MM/yyyy",
                    D: "dd MMMM, yyyy",
                    t: "hh:mm tt",
                    T: "hh:mm:ss tt",
                    f: "dd MMMM, yyyy hh:mm tt",
                    F: "dd MMMM, yyyy hh:mm:ss tt",
                    M: "dd MMMM"
                }
            })
        }
    }, cultures["syr"]);
    culture.calendar = culture.calendars.standard;
})(ample.locale);