var sXULNS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
var pixPerCh = 10;
var Connected = false;
var fFAIL = false;
var MESS_OUTDATE = "NOTE: query text has been changed via double click on tree, so query resutls are outdated";

var gDB = null;
var q_query_hist = []; // {sql: queryString}
var q_fkey_hist = [];
var q_pkey_hist = [];
var q_ref_hist = [];

var gDATA = { execSQL:   {fkey_list: null, sql:null},
              fkeyTable: {fkey_list: null, query:null },
              refTable:  {fkey_list: null, query:null },
              indexTable:{fkey_list: null, query:null }
            };



ample.ready(function() {
  if (navigator.userAgent.match(/AppleWebKit/) && !navigator.userAgent.match(/MSIE/)) {
    var emb = document.embeds;
    var found = false;
    for (i=0; i < emb.length; i++) {
      if (emb[i].type == "application/xmla") {
        found = true;
        break;
      }
    }
    if (!found) {
      var plg = document.createElement('EMBED');
      plg.type = "application/xmla";
      plg.width=0;
      plg.height=0;
      document.body.appendChild(plg);
    }
  }
  if (navigator.userAgent.match(/Opera/)) {
    var emb = document.embeds;
    var found = false;
    for (i=0; i < emb.length; i++) {
      if (emb[i].type == "application/xmla-opera") {
        found = true;
        break;
      }
    }
    if (!found) {
      var plg = document.createElement('EMBED');
      plg.type = "application/xmla-opera";
      plg.width=0;
      plg.height=0;
      document.body.appendChild(plg);
    }
  }

//  var url = document.getElementById("url");
//  url.value = location.protocol+"//"+location.host+"/XMLA";
});



var dsnloaded = false;

function initDSN() {
  if (!dsnloaded) {
    try {
      if (!XMLAUtils)
        fFAIL = true;
    } catch (ex) {
      alert("Could not locate Openlink HTML5 XMLA component!\n"+ex);
      document.getElementById("url").focus();
      return;
    }

    try{
      var rows = XMLAUtils.discoverDataSources(document.getElementById("url").value).rows;
      var box = document.getElementById("dsn");
      box.options.length = 0;

      for(var i=0; i < rows.length; i++) {
        var val = rows.item(i).DataSourceInfo;
        box.options[i] = new Option(val, val);
        if (val == "virt")
          box.options.selectedIndex = i;
        else
          box.options.selectedIndex = 0;
      }
      dsnloaded = true;
    } catch(ex) {
      document.getElementById("url").focus();
      alert(ex);
    }
  }
}




var connH = null;

function Connection() 
{
  if (Connected) {
    window.location.reload();
    return;
  }

  try {
    if (!XMLAUtils)
     fFAIL = true;
  } catch (ex) {
     alert("Could not locate Openlink HTML5 XMLA component!\n"+ex);
     return;
  }

  var bt = document.getElementById("connect");
  bt.value="Connecting...";
  bt.disabled=true;

  connH = setTimeout(DoConnect, 20);
  return;

}


function DoConnect() 
{

  try {

    var url = document.getElementById("url").value;
    var dsn = document.getElementById("dsn").value;
    var uid = document.getElementById("uid").value;
    var pwd = document.getElementById("pwd").value;

    gDB = XMLAUtils.openXMLADatabaseSync(url, dsn, "", uid, pwd,"");

    gDB.transaction({
	handleEvent: function(trans)
	{
	  try {

	    var rs = trans.getTables("","","","%");
            var md = rs.metaData;
	    var myrows = rs.rows;
	    var tblTypes = "";
	    for(var i=0; i < myrows.lenght; i++)
	      tblTypes += myrows.item(i)[md.getColumnName(0)];
	    
	    if (tblTypes.length == 0)
	      tblTypes = "TABLE,VIEW,SYSTEM TABLE";

            var rs = trans.getCatalogs();
            md = rs.metaData;
	    myrows = rs.rows;
            var scat = "";
            var max_len = 0;

	    for(var i=0; i < myrows.length; i++) {
              var cols = myrows.item(i);
              var cat = cols[md.getColumnName(0)];

                var srs = trans.getTables(cat,"%","%",tblTypes);
                var smd = srs.metaData;
	        var smyrows = srs.rows;
	        var data = new Object();
	        for(var j=0; j < smyrows.length; j++) {
                  var tcols = smyrows.item(j);
                  var schem = tcols[smd.getColumnName(1)];
                  if (typeof(data[schem])==="undefined" || data[schem]===null) {
                    data[schem] = [];
                  }
                  data[schem].push(tcols[smd.getColumnName(2)]);
                }

              var ssch = "";
              for(var schem in data) {
                var tbls = data[schem];
                var stbl = "";
                for(var j=0; j < tbls.length; j++) {
                  stbl += '<xul:treeitem id="tableName" >'+
		            '<xul:treerow>'+
		              '<xul:treecell label="'+tbls[j]+'"/>'+
		            '</xul:treerow>'+
		          '</xul:treeitem>';
		  max_len = (max_len < tbls[j].length?tbls[j].length:max_len);
		}

                ssch += 
		  '<xul:treeitem id="schemaName" open="false" container="true" >'+
		    '<xul:treerow>'+
		       '<xul:treecell label="'+schem+'"/>'+
		    '</xul:treerow>'+
		    '<xul:treechildren>'+stbl+'</xul:treechildren>'+
		  '</xul:treeitem>';
		max_len = (max_len < schem.length?schem.length:max_len);
              }

              scat += 
		'<xul:treeitem id="dbName" open="false" container="true" >'+
		   '<xul:treerow id="load_'+cat+'">'+
		       '<xul:treecell label="'+cat+'"/>'+
		   '</xul:treerow>'+
		   '<xul:treechildren>'+ssch+'</xul:treechildren>'+
		'</xul:treeitem>';
	      max_len = (max_len < cat.length?cat.length:max_len);
	    }

            var ctree = ample.query("#mydb").empty();
            ctree.append( 
              '<xul:tree flex="1" id="db" xmlns:xul="'+sXULNS+'">'+
                '<xul:treecols>'+
	          '<xul:treecol id="dbcol" label="DbCatalogs" width="'+max_len*pixPerCh+'" primary="true"/>'+
	        '</xul:treecols>'+
		  '<xul:treebody >'+
		    '<xul:treechildren id="dbList">'+scat+'</xul:treechildren>'+
		  '</xul:treebody>'+
              '</xul:tree>');

            ample.getElementById("dbList").addEventListener("dblclick", dblClickCatch, false);


	  } catch (e) {
            var bt = document.getElementById("connect");
            bt.value="Connect";
            bt.disabled=false;
            ShowError(e);
            return;
	  }
	}});

    Connected = true;
    var bt = document.getElementById("connect");
    bt.value="Disconnect";
    bt.disabled=false;

  } catch (e) {
     var bt = document.getElementById("connect");
     bt.value="Connect";
     bt.disabled=false;
     ShowError(e);
  }
  connH = null;
}



function prevQuery()
{
  if (q_query_hist.length > 1)
  {
     var hval = q_query_hist[q_query_hist.length-2]
     q_query_hist = q_query_hist.slice(0, -2);

     if (q_query_hist.length < 1)
       ample.query("#buttonPrev").attr("disabled","true");

     ample.query("#txtSqlStatement").attr("value", hval.sql);
     ample.query("#txtSqlStatement").attr("tooltiptext", MESS_OUTDATE);
     ample.query("#execSQL").attr("tooltiptext", MESS_OUTDATE);
  }
   
}



var execH = null;

function clickExecQuery()
{
    if (!gDB) {
      alert("Connection isn't opened!");
      return;
    }

    if (execH!=null)
      clearTimeout(execH);

    var bt = ample.query("#buttonRun");
    bt.attr("label","Executing...");
    bt.attr("disabled","true");

    execH = setTimeout(DoExecQuery, 20);

    ample.query("#txtSqlStatement").attr("tooltiptext", "");
    ample.query("#execSQL").attr("tooltiptext", "");
    return;
}




function DoExecQuery()
{
    var bt = ample.query("#buttonRun");
    var queryString = ample.query("#txtSqlStatement").attr("value");
    var mess =  ample.query("#sqlLastError");

    try {

      if (queryString.indexOf("!~!",0)==0)
        var ret = ExecQuadQuery("execSQL", queryString.substr(3));
      else
        var ret = ExecQuery("execSQL", queryString);

      if (ret.rowsAffected != null) 
          mess.attr("value", "Query affected to :"+ret.rowsAffected+" rows");
      else
          mess.attr("value", "Query returns :"+ret.rowsLength+" rows");

    } catch(e) {
      mess.attr("value", e);
      ShowError(e);
    }

    bt.attr("label","RunSQL");
    bt.attr("disabled","false");
    clearTimeout(execH);
    execH = null;
}



function DoPkeyQuery()
{
    var opts = gDATA["indexTable"];
    var queryString = opts.query;

    try {

      ExecQuadQuery("indexTable", opts.query);

    } catch(e) {
      ShowError(e);
    }

//    clearTimeout(execH);
//    execH = null;
}

function DoFkeyQuery()
{
    var opts = gDATA["fkeyTable"];
    var queryString = opts.query;

    try {

      ExecQuadQuery("fkeyTable", opts.query);

    } catch(e) {
      ShowError(e);
    }

//    clearTimeout(execH);
//    execH = null;
}

function DoRefQuery()
{
    var opts = gDATA["refTable"];

    try {

      ExecQuadQuery("refTable", opts.query);

    } catch(e) {
      ShowError(e);
    }

//    clearTimeout(execH);
//    execH = null;
}


function ExecQuery(lstbox, queryString)
{
    var opts = gDATA[lstbox];
    var retVal = null;

    try {

     if (gDB)
       gDB.transaction({
	 handleEvent: function(trans)
	 {
	   try {
             var rs = trans.executeSql(queryString);
             var lst = parseSQL(queryString);

             lst = (lst == null?"":lst);
             opts.fkey_list = null;

             if (lst != null && lst.length==1)
               opts.fkey_list = getFkeyList(trans, lst[0], true);

             FillListBox(lstbox, rs, opts.fkey_list, -1);

             if (lstbox == "execSQL") {
               q_query_hist.push({sql: queryString });
               if (q_query_hist.length > 1)
                 ample.query("#buttonPrev").attr("disabled","false");
             } else if (lstbox == "fkeyTable") {
               q_fkey_hist.push({sql: queryString });
               ample.query("#buttonFBack").attr("disabled","false");
             } else if (lstbox == "refTable") {
               q_ref_hist.push({sql: queryString });
               ample.query("#buttonRBack").attr("disabled","false");
             } else if (lstbox == "indexTable") {
               q_pkey_hist.push({sql: queryString });
               ample.query("#buttonPBack").attr("disabled","false");
             }

             if (rs) {
               var md = rs.metaData;
               if (md.columnCount < 1)
                 retVal = {state:"OK", rowsAffected:rs.rowsAffected, rowsLength:null};
               else
                 retVal = {state:"OK", rowsAffected:null, rowsLength: rs.rows.length};
             }

	   } catch (e) {
	     retVal = {state:"ERR", message:e};
	   }
	 }});

    } catch (e) {
       retVal = {state:"ERR", message:e};
    }

    if (retVal.state != "OK")
      throw retVal.message;

    return retVal;
}



function ExecQuadQuery(lstbox, queryString)
{
    var opts = gDATA[lstbox];
    var retVal = null;

    try {

     if (gDB)
       gDB.transaction({
	 handleEvent: function(trans)
	 {
	   try {
             var rs = trans.executeSql(queryString);

             if (lstbox == "execSQL") {
               q_query_hist.push({sql: "!~!"+queryString });
               if (q_query_hist.length > 1)
                 ample.query("#buttonPrev").attr("disabled","false");

             } else if (lstbox == "fkeyTable") {
               q_fkey_hist.push({sql: "!~!"+queryString });
               ample.query("#buttonFBack").attr("disabled","false");

             } else if (lstbox == "refTable") {
               q_ref_hist.push({sql: "!~!"+queryString });
               ample.query("#buttonRBack").attr("disabled","false");

             } else if (lstbox == "indexTable") {
               q_pkey_hist.push({sql: "!~!"+queryString });
               ample.query("#buttonPBack").attr("disabled","false");
             }

             var qdata = {};
             if (rs) {
               var qdata = {};
               var md = rs.metaData;
               if (md.columnCount < 1)
                 retVal = {state:"OK", rowsAffected:rs.rowsAffected, rowsLength:null};
               else
                 retVal = {state:"OK", rowsAffected:null, rowsLength: rs.rows.length};

               var max_id_len = (""+rs.rows.length).length;
               var id_pref = "0000000000";

               for(var i=0; i < rs.rows.length; i++) {
                 var q = {};
                 var row = rs.rows.item(i);

                 var val = row[md.getColumnName(0)].split("#");
                 q.tbl = val[0];
                 q.cname = row[md.getColumnName(1)];
                 q.cval = row[md.getColumnName(2)];
                 q.k_type = row[md.getColumnName(3)];
                 q.k_size = row[md.getColumnName(4)];

                 var j = 5;
                 q.key = [];
                 q.k_val = [];
                 for ( ; j < 5 + q.k_size; j++)
                   q.key.push(row[md.getColumnName(j)]);
                 for ( ; j < 5 + q.k_size + q.k_size; j++)
                   q.k_val.push(row[md.getColumnName(j)]);
                 var val = ""+i;
                 val = (id_pref+val).substr(id_pref.length - max_id_len+val.length)
                 qdata["r"+val] = q;
               }
               gDATA[lstbox].qdata = qdata;
             }

             FillQuadBox(lstbox, qdata);


	   } catch (e) {
	     retVal = {state:"ERR", message:e};
	   }
	 }});

    } catch (e) {
       retVal = {state:"ERR", message:e};
    }

    if (retVal.state != "OK")
      throw retVal.message;

    return retVal;
}



function FillListBox(list, rs, fkeys_lst, ref_link_col) {
  try {
    var str = "";
    var fkey = [];
    var md = rs.metaData;
    var cw = [2];

    ample.query("#"+list).empty();

    str += '<xul:listheader minwidth="20" fixed="false" width="20" label="#"/>';

    for (var i = 0; i < md.columnCount; i++) {
      var val = md.getColumnName(i);
      str += '<xul:listheader minwidth="80" fixed="false" width="'+
               val.length*pixPerCh+'" label="'+val+'"/>';

      fkey[i] = 0;
      if (fkeys_lst!=null && ref_link_col==-1)
        for(var x=0; x < fkeys_lst.length; x++)
          if (val == fkeys_lst[x].pcol)
          {
            fkey[i]=1;
            break;
          }
      cw[i+1] = val.length;
    }

    ample.query("#"+list).append(
	    '<xul:listhead xmlns:xul="'+sXULNS+'">'+str+'</xul:listhead>');

    var rows = rs.rows;
    var nBody = ample.createElementNS(sXULNS, "xul:listbody");

    var max_id_len = (""+rows.length).length;
    var id_pref = "0000000000";

    for(var i=0; i < rows.length; i++) {
      var val = "";
      var row = rows.item(i);
      var nItem = ample.createElementNS(sXULNS, "xul:listitem");
      nBody.appendChild(nItem);

      val += i;
      var nData = ample.createElementNS(sXULNS, "xul:listcell");
      val = (id_pref+val).substr(id_pref.length - max_id_len+val.length)
      nData.setAttribute("label", val);
      nItem.appendChild(nData);
      cw[0] = val.length;


      for (var j=0; j < md.columnCount; j++) {

        var nData = ample.createElementNS(sXULNS, "xul:listcell");
        var r_val = row[md.getColumnName(j)];
        var val = xmlencode(r_val);
        cw[j+1] = (cw[j+1]<val.length?val.length:cw[j+1]);

        if (fkey[j]==1) 
        {
          nData.setAttribute("label", val);
          nData.setAttribute("id", list+"#"+md.getColumnName(j)+":"+val);
          nData.setAttribute("class","linkInt");
          nData.addEventListener("click", fkeyClickCatch, false);
        }
        else
        if (ref_link_col!=-1 && ref_link_col==j)
        {
          nData.setAttribute("label", val);
          var _id = list+"#"+fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"#"+
                    fkeys_lst[i].ptbl+":"+fkeys_lst[i].pcol+"#"+
                    fkeys_lst[i].ftbl+":"+fkeys_lst[i].fcol;
          nData.setAttribute("id", _id);
          nData.setAttribute("class","linkInt");
          nData.addEventListener("click", refLinkClickCatch, false);
        }
        else
        {
          nData.setAttribute("label", val);
          if (typeof(val)=="string" && (val.indexOf("http://")==0 || val.indexOf("https://")==0 || val.indexOf("file://")==0))
          {
            nData.setAttribute("class","linkExt");
            nData.addEventListener("click", extLinkClick, false);
          }
        }
        nItem.appendChild(nData);
      }
    }

    ample.getElementById(list).appendChild(nBody);

    var lst = ample.query("#"+list)[0].head.childNodes;
    for(var i = 0; i < lst.length; i++)
      lst[i].setAttribute("width", cw[i] * pixPerCh);

  } catch (e) {
    ShowError(e);
  }
}



function FillQuadBox(list, qdata) {
  try {
    var str = "";
    var cw = [2,8,9,5,9];

    ample.query("#"+list).empty();

    ample.query("#"+list).append(
      '<xul:listhead xmlns:xul="'+sXULNS+'">'+
        '<xul:listheader minwidth="20" fixed="false" width="20" label="#"/>'+
        '<xul:listheader minwidth="80" fixed="false" width="50" label="ObjectID"/>'+
        '<xul:listheader minwidth="80" fixed="false" width="50" label="Attribute"/>'+
        '<xul:listheader minwidth="80" fixed="false" width="50" label="Value"/>'+
        '<xul:listheader minwidth="80" fixed="false" width="50" label="TableName"/>'+
      '</xul:listhead>');

    var nBody = ample.createElementNS(sXULNS, "xul:listbody");

    for (var row in qdata) {
      var q = qdata[row];
      var id = row.substr(1);

      var nItem = ample.createElementNS(sXULNS, "xul:listitem");
      nBody.appendChild(nItem);

      var key_id = "";
      var key_val = "";
      for(var i=0; i < q.k_size; i++) {
        if (i>0) {key_id += "&"; key_val += "&"; }
        key_id += q.key[i];
        key_val += q.k_val[i];
      }

      //#
      var col_val = id;
      var nData = ample.createElementNS(sXULNS, "xul:listcell");
        nData.setAttribute("label", col_val);
        nItem.appendChild(nData);
        cw[0] = (cw[0]<col_val.length?col_val.length:cw[0]);

      //ObjectID
        col_val = xmlencode(q.tbl+"."+key_val+"#this");
        nData = ample.createElementNS(sXULNS, "xul:listcell");
        nData.setAttribute("label", col_val);
        nData.setAttribute("class","linkInt");
        nData.setAttribute("id", list+"#"+id+"#0");
        nData.addEventListener("click", valClick, false);

        nItem.appendChild(nData);
        cw[1] = (cw[1]<col_val.length?col_val.length:cw[1]);
        
      //Attribute
        col_val = xmlencode(q.cname);
        nData = ample.createElementNS(sXULNS, "xul:listcell");
        nData.setAttribute("label", col_val);
        if (q.k_type != 0) 
        {
          nData.setAttribute("class","linkInt");
          nData.setAttribute("id", list+"#"+id+"#1");
          nData.addEventListener("click", valClick, false);
        }
        nItem.appendChild(nData);
        cw[2] = (cw[2]<col_val.length?col_val.length:cw[2]);

      //Value
        nData = ample.createElementNS(sXULNS, "xul:listcell");
        if (q.k_type != 0) 
        {
          if (q.k_type==10)
            col_val = xmlencode(q.tbl+"."+key_val+"#self");
          else if (q.k_type==1)
            col_val = xmlencode(q.tbl+"."+key_val+"#"+q.cval);
          else
            col_val = xmlencode(q.tbl+"."+q.cname+"#"+q.cval);
          
          nData.setAttribute("label", col_val);
          nData.setAttribute("class","linkInt");
          nData.setAttribute("id", list+"#"+id+"#2");
          nData.addEventListener("click", valClick, false);
        
        } 
        else
        {
          col_val = xmlencode(q.cval);
          nData.setAttribute("label", col_val);
          if ((col_val.indexOf("http://")==0 || col_val.indexOf("https://")==0 || col_val.indexOf("file://")==0))
          {
            nData.setAttribute("class","linkExt");
            nData.addEventListener("click", extLinkClick, false);
          }
        }
        nItem.appendChild(nData);
        cw[3] = (cw[3]<col_val.length?col_val.length:cw[3]);

      //TableName
        col_val = xmlencode(q.tbl);
        nData = ample.createElementNS(sXULNS, "xul:listcell");
        nData.setAttribute("label", col_val);
        nData.setAttribute("class","linkInt");
        nData.setAttribute("id", list+"#"+id+"#3");
        nData.addEventListener("click", valClick, false);
        nItem.appendChild(nData);
        cw[4] = (cw[4]<col_val.length?col_val.length:cw[4]);
    }

    ample.getElementById(list).appendChild(nBody);

    var lst = ample.query("#"+list)[0].head.childNodes;
    for(var i = 0; i < lst.length; i++)
      lst[i].setAttribute("width", cw[i] * pixPerCh);


  } catch (e) {
    ShowError(e);
  }
}


function Fill_PKeyList(list, rs, fkeys_lst) {
  try {
    var str = "";
    var md = rs.metaData;
    var cw = [2];

    ample.query("#"+list).empty();

    str += '<xul:listheader minwidth="20" fixed="false" width="20" label="#"/>';
    str += '<xul:listheader minwidth="80" fixed="false" width="80" label="PKey"/>';

    for (var i = 4; i < md.columnCount; i++) {
      var val = md.getColumnName(i);
      str += '<xul:listheader minwidth="80" fixed="false" width="'+
               val.length*pixPerCh+'" label="'+val+'"/>';

      cw[i+2-4] = val.length;
    }

    ample.query("#"+list).append(
	    '<xul:listhead xmlns:xul="'+sXULNS+'">'+str+'</xul:listhead>');

    var rows = rs.rows;
    var nBody = ample.createElementNS(sXULNS, "xul:listbody");

    var max_id_len = (""+rows.length).length;
    var id_pref = "0000000000";

    for(var i=0; i < rows.length; i++) {
      var val = "";
      var row = rows.item(i);
      var nItem = ample.createElementNS(sXULNS, "xul:listitem");
      nBody.appendChild(nItem);

      val += i;
      var nData = ample.createElementNS(sXULNS, "xul:listcell");
      val = (id_pref+val).substr(id_pref.length - max_id_len+val.length)
      nData.setAttribute("label", val);
      nItem.appendChild(nData);
      cw[0] = val.length;


      nData = ample.createElementNS(sXULNS, "xul:listcell");
      val = fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"."+
            fkeys_lst[i].ptbl+"."+fkeys_lst[i].pcol+"#this";
      nData.setAttribute("label", val);
      var _id = list+"#"+fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"#"+
                 fkeys_lst[i].ptbl+":"+fkeys_lst[i].pcol+"#"+
                 fkeys_lst[i].ftbl+":"+fkeys_lst[i].fcol;
      nData.setAttribute("id", _id);
      nData.setAttribute("class","linkInt");
      nData.addEventListener("click", refLinkClickCatch, false);
      nItem.appendChild(nData);
      cw[1] = val.length;


      for (var j=4; j < md.columnCount; j++) {

        var nData = ample.createElementNS(sXULNS, "xul:listcell");
        var r_val = row[md.getColumnName(j)];
        var val = xmlencode(r_val);
        cw[j+2-4] = (cw[j+2-4]<val.length?val.length:cw[j+2-4]);

        nData.setAttribute("label", val);
        nItem.appendChild(nData);
      }
    }

    ample.getElementById(list).appendChild(nBody);

    var lst = ample.query("#"+list)[0].head.childNodes;
    for(var i = 0; i < lst.length; i++)
      lst[i].setAttribute("width", cw[i] * pixPerCh);

  } catch (e) {
    ShowError(e);
  }
}



function Fill_PkeysListBox(trans, TblPath)
{
  var tbl = TblPath.split(".");
  var fkey_list = null;

  rs = trans.getPrimaryKeys(tbl[0], tbl[1], tbl[2]);
  var rows = rs.rows;
  var md = rs.metaData;
  if (rows.length > 0) {
     var id = [];
     for(var i=0; i < rows.length; i++) {
       var row = rows.item(i);
       id[i] = {
         ind: "p",
       	 cat: row[md.getColumnName(0)],
       	 sch: row[md.getColumnName(1)],
       	ptbl: row[md.getColumnName(2)],
       	pcol: row[md.getColumnName(3)],
       	ftbl: "",
       	fcol: "",
       	fseq: row[md.getColumnName(4)]};
     }
     fkey_list = id;
  }

  Fill_PKeyList("indexTable", rs, fkey_list);
  q_pkey_hist = [];
  q_pkey_hist.push({sql: "#indexTable#"+TblPath });

  ample.query("#buttonPBack").attr("disabled","true");
}



function Fill_FKeyList(list, rs, fkeys_lst) {
  try {
    var str = "";
    var md = rs.metaData;
    var cw = [2];

    ample.query("#"+list).empty();

    str += '<xul:listheader minwidth="20" fixed="false" width="20" label="#"/>';
    str += '<xul:listheader minwidth="80" fixed="false" width="80" label="PK"/>';
    str += '<xul:listheader minwidth="80" fixed="false" width="80" label="FK"/>';

    for (var i = 8; i < md.columnCount; i++) {
      var val = md.getColumnName(i);
      str += '<xul:listheader minwidth="80" fixed="false" width="'+
               val.length*pixPerCh+'" label="'+val+'"/>';

      cw[i+3-8] = val.length;
    }

    ample.query("#"+list).append(
	    '<xul:listhead xmlns:xul="'+sXULNS+'">'+str+'</xul:listhead>');

    var rows = rs.rows;
    var nBody = ample.createElementNS(sXULNS, "xul:listbody");

    var max_id_len = (""+rows.length).length;
    var id_pref = "0000000000";

    for(var i=0; i < rows.length; i++) {
      var val = "";
      var row = rows.item(i);
      var nItem = ample.createElementNS(sXULNS, "xul:listitem");
      nBody.appendChild(nItem);

      val += i;
      var nData = ample.createElementNS(sXULNS, "xul:listcell");
      val = (id_pref+val).substr(id_pref.length - max_id_len+val.length)
      nData.setAttribute("label", val);
      nItem.appendChild(nData);
      cw[0] = val.length;


      nData = ample.createElementNS(sXULNS, "xul:listcell");
      val = fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"."+
            fkeys_lst[i].ptbl+"."+fkeys_lst[i].pcol+"#this";
      nData.setAttribute("label", val);
      var _id = list+"#"+fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"#"+
                 fkeys_lst[i].ftbl+":"+fkeys_lst[i].fcol+"#"+
                 fkeys_lst[i].ptbl+":"+fkeys_lst[i].pcol;
      nData.setAttribute("id", _id);
      nData.setAttribute("class","linkInt");
      nData.addEventListener("click", refLinkClickCatch, false);
      nItem.appendChild(nData);
      cw[1] = val.length;


      nData = ample.createElementNS(sXULNS, "xul:listcell");
      val = fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"."+
            fkeys_lst[i].ftbl+"."+fkeys_lst[i].fcol+"#this";
      nData.setAttribute("label", val);
      var _id = list+"#"+fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"#"+
                 fkeys_lst[i].ptbl+":"+fkeys_lst[i].pcol+"#"+
                 fkeys_lst[i].ftbl+":"+fkeys_lst[i].fcol;
      nData.setAttribute("id", _id);
      nData.setAttribute("class","linkInt");
      nData.addEventListener("click", refLinkClickCatch, false);
      nItem.appendChild(nData);
      cw[2] = val.length;


      for (var j=8; j < md.columnCount; j++) {

        var nData = ample.createElementNS(sXULNS, "xul:listcell");
        var r_val = row[md.getColumnName(j)];
        var val = xmlencode(r_val);
        cw[j+3-8] = (cw[j+3-8]<val.length?val.length:cw[j+3-8]);

        nData.setAttribute("label", val);
        nItem.appendChild(nData);
      }
    }

    ample.getElementById(list).appendChild(nBody);

    var lst = ample.query("#"+list)[0].head.childNodes;
    for(var i = 0; i < lst.length; i++)
      lst[i].setAttribute("width", cw[i] * pixPerCh);

  } catch (e) {
    ShowError(e);
  }
}



function Fill_FkeysListBox(trans, TblPath)
{
  var tbl = TblPath.split(".");

  var fkey_list = null;

  rs = trans.getForeignKeys(tbl[0], tbl[1], tbl[2], tbl[0], null, null);
  var rows = rs.rows;
  var md = rs.metaData;
  if (rows.length > 0) {
     var id = [];
     for(var i=0; i < rows.length; i++) {
       var row = rows.item(i);
       id[i] = {
         ind: "f",
       	 cat: row[md.getColumnName(0)],
       	 sch: row[md.getColumnName(1)],
       	ptbl: row[md.getColumnName(2)],
       	pcol: row[md.getColumnName(3)],
       	ftbl: row[md.getColumnName(6)],
       	fcol: row[md.getColumnName(7)],
       	fseq: row[md.getColumnName(8)]};
     }
     fkey_list = id;
  }

  Fill_FKeyList("fkeyTable", rs, fkey_list);
  q_fkey_hist = [];
  q_fkey_hist.push({sql: "#fkeyTable#"+TblPath });

  ample.query("#buttonFBack").attr("disabled","true");
}



function Fill_RefsList(list, rs, fkeys_lst) {
  try {
    var str = "";
    var md = rs.metaData;
    var cw = [2];

    ample.query("#"+list).empty();

    str += '<xul:listheader minwidth="20" fixed="false" width="20" label="#"/>';
    str += '<xul:listheader minwidth="80" fixed="false" width="80" label="PK"/>';
    str += '<xul:listheader minwidth="80" fixed="false" width="80" label="FK"/>';

    for (var i = 8; i < md.columnCount; i++) {
      var val = md.getColumnName(i);
      str += '<xul:listheader minwidth="80" fixed="false" width="'+
               val.length*pixPerCh+'" label="'+val+'"/>';

      cw[i+3-8] = val.length;
    }

    ample.query("#"+list).append(
	    '<xul:listhead xmlns:xul="'+sXULNS+'">'+str+'</xul:listhead>');

    var rows = rs.rows;
    var nBody = ample.createElementNS(sXULNS, "xul:listbody");

    var max_id_len = (""+rows.length).length;
    var id_pref = "0000000000";

    for(var i=0; i < rows.length; i++) {
      var val = "";
      var row = rows.item(i);
      var nItem = ample.createElementNS(sXULNS, "xul:listitem");
      nBody.appendChild(nItem);

      val += i;
      var nData = ample.createElementNS(sXULNS, "xul:listcell");
      val = (id_pref+val).substr(id_pref.length - max_id_len+val.length)
      nData.setAttribute("label", val);
      nItem.appendChild(nData);
      cw[0] = val.length;


      nData = ample.createElementNS(sXULNS, "xul:listcell");
      val = fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"."+
            fkeys_lst[i].ftbl+"."+fkeys_lst[i].fcol+"#this";
      nData.setAttribute("label", val);
      var _id = list+"#"+fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"#"+
                 fkeys_lst[i].ptbl+":"+fkeys_lst[i].pcol+"#"+
                 fkeys_lst[i].ftbl+":"+fkeys_lst[i].fcol;
      nData.setAttribute("id", _id);
      nData.setAttribute("class","linkInt");
      nData.addEventListener("click", refLinkClickCatch, false);
      nItem.appendChild(nData);
      cw[1] = val.length;


      nData = ample.createElementNS(sXULNS, "xul:listcell");
      val = fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"."+
            fkeys_lst[i].ptbl+"."+fkeys_lst[i].pcol+"#this";
      nData.setAttribute("label", val);
      var _id = list+"#"+fkeys_lst[i].cat+"."+fkeys_lst[i].sch+"#"+
                 fkeys_lst[i].ftbl+":"+fkeys_lst[i].fcol+"#"+
                 fkeys_lst[i].ptbl+":"+fkeys_lst[i].pcol;
      nData.setAttribute("id", _id);
      nData.setAttribute("class","linkInt");
      nData.addEventListener("click", refLinkClickCatch, false);
      nItem.appendChild(nData);
      cw[2] = val.length;


      for (var j=8; j < md.columnCount; j++) {

        var nData = ample.createElementNS(sXULNS, "xul:listcell");
        var r_val = row[md.getColumnName(j)];
        var val = xmlencode(r_val);
        cw[j+3-8] = (cw[j+3-8]<val.length?val.length:cw[j+3-8]);

        nData.setAttribute("label", val);
        nItem.appendChild(nData);
      }
    }

    ample.getElementById(list).appendChild(nBody);

    var lst = ample.query("#"+list)[0].head.childNodes;
    for(var i = 0; i < lst.length; i++)
      lst[i].setAttribute("width", cw[i] * pixPerCh);

  } catch (e) {
    ShowError(e);
  }
}



function Fill_RefsListBox(trans, TblPath)
{
  var tbl = TblPath.split(".");
  
  var fkey_list = null;

  rs = trans.getForeignKeys(tbl[0], null, null, tbl[0], tbl[1], tbl[2]);
  var rows = rs.rows;
  var md = rs.metaData;
  if (rows.length > 0) {
    var id = [];
    for(var i=0; i < rows.length; i++) {
      var row = rows.item(i);
      id[i] = {
         ind: "r",
       	 cat: row[md.getColumnName(0)],
       	 sch: row[md.getColumnName(1)],
       	ptbl: row[md.getColumnName(6)],
       	pcol: row[md.getColumnName(7)],
       	ftbl: row[md.getColumnName(2)],
       	fcol: row[md.getColumnName(3)],
       	fseq: row[md.getColumnName(8)]};
    }
    fkey_list = id;
  }

  Fill_RefsList("refTable", rs, fkey_list);
  q_ref_hist = [];
  q_ref_hist.push({sql: "#refTable#"+TblPath });

  ample.query("#buttonRBack").attr("disabled","true");
}



function dblClickCatch(e)
{
  var dblElem = e.target;
  var ti = dblElem.parentNode.parentNode;

  if (e.currentTarget.attributes.id == "dbList" && ti.attributes.id == "tableName") {
    // Current item is table
     var  curTab = dblElem.attributes.label;

     var t_sch = e.target.parentNode.parentNode.parentNode.parentNode;
     var Sch = t_sch.firstChild.firstChild.attributes.label;

     var t_cat = t_sch.parentNode.parentNode;
     var Cat = t_cat.firstChild.firstChild.attributes.label;

     var tbl = (Cat!=null&&Cat.length>0?Cat+".":"");
      tbl += (Sch!=null&&Sch.length>0?Sch+".":".");
      tbl += curTab;

     var tblPath = Cat+"."+Sch+"."+curTab;

     ample.query("#txtSqlStatement").attr("value", "select * from "+tbl);
     ample.query("#txtSqlStatement").attr("tooltiptext", MESS_OUTDATE);
     ample.query("#execSQL").attr("tooltiptext", MESS_OUTDATE);

     if (gDB)
       gDB.transaction({
	 handleEvent: function(trans)
	 {
	   try {
	     var fkey_list = null;
             var rs = trans.getColumns(Cat, Sch, curTab, null);
             FillListBox("structTable", rs, null, -1);

             Fill_PkeysListBox(trans, tblPath);
             Fill_FkeysListBox(trans, tblPath);
             Fill_RefsListBox(trans, tblPath);
	   } catch (e) {
             ShowError(e);
	   }
	 }});
  }
}



function fkeyClickCatch(e)
{
  var id = e.target.attributes.id;

  id = id.split("#");
  var lstbox = id[0];

  var pos = id[1].split(":");
  var col_name = pos[0];
  var col_val = pos[1];
  var opts = gDATA[lstbox];
  var path = "";

  if (opts.fkey_list.length > 0) {
    var fkey = opts.fkey_list[0]
    path  = (fkey.cat!=null?fkey.cat:"")+".";
    path += (fkey.sch!=null?fkey.sch:"")+".";
    path +=  fkey.ptbl;

    loadIntLinks(lstbox, path, col_name, col_val, opts.fkey_list, false, null, null);
  }
}




function refLinkClickCatch(e)
{
  var id = e.target.attributes.id;
  id = id.split("#");

  var lstbox = id[0];
  var path = id[1].split(".");
  var ptbll = id[2].split(":");
  var ftbll = id[3].split(":");

  var ptbl = id[1]+"."+ptbll[0];
  var ftbl = id[1]+"."+ftbll[0];
  var pcol = ptbll[1];
  var fcol = ftbll[1];


  var fkey_list = [];
  fkey_list[0] = {
         ind: "f",
       	 cat: path[0],
       	 sch: path[1],
       	ptbl: ptbll[0],
       	pcol: ptbll[1],
       	ftbl: ftbll[0],
       	fcol: ftbll[1],
       	fseq: 1};

  if (fcol.length==0 && ftbll[0].length==0)
    loadIntLinks(lstbox, ptbl, pcol, "", null,  true, null, null);
   else
    loadIntLinks(lstbox, ptbl, pcol, "", fkey_list, false, null, null);
}



function valClick(e)
{
//??alert("val_link");
  var id = e.target.attributes.id;

  id = id.split("#");
  var lstbox = id[0];
  var mode = id[2];
  var opts = gDATA[lstbox];
  var q = opts.qdata["r"+id[1]];

  var add_pkey = (q.k_type==10||q.k_type==1?true:false);

  if (mode == 0) //ObjectID
    loadIntLinks(lstbox, q.tbl,      "",     "", null, true,     q.key, q.k_val);
  else if (mode == 1) //Attribute
    loadIntLinks(lstbox, q.tbl, q.cname,     "", null, add_pkey, q.key, q.k_val);
  else if (mode == 2) //Value
    if (q.k_type==10)
    loadIntLinks(lstbox, q.tbl,      "",     "", null, add_pkey, q.key, q.k_val);
    else
    loadIntLinks(lstbox, q.tbl, q.cname, q.cval, null, add_pkey, q.key, q.k_val);
  else if (mode == 3) //TableName
    loadIntLinks(lstbox, q.tbl,      "",     "", null, true,     null,  null);
}




function loadIntLinks(lstbox, tbl, col, col_val, fkey_list, add_pkey, pkeys, pk_vals)
{
  var path = tbl.split(".");
  var sql = "";
  var err = false;

/****
  tbl, col_name, col_val, key_type, key_size, key1, key2, key_val1, key_val2
****/

  if (gDB)
    gDB.transaction({
      handleEvent: function(trans)
      {
	try {

	  if (fkey_list == null) {
	    if (add_pkey==true)
              fkey_list = getFkeyList(trans, tbl, true);
            else
              fkey_list = getFkeyList(trans, tbl);
          }
	  
	  var query=[];
	  var q = null;
	  for(var x = 0; x < fkey_list.length; x++)
	  {
	    var tlist;

            var fkey = fkey_list[x];
            var ftbl = path[0]+"."+path[1]+"."+fkey.ftbl;
            var ptbl = path[0]+"."+path[1]+"."+fkey.ptbl;

            if (fkey.ind == "p")
	      tlist = getTblCols(trans, path[0], path[1], fkey.ptbl);
            else
	      tlist = getTblCols(trans, path[0], path[1], fkey.ftbl);
	      
	    var key_id = ""
	    var kval_id = "";
	    var val_id = "";

	    for(var i=0; i < tlist.pkey.length; i++) {
	      //xmlencode
              key_id += ", '"+tlist.pkey[i]+"'";

              if (fkey.ind == "p")
	        kval_id += ", cast(\""+tlist.pkey[i]+"\" as varchar)";
              else
	        kval_id += ", cast(f.\""+tlist.pkey[i]+"\" as varchar)";

	      if (i>0) val_id += "||'&'||";

              if (fkey.ind == "p")
	        val_id += "cast(\""+tlist.pkey[i]+"\" as varchar)";
              else
	        val_id += "cast(f.\""+tlist.pkey[i]+"\" as varchar)";
	    }

	    for(var i=0; i < tlist.col.length; i++) {
	      if (tlist.col[i].isLong)
	        continue;

	      if (col.length > 0 && col != fkey.pcol && fkey.ind!="p")
	        continue;

	      if (pkeys!=null) {
	         if (col.length==0 && fkey.ind !="p")  //ObjectId
	           continue;
	      } else {
	         if (col.length==0 && fkey.ind !="p")  //TableName
	           continue;
	      }

	      q = {};
              if (sql.length > 0)
                sql += "\n UNION \n ";

              var acol = tlist.col[i].name;
              var akey = tlist.col[i].key;

              if (fkey.ind == "p")
                q.s1 = "select distinct '"+ptbl+"#'||"+val_id+",'"+acol+"', cast(\""+acol+"\" as varchar),";
              else
                q.s1 = "select distinct '"+ftbl+"#'||"+val_id+",'"+acol+"', cast(f.\""+acol+"\" as varchar),";

//10 - onekey primary key
//1  - multi primary key
//2  - foreign key
//0  - value
              if (tlist.pkey.length == 1 && tlist.pkey[0]==acol && akey==1)
                q.s1 += "'10'";
              else if (akey == 2)
                q.s1 += "'2'";
              else if (akey == 1)
                q.s1 += "'1'";
              else
                q.s1 += "'0'";

              q.key_size = tlist.pkey.length;
              q.key_id = key_id;
              q.kval_id = kval_id;

              if (fkey.ind == "p")
              {
                q.s2 = " from \""+ptbl+"\" f"+
                      " where 1=1 " ;

                if (pkeys != null && pk_vals != null)
                {
                  for(var j=0; j < pkeys.length; j++)
                    q.s2 += " AND \""+pkeys[j]+"\"='"+pk_vals[j]+"'" ;
                }

                if (col.length >0 && col_val.length >0) 
                  q.s2 += " AND \""+col+"\"='"+col_val+"'" ;

              }
              else
              {
                q.s2 = " from \""+ftbl+"\" f, \""+ptbl+"\" p "+
                      " where f.\""+fkey.fcol+"\"=p.\""+fkey.pcol+"\"" ;

                if (pkeys != null && pk_vals != null)
                {
                  for(var j=0; j < pkeys.length; j++)
                    q.s2 += " AND p.\""+pkeys[j]+"\"='"+pk_vals[j]+"'" ;
                }

                if (col.length >0 && col_val.length >0) 
                  q.s2 += " AND p.\""+col+"\"='"+col_val+"'" ;
              }
              query.push(q);
            }
          }

          var key_size = 0;
          for(var i=0; i < query.length; i++) {
            if (query[i].key_size > key_size)
              key_size = query[i].key_size;
          }
          for(var i=0; i < query.length; i++) {
            q = query[i];
            if (sql.length > 0)
              sql += "\n UNION \n ";
            sql += q.s1+","+q.key_size+q.key_id+q.kval_id;
            var add = key_size - q.key_size;
            if (add > 0) {
              add *= 2;
              for(var j=0; j < add; j++)
                sql += ",''"
            }
            sql += q.s2;
          }

          if (sql.length > 0)
            sql += " order by 1"

	} catch (e) {
          ShowError(e);
          err = true;
	}
      }});

  if (err)
    return;

//??alert(sql);
//??ample.query("#txtSqlStatement").attr("value", sql);
  if (sql.length > 0) 
  {
    if (lstbox == "execSQL") { 
      ample.query("#txtSqlStatement").attr("value", "!~!"+sql);

      var opts = gDATA[lstbox];

      clickExecQuery();

    } else {

      var opts = gDATA[lstbox];
      opts.query = sql;

      if (lstbox == "fkeyTable")
        setTimeout(DoFkeyQuery, 200);
      else if (lstbox == "refTable")
        setTimeout(DoRefQuery, 200);
      else if (lstbox == "indexTable")
        setTimeout(DoPkeyQuery, 200);

    }
  }
}



function getFkeyList(trans, tbl_id, add_pkey)
{
    var id = [];
    var lst = tbl_id.split(".");
    var _cat = (lst.length>2?lst[lst.length-3]:null); 
    var _sch = (lst.length>1?lst[lst.length-2]:null); 
    var _tbl = lst[lst.length-1];

    var rs = trans.getForeignKeys(_cat, _sch, _tbl, (_cat!=null?_cat:""),"","");
    var rows = rs.rows;
    var md = rs.metaData;
    var id_pos=0;

    if (rows.length > 0) {
      for(var i=0; i < rows.length; i++) {
        var row = rows.item(i);
        id[id_pos++] = {
                 ind: "f",
                 cat: row[md.getColumnName(0)],
                 sch: row[md.getColumnName(1)],
             	ptbl: row[md.getColumnName(2)],
             	pcol: row[md.getColumnName(3)],
               	ftbl: row[md.getColumnName(6)],
               	fcol: row[md.getColumnName(7)],
               	fseq: row[md.getColumnName(8)]};
      }
    }

    rs = trans.getForeignKeys((_cat!=null?_cat:""),"","", _cat, _sch, _tbl);
    rows = rs.rows;
    md = rs.metaData;
    if (rows.length > 0) {
      for(var i=0; i < rows.length; i++) {
        var row = rows.item(i);
        id[id_pos++] = {
                 ind: "r",
                 cat: row[md.getColumnName(0)],
                 sch: row[md.getColumnName(1)],
             	ptbl: row[md.getColumnName(6)],
             	pcol: row[md.getColumnName(7)],
               	ftbl: row[md.getColumnName(2)],
               	fcol: row[md.getColumnName(3)],
               	fseq: row[md.getColumnName(8)]};
      }
    }

    if (add_pkey == true) {
      rs = trans.getPrimaryKeys(_cat, _sch, _tbl);
      rows = rs.rows;
      md = rs.metaData;

      if (rows.length > 0) {
        for(var i=0; i < rows.length; i++) {
          var row = rows.item(i);
          id.push({
                 ind: "p",
                 cat: row[md.getColumnName(0)],
                 sch: row[md.getColumnName(1)],
               	ptbl: row[md.getColumnName(2)],
               	pcol: row[md.getColumnName(3)],
             	ftbl: "",
             	fcol: "",
               	fseq: row[md.getColumnName(4)]});
        }
      }
    }
    return id;

}



function getTblCols(trans, cat, sch, tbl)
{
    var pkey = []
    var tcol = [];

    var rs = trans.getColumns(cat, sch, tbl, null);
    var rows = rs.rows;
    var md = rs.metaData;

    if (rows.length > 0) {
      for(var i=0; i < rows.length; i++) {
        var row = rows.item(i);
        var col_type = row[md.getColumnName(4)];
        var is_long = (col_type==-1||col_type==-4)?true:false;
        tcol[i] = {
//                 cat: row[md.getColumnName(0)],
//                 sch: row[md.getColumnName(1)],
//             	 tbl: row[md.getColumnName(2)],
                isLong: is_long,
             	name: row[md.getColumnName(3)],
             	 key: 0};
      }
    }

    var fkeys = getFkeyList(trans, cat+"."+sch+"."+tbl);

    rs = trans.getPrimaryKeys(cat, sch, tbl);
    rows = rs.rows;
    md = rs.metaData;
            
    if (rows.length > 0) {
      for(var i=0; i < rows.length; i++) {
        pkey[i] = rows.item(i)[md.getColumnName(3)];
        for(var j = 0; j < tcol.length; j++) {
          if (pkey[i] == tcol[j].name)
            tcol[j].key = 1;
        }
      }
    }

    for(var i=0; i < fkeys.length; i++) {
      for(var j=0; j < tcol.length; j++) {
        if (tcol[j].name == fkeys[i].pcol && tcol[j].key==0)
          tcol[j].key = 2;
      }
    }

    return { pkey: pkey, col: tcol };
}



function clickBack(lstbox) {
  var hval = null;

  if (lstbox == "fkeyTable") {
    if (q_fkey_hist.length > 1)
    {
       hval = q_fkey_hist[q_fkey_hist.length-2]
       q_fkey_hist = q_fkey_hist.slice(0, -2);
    }
    if (q_fkey_hist.length < 1)
      ample.query("#buttonFBack").attr("disabled","true");

  } else if (lstbox == "refTable") {
    if (q_ref_hist.length > 1)
    {
       hval = q_ref_hist[q_ref_hist.length-2]
       q_ref_hist = q_ref_hist.slice(0, -2);
    }
    if (q_fkey_hist.length < 1)
      ample.query("#buttonRBack").attr("disabled","true");

  } else if (lstbox == "indexTable") {
    if (q_pkey_hist.length > 1)
    {
       hval = q_pkey_hist[q_pkey_hist.length-2]
       q_pkey_hist = q_pkey_hist.slice(0, -2);
    }
    if (q_pkey_hist.length < 1)
      ample.query("#buttonPBack").attr("disabled","true");
  }

  if (hval != null)
  {
     if (hval.sql.length>0 && hval.sql[0]=="#") {
       var query = hval.sql.split("#");

       if (gDB)
         gDB.transaction({
	   handleEvent: function(trans)
	   {
	     try {

               if (query[1] == "fkeyTable")
                 Fill_FkeysListBox(trans, query[2]);
               else if (query[1] == "refTable")
                 Fill_RefsListBox(trans, query[2]);
               else if (query[1] == "indexTable")
                 Fill_PkeysListBox(trans, query[2]);
	     
	     } catch (e) {
               ShowError(e);
	     }
	   }});
     }
     else if (hval.sql.indexOf("!~!",0)==0)
     {
       try {
         ExecQuadQuery(lstbox, hval.sql.substr(3));
       } catch(e) {
         ShowError(e);
       }
     }
     else
     {
       try {
         ExecQuery(lstbox, hval.sql);
       } catch(e) {
         ShowError(e);
       }
     }
  }
}



//SELECT Invoice.*, Customer.* FROM Invoice, Customer
//SELECT * FROM Invoice, Customer
//SELECT * FROM relationships LEFT OUTER JOIN users ON relationships.created_by = users.id AND relationships.updated_by = users.id LEFT OUTER JOIN things ON things.relatedrelationship_id = relationships.id  ORDER BY relationships.updated_at DESC LIMIT 0, 20
function parseSQL(query)
{
   var sqlQuery = query.replace(/\n/g, ' ').replace(/\r/g, '');

   var query_type = sqlQuery.split(/\s+/)[0];
   if (query_type.toUpperCase() != 'SELECT')
     return null;

   var strip_whitespace = function(str) {
      return str.replace(/\s+/g, '');
   }

   var findClause = function(str, regexp) {
      var clauseEnd = str.search(regexp);
      if (clauseEnd < 0)
          clauseEnd = str.length;
      return str.substring(0, clauseEnd);
   }

   var fromSplit = sqlQuery.substring(7).split(new RegExp(" FROM ","i"));
   if (fromSplit.length != 2)
      return null;
            
   var columnsClause = fromSplit[0];
   var remaining     = fromSplit[1];

   var fromClause    = findClause(remaining, /\sWHERE\s|\sGROUP BY\s|\sHAVING\s|\sORDER BY\s|\sLIMIT/i);
   var fromTableClause = findClause(fromClause, /\sLEFT OUTER JOIN\s/i);

   var fromTables = strip_whitespace(fromTableClause).split(',');
   remaining = remaining.substring(fromClause.length);
            
   var fromClauseSplit = fromClause.split(new RegExp(" LEFT OUTER JOIN ","i"));
   var fromClauseParts = [fromClauseSplit[0]];
   
   var leftJoinComponents;
   for (var i = 1; i < fromClauseSplit.length; i++) {
      leftJoinComponents = /(\w+)\sON\s(.+)/i.exec(fromClauseSplit[i]);
      fromTables.push(leftJoinComponents[1]);
   }

//   if(strip_whitespace(columnsClause) == '*') {
//       var new_columns = [];
//       for(var i=0; i<fromTables.length; i++) {
//          new_columns.push(fromTables[i]+'.ALL')
//       }
//       columnsClause = columnsClause.replace(/\*/, new_columns.join(', '))
//   }

   return fromTables;
}




function ShowError(e) {
  alert(e);
}


function extLinkClick(e) {
  var id = e.target.attributes.label;
  window.open(id);
}



function xmlencode(val) {

    if (typeof(val)=="string" && val != null)
          val = val.replace(/\&/g,'&'+'amp;').replace(/</g,'&'+'lt;')
                   .replace(/>/g,'&'+'gt;').replace(/\'/g,'&'+'apos;')
                   .replace(/\"/g,'&'+'quot;');
    return val?val:"";
}


