/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.windows.TranslucentWindowPainter;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WPrintDialogPeer;

public class WWindowPeer
extends WPanelPeer
implements WindowPeer {
    private static final DebugHelper dbg = DebugHelper.create(WWindowPeer.class);
    private static final Logger log = Logger.getLogger("sun.awt.windows.WWindowPeer");
    private WWindowPeer modalBlocker = null;
    private static final StringBuffer ACTIVE_WINDOWS_KEY = new StringBuffer("active_windows_list");
    private static PropertyChangeListener activeWindowListener = new ActiveWindowListener();
    private static final PropertyChangeListener guiDisposedListener = new GuiDisposedListener();
    protected boolean visible = false;
    private volatile int sysX = 0;
    private volatile int sysY = 0;
    private volatile int sysW = 0;
    private volatile int sysH = 0;
    private float opacity = 1.0f;
    private boolean isOpaque = true;
    private volatile TranslucentWindowPainter painter;

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeImpl() {
        Object object;
        AppContext appContext = SunToolkit.targetToAppContext(this.target);
        Object object2 = appContext;
        synchronized (object2) {
            object = (List)appContext.get(ACTIVE_WINDOWS_KEY);
            if (object != null) {
                object.remove(this);
            }
        }
        object2 = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)((GraphicsConfiguration)object2).getDevice()).removeDisplayChangedListener(this);
        object = this.painter;
        if (object != null) {
            ((TranslucentWindowPainter)object).flush();
        }
        super.disposeImpl();
    }

    public void toFront() {
        this.updateFocusableWindowState();
        this._toFront();
    }

    native void _toFront();

    public native void toBack();

    public native void setAlwaysOnTopNative(boolean var1);

    public void setAlwaysOnTop(boolean bl) {
        if (bl && ((Window)this.target).isVisible() || !bl) {
            this.setAlwaysOnTopNative(bl);
        }
    }

    public void updateFocusableWindowState() {
        this.setFocusableWindow(((Window)this.target).isFocusableWindow());
    }

    native void setFocusableWindow(boolean var1);

    public void setTitle(String string) {
        if (string == null) {
            string = new String("");
        }
        this._setTitle(string);
    }

    native void _setTitle(String var1);

    public void setResizable(boolean bl) {
        this._setResizable(bl);
    }

    public native void _setResizable(boolean var1);

    WWindowPeer(Window window) {
        super(window);
    }

    void initialize() {
        super.initialize();
        this.updateInsets(this.insets_);
        Font font = ((Window)this.target).getFont();
        if (font == null) {
            font = defaultFont;
            ((Window)this.target).setFont(font);
            this.setFont(font);
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).addDisplayChangedListener(this);
        WWindowPeer.initActiveWindowsTracking((Window)this.target);
        this.updateIconImages();
    }

    native void createAwtWindow(WComponentPeer var1);

    void create(WComponentPeer wComponentPeer) {
        this.createAwtWindow(wComponentPeer);
    }

    protected void realShow() {
        super.show();
        this.visible = true;
    }

    public void show() {
        this.updateFocusableWindowState();
        boolean bl = ((Window)this.target).isAlwaysOnTop();
        this.updateGC();
        this.resetTargetGC();
        this.realShow();
        this.updateMinimumSize();
        if (((Window)this.target).isAlwaysOnTopSupported() && bl) {
            this.setAlwaysOnTop(bl);
        }
        this.updateWindow(null);
    }

    public void hide() {
        super.hide();
        this.visible = false;
    }

    native void updateInsets(Insets var1);

    static native int getSysMinWidth();

    static native int getSysMinHeight();

    static native int getSysIconWidth();

    static native int getSysIconHeight();

    static native int getSysSmIconWidth();

    static native int getSysSmIconHeight();

    native void setIconImagesData(int[] var1, int var2, int var3, int[] var4, int var5, int var6);

    synchronized native void reshapeFrame(int var1, int var2, int var3, int var4);

    public boolean requestWindowFocus() {
        return false;
    }

    public boolean focusAllowedFor() {
        Window window = (Window)this.target;
        if (!(window.isVisible() && window.isEnabled() && window.isFocusable())) {
            return false;
        }
        return !this.isModalBlocked();
    }

    public void updateMinimumSize() {
        Dimension dimension = null;
        if (((Component)this.target).isMinimumSizeSet()) {
            dimension = ((Component)this.target).getMinimumSize();
        }
        if (dimension != null) {
            int n = WWindowPeer.getSysMinWidth();
            int n2 = WWindowPeer.getSysMinHeight();
            int n3 = dimension.width >= n ? dimension.width : n;
            int n4 = dimension.height >= n2 ? dimension.height : n2;
            this.setMinSize(n3, n4);
        } else {
            this.setMinSize(0, 0);
        }
    }

    public void updateIconImages() {
        List<Image> list = ((Window)this.target).getIconImages();
        if (list == null || list.size() == 0) {
            this.setIconImagesData(null, 0, 0, null, 0, 0);
        } else {
            int n = WWindowPeer.getSysIconWidth();
            int n2 = WWindowPeer.getSysIconHeight();
            int n3 = WWindowPeer.getSysSmIconWidth();
            int n4 = WWindowPeer.getSysSmIconHeight();
            DataBufferInt dataBufferInt = SunToolkit.getScaledIconData(list, n, n2);
            DataBufferInt dataBufferInt2 = SunToolkit.getScaledIconData(list, n3, n4);
            if (dataBufferInt != null && dataBufferInt2 != null) {
                this.setIconImagesData(dataBufferInt.getData(), n, n2, dataBufferInt2.getData(), n3, n4);
            } else {
                this.setIconImagesData(null, 0, 0, null, 0, 0);
            }
        }
    }

    native void setMinSize(int var1, int var2);

    public boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModalBlocked(Dialog dialog, boolean bl) {
        Object object = ((Component)this.getTarget()).getTreeLock();
        synchronized (object) {
            WWindowPeer wWindowPeer = (WWindowPeer)dialog.getPeer();
            if (bl) {
                this.modalBlocker = wWindowPeer;
                if (wWindowPeer instanceof WFileDialogPeer) {
                    ((WFileDialogPeer)wWindowPeer).blockWindow(this);
                } else if (wWindowPeer instanceof WPrintDialogPeer) {
                    ((WPrintDialogPeer)wWindowPeer).blockWindow(this);
                } else {
                    this.modalDisable(dialog, wWindowPeer.getHWnd());
                }
            } else {
                this.modalBlocker = null;
                if (wWindowPeer instanceof WFileDialogPeer) {
                    ((WFileDialogPeer)wWindowPeer).unblockWindow(this);
                } else if (wWindowPeer instanceof WPrintDialogPeer) {
                    ((WPrintDialogPeer)wWindowPeer).unblockWindow(this);
                } else {
                    this.modalEnable(dialog);
                }
            }
        }
    }

    native void modalDisable(Dialog var1, long var2);

    native void modalEnable(Dialog var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getActiveWindowHandles() {
        AppContext appContext;
        AppContext appContext2 = appContext = AppContext.getAppContext();
        synchronized (appContext2) {
            List list = (List)appContext.get(ACTIVE_WINDOWS_KEY);
            if (list == null) {
                return null;
            }
            long[] lArray = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                lArray[i] = ((WWindowPeer)list.get(i)).getHWnd();
            }
            return lArray;
        }
    }

    void draggedToNewScreen() {
        SunToolkit.executeOnEventHandlerThread((Component)this.target, new Runnable(){

            public void run() {
                WWindowPeer.this.displayChanged();
            }
        });
    }

    void clearLocalGC() {
    }

    public void updateGC() {
        int n = this.getScreenImOn();
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)this.winGraphicsConfig.getDevice();
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Win32GraphicsDevice win32GraphicsDevice2 = n >= graphicsDeviceArray.length ? (Win32GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice() : (Win32GraphicsDevice)graphicsDeviceArray[n];
        this.winGraphicsConfig = (Win32GraphicsConfig)win32GraphicsDevice2.getDefaultConfiguration();
        if (win32GraphicsDevice != win32GraphicsDevice2) {
            win32GraphicsDevice.removeDisplayChangedListener(this);
            win32GraphicsDevice2.addDisplayChangedListener(this);
        }
    }

    public void displayChanged() {
        this.updateGC();
        super.displayChanged();
    }

    private native int getScreenImOn();

    public void grab() {
        this.nativeGrab();
    }

    public void ungrab() {
        this.nativeUngrab();
    }

    private native void nativeGrab();

    private native void nativeUngrab();

    private final boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    boolean isTargetUndecorated() {
        return true;
    }

    Rectangle constrainBounds(int n, int n2, int n3, int n4) {
        Win32GraphicsConfig win32GraphicsConfig = this.winGraphicsConfig;
        if (!this.hasWarningWindow() || win32GraphicsConfig == null) {
            return new Rectangle(n, n2, n3, n4);
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        Window window = (Window)this.target;
        Rectangle rectangle = ((GraphicsConfiguration)win32GraphicsConfig).getBounds();
        Insets insets = window.getToolkit().getScreenInsets(win32GraphicsConfig);
        int n9 = rectangle.width - insets.left - insets.right;
        int n10 = rectangle.height - insets.top - insets.bottom;
        if (!this.visible || this.isTargetUndecorated()) {
            int n11 = rectangle.x + insets.left;
            int n12 = rectangle.y + insets.top;
            if (n7 > n9) {
                n7 = n9;
            }
            if (n8 > n10) {
                n8 = n10;
            }
            if (n5 < n11) {
                n5 = n11;
            } else if (n5 + n7 > n11 + n9) {
                n5 = n11 + n9 - n7;
            }
            if (n6 < n12) {
                n6 = n12;
            } else if (n6 + n8 > n12 + n10) {
                n6 = n12 + n10 - n8;
            }
        } else {
            int n13 = Math.max(n9, this.sysW);
            int n14 = Math.max(n10, this.sysH);
            if (n7 > n13) {
                n7 = n13;
            }
            if (n8 > n14) {
                n8 = n14;
            }
        }
        return new Rectangle(n5, n6, n7, n8);
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.constrainBounds(n, n2, n3, n4);
        this.sysX = rectangle.x;
        this.sysY = rectangle.y;
        this.sysW = rectangle.width;
        this.sysH = rectangle.height;
        super.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n5);
    }

    public void print(Graphics graphics) {
        Shape shape = AWTAccessor.getWindowAccessor().getShape((Window)this.target);
        if (shape != null) {
            graphics.setClip(shape);
        }
        super.print(graphics);
    }

    private void replaceSurfaceDataRecursively(Component component) {
        Component[] componentArray;
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            for (int i = 0; i < n; ++i) {
                Component component2 = componentArray[i];
                this.replaceSurfaceDataRecursively(component2);
            }
        }
        if ((componentArray = component.getPeer()) instanceof WComponentPeer) {
            ((WComponentPeer)componentArray).replaceSurfaceDataLater();
        }
    }

    private native void setOpacity(int var1);

    public void setOpacity(float f) {
        if (!((SunToolkit)((Window)this.target).getToolkit()).isWindowOpacityControlSupported()) {
            return;
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The value of opacity should be in the range [0.0f .. 1.0f].");
        }
        if ((this.opacity == 1.0f && f < 1.0f || this.opacity < 1.0f && f == 1.0f) && !Win32GraphicsEnvironment.isVistaOS()) {
            this.replaceSurfaceDataRecursively((Component)this.getTarget());
        }
        this.opacity = f;
        int n = (int)(f * 255.0f);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        this.setOpacity(n);
        this.updateWindow(null);
    }

    private native void setOpaqueImpl(boolean var1);

    public void setOpaque(boolean bl) {
        Object object;
        Window window = (Window)this.getTarget();
        SunToolkit sunToolkit = (SunToolkit)window.getToolkit();
        if (!sunToolkit.isWindowTranslucencySupported() || !sunToolkit.isTranslucencyCapable(window.getGraphicsConfiguration())) {
            return;
        }
        boolean bl2 = this.isOpaque != bl;
        boolean bl3 = Win32GraphicsEnvironment.isVistaOS();
        if (bl2 && !bl3) {
            this.replaceSurfaceDataRecursively(window);
        }
        this.isOpaque = bl;
        this.setOpaqueImpl(bl);
        if (bl2) {
            if (bl) {
                object = this.painter;
                if (object != null) {
                    ((TranslucentWindowPainter)object).flush();
                    this.painter = null;
                }
            } else {
                this.painter = TranslucentWindowPainter.createInstance(this);
            }
        }
        if (bl2 && bl3 && (object = AWTAccessor.getWindowAccessor().getShape(window)) != null) {
            AWTAccessor.getWindowAccessor().setShape(window, (Shape)object);
        }
        this.updateWindow(null);
    }

    native void updateWindowImpl(int[] var1, int var2, int var3);

    public void updateWindow(BufferedImage bufferedImage) {
        if (this.isOpaque) {
            return;
        }
        Component component = (Component)this.target;
        if (component.getWidth() <= 0 || component.getHeight() <= 0) {
            return;
        }
        TranslucentWindowPainter translucentWindowPainter = this.painter;
        if (translucentWindowPainter != null) {
            translucentWindowPainter.updateWindow(bufferedImage);
        } else if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Translucent window painter is null in updateWindow");
        }
    }

    public void paintAppletWarning(Graphics2D graphics2D, int n, int n2) {
    }

    public native void repositionSecurityWarning();

    public void handleEvent(AWTEvent aWTEvent) {
        if (!this.isOpaque && aWTEvent.getID() == 801) {
            this.updateWindow(null);
        } else {
            super.handleEvent(aWTEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initActiveWindowsTracking(Window window) {
        AppContext appContext;
        AppContext appContext2 = appContext = AppContext.getAppContext();
        synchronized (appContext2) {
            LinkedList linkedList = (LinkedList)appContext.get(ACTIVE_WINDOWS_KEY);
            if (linkedList == null) {
                linkedList = new LinkedList();
                appContext.put(ACTIVE_WINDOWS_KEY, linkedList);
                appContext.addPropertyChangeListener("guidisposed", guiDisposedListener);
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.addPropertyChangeListener("activeWindow", activeWindowListener);
            }
        }
    }

    static {
        WWindowPeer.initIDs();
    }

    private static class ActiveWindowListener
    implements PropertyChangeListener {
        private ActiveWindowListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AppContext appContext;
            Window window = (Window)propertyChangeEvent.getNewValue();
            if (window == null) {
                return;
            }
            AppContext appContext2 = appContext = SunToolkit.targetToAppContext(window);
            synchronized (appContext2) {
                WWindowPeer wWindowPeer = (WWindowPeer)window.getPeer();
                boolean bl = window.isFocusableWindow() && window.isVisible() && window.isDisplayable();
                List list = (List)appContext.get(ACTIVE_WINDOWS_KEY);
                if (list != null && bl) {
                    list.remove(wWindowPeer);
                    list.add(wWindowPeer);
                }
            }
        }
    }

    private static class GuiDisposedListener
    implements PropertyChangeListener {
        private GuiDisposedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AppContext appContext;
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (!bl && log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, " Assertion (newValue != true) failed for AppContext.GUI_DISPOSED ");
            }
            AppContext appContext2 = appContext = AppContext.getAppContext();
            synchronized (appContext2) {
                appContext.remove(ACTIVE_WINDOWS_KEY);
                appContext.removePropertyChangeListener("guidisposed", this);
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.removePropertyChangeListener("activeWindow", activeWindowListener);
            }
        }
    }
}

