/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Timer;
import javax.swing.border.Border;

public class AnimatedBorder
implements Border {
    private static final Timer timer = new Timer(true);
    private HashSet scheduledComponents = new HashSet();
    private Border[] borders;
    private long delay;

    public AnimatedBorder(Border[] borders, long delay) {
        this.borders = borders;
        this.delay = delay;
    }

    public Insets getBorderInsets(Component c) {
        return (Insets)this.borders[0].getBorderInsets(c).clone();
    }

    public boolean isBorderOpaque() {
        return this.borders[0].isBorderOpaque();
    }

    public void paintBorder(final Component c, Graphics g, int x, int y, int width, int height) {
        long animTime = System.currentTimeMillis() % ((long)this.borders.length * this.delay);
        int frame = (int)(animTime / this.delay);
        this.borders[frame].paintBorder(c, g, x, y, width, height);
        long sleep = this.delay - animTime % this.delay;
        if (sleep == 0L) {
            sleep = this.delay;
        }
        if (!this.scheduledComponents.contains(c)) {
            this.scheduledComponents.add(c);
            javax.swing.Timer timer = new javax.swing.Timer((int)sleep, new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AnimatedBorder.this.scheduledComponents.remove(c);
                    c.repaint();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }
}

