-- Depictions
sparql
PREFIX foaf: <http://xmlns.com/foaf/0.1/>
SELECT count (*) WHERE { ?x foaf:depiction ?y . } ;

-- Abstracts
sparql SELECT count (*)  WHERE { ?x <http://dbpedia.org/property/abstract> ?y . };


-- Line 15: 
sparql SELECT count (*) WHERE { ?x <http://dbpedia.org/abstract> ?y . };


-- English Language Annotatons (Comments)
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description . FILTER
(LANG(?description) = 'en') . };



-- German Language Annotatons (Comments)
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'de') . };


-- Espanol
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'es') . };


-- French
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'fr') . };


-- Italian
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'it') . };


-- Japanese
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'ja') . } ;

-- Dutch
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'nl') . } ;


-- Line 61:
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'pl') . } ;


-- Portuguese 
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'pt') . } ;



-- Line 73:
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'sv') . } ;



-- Line 79:
sparql
PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
SELECT count (*) FROM <http://dbpedia.org> WHERE { ?x rdfs:comment ?description .  FILTER
(LANG(?description) = 'zh') . } ;


-- References
sparql
SELECT count (*) WHERE { ?x <http://dbpedia.org/property/reference> ?y
. } ;

-- SameAs Links
sparql
 SELECT count (*) WHERE { ?x <http://www.w3.org/2002/07/owl#sameAs> ?y
. } ;

-- Web Page References
sparql SELECT count (*) WHERE { ?x <http://xmlns.com/foaf/0.1/page> ?y . } ;


-- Yago:films
sparql
 SELECT count (*) WHERE { ?x
<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>
<http://dbpedia.org/class/yago/Film106613686>
. } ;


-- People
sparql
 SELECT count (*) WHERE { ?x
<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>
<http://xmlns.com/foaf/0.1/Person>
. } ;


-- Yago:Albums
sparql
 SELECT count (*) WHERE { ?x
<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>
<http://dbpedia.org/class/yago/Album106591815>
. } ;


-- SKOS Subjects
sparql
 SELECT count (*) WHERE { ?x
<http://www.w3.org/2004/02/skos/core#subject> ?y
. } ;


-- Properties
sparql
 SELECT count (*) WHERE { ?x
<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>
<http://www.w3.org/1999/02/22-rdf-syntax-ns#Property>
. } ;



-- Geolocations
sparql
 SELECT count (*) WHERE { ?x
<http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?y
. } ;



-SPARQL

PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX dbpedia: <http://dbpedia.org/property/>
PREFIX yago: <http://dbpedia.org/class/yago/>

SELECT ?s
FROM <http://dbpedia.org>
WHERE {
?s a yago:Book106410904 .
?s dbpedia:name "The Lord of the Rings"@en .
};


-- Query aimed at Books via query scoped to the "Publication" class of which it is a subclass in the Yago Hierarchy
SPARQL
define input:inference 'http://dbpedia.org/resource/inference/rules/yago#'
PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX dbpedia: <http://dbpedia.org/property/>
PREFIX yago: <http://dbpedia.org/class/yago/>

SELECT ?s
FROM <http://dbpedia.org>
WHERE {
?s a yago:Publication106589574 .
?s dbpedia:name "The Lord of the Rings"@en .
};


-- # Testing Virtuoso's Full Text Index extension: bif:contains

SPARQL
define input:inference 'http://dbpedia.org/resource/inference/rules/yago#'
PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX dbpedia: <http://dbpedia.org/property/>
PREFIX yago: <http://dbpedia.org/class/yago/>

SELECT ?s ?n
FROM <http://dbpedia.org>
WHERE {
?s a yago:Publication106589574 .
?s dbpedia:name ?n .
?n bif:contains 'Lord and Rings'
};

-- Retrieve all individuals instances of the Book Class
SPARQL
PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX dbpedia: <http://dbpedia.org/property/>
PREFIX yago: <http://dbpedia.org/class/yago/>

SELECT ?s ?n
FROM <http://dbpedia.org>
WHERE {
?s a yago:Book106410904 .
?s dbpedia:name ?n .
};

-- Retrieve all individuals instances of Publication Class which should include all Books.
SPARQL
define input:inference 'http://dbpedia.org/resource/inference/rules/yago#'
PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX dbpedia: <http://dbpedia.org/property/>
PREFIX yago: <http://dbpedia.org/class/yago/>

SELECT ?s ?n
FROM <http://dbpedia.org>
WHERE {
?s a yago:Publication106589574 .
?s dbpedia:name ?n .
};


--Pure SPARQL Examples: - Query aimed at Books via query scoped to the "Publication" class of which it is a subclass in the Yago Hierarchy
SPARQL

define input:inference 'http://dbpedia.org/resource/inference/rules/yago#'
PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX dbpedia: <http://dbpedia.org/property/>
PREFIX yago: <http://dbpedia.org/class/yago/>

SELECT ?s
FROM <http://dbpedia.org>
WHERE {
?s a yago:Publication106589574 .
?s dbpedia:name "The Lord of the Rings"@en .
};

-- Variant of query with Virtuoso's Full Text Index extension: bif:contains
SPARQL

define input:inference 'http://dbpedia.org/resource/inference/rules/yago#'
PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX dbpedia: <http://dbpedia.org/property/>
PREFIX yago: <http://dbpedia.org/class/yago/>

SELECT ?s ?n
FROM <http://dbpedia.org>
WHERE {
?s a yago:Publication106589574 .
?s dbpedia:name ?n .
?n bif:contains 'Lord and Rings'
};

-- Retrieve all individuals instances of the Book Class
SPARQL
PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX dbpedia: <http://dbpedia.org/property/>
PREFIX yago: <http://dbpedia.org/class/yago/>

SELECT ?s ?n
FROM <http://dbpedia.org>
WHERE {
?s a yago:Book106410904 .
?s dbpedia:name ?n .
};

-- Retrieve all individuals instances of Publication Class which should include all Books.
SPARQL
define input:inference 'http://dbpedia.org/resource/inference/rules/yago#'
PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
PREFIX dbpedia: <http://dbpedia.org/property/>
PREFIX yago: <http://dbpedia.org/class/yago/>

SELECT ?s ?n
FROM <http://dbpedia.org>
WHERE {
?s a yago:Publication106589574 .
?s dbpedia:name ?n .
};
--- Entity Type Stats from DBpedia

--- FOAF People DBpedia Ontology Inferencing On
SPARQL

define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:Person
};

-- Companies
SPARQL

define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:Company
};

-- Places
SPARQL

define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:Place
};

-- Music Genres
SPARQL

define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:MusicGenre
};

-- Works (Books, Magazines, Music, Films, Software etc.)
SPARQL

define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:Work
};

-- Events
SPARQL

define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:Event
};

-- Species
SPARQL
define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:Species
};


-- Diseases
SPARQL
define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:Disease
};

-- Proteins
SPARQL
define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:Protein
};

-- Chemical compounds
SPARQL
define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:ChemicalCompound
};


-- Drugs
SPARQL
define input:inference 'http://dbpedia.org/resource/inference/rules/dbpedia#'
PREFIX dbpedia: <http://dbpedia.org/ontology/>

select distinct count(*)
where
{
?s a dbpedia:Drug
};
