#!/bin/sh

PORT=$1
USER=$2
PASS=$3
file=$4
g=$5
LOGF=`basename $0`.log

if [ -z "$PORT" -o -z "$USER" -o -z "$PASS" -o -z "$file" -o -z "$g" ]
then
  echo "Usage: `basename $0` [DSN] [user] [password] [ttl-file] [graph-iri]"  
  exit
fi

if [ ! -f "$file" -a ! -d "$file" ]
then
    echo "$file does not exists"
    exit 1
fi

mkdir READY 2>/dev/null
rm -f $LOGF $LOGF.*

echo "Starting..."
echo "Logging into: $LOGF"

DOSQL ()
{
    isql $PORT $USER $PASS verbose=on banner=off prompt=off echo=ON errors=stdout exec="$1" > $LOGF
}

DOCPT ()
{
    echo "=======================================" 
    echo " Final checkpoint."  | tee -a $LOGF
    isql $PORT $USER $PASS verbose=off banner=off prompt=off echo=off errors=stdout exec="checkpoint" >> $LOGF
}

LOAD_FILE ()
{
    f=$1 
    g=$2
    bz="`echo $f | grep -e '\.bz2$'`"
    if [ ! -z "$bz" ]
    then
       echo "Decompressing $f ..." | tee -a $LOGF
       bunzip2 $f 
       f="`echo $f | sed -e 's/\\.bz2$//g'`"
    fi
    to_move=$f
    echo "Loading $f (`cat $f | wc -l` lines) `date \"+%H:%M:%S\"`" | tee -a $LOGF
    mv $LOGF $LOGF.save

    DOSQL "ttlp_mt (file_to_string_output ('$f'), '', '$g', 17); checkpoint;" > $LOGF

    if [ $? != 0 ]
    then
	echo "An error occured, please check $LOGF"
	exit 1
    fi

    line_no=`grep Error $LOGF | awk '{ match ($0, /line [0-9]+/, x) ; match (x[0], /[0-9]+/, y); print y[0] }'`
    newf=$f.part
    inx=1
    while [ ! -z "$line_no" ]
    do
	cat $f |  awk "BEGIN { i = 1 } { if (i==$line_no) { print \$0; exit; } i = i + 1 }"  >> bad.nt
	line_no=`expr $line_no + 1`
	echo "Retryng from line $line_no" | tee -a $LOGF.save
	echo "@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> ." > tmp.nt
	cat $f |  awk "BEGIN { i = 1 } { if (i>=$line_no) print \$0; i = i + 1 }"  >> tmp.nt
	mv tmp.nt $newf
	f=$newf
	mv $LOGF $LOGF.$inx
	DOSQL "ttlp_mt (file_to_string_output ('$f'), '', '$g', 17); checkpoint;" > $LOGF

	if [ $? != 0 ]
	then
	    echo "An error occured, please check $LOGF"
	    exit 1
	fi
	line_no=`grep Error $LOGF | awk '{ match ($0, /line [0-9]+/, x) ; match (x[0], /[0-9]+/, y); print y[0] }'`
	inx=`expr $inx + 1`
    done
    rm -f $newf 2>/dev/null
    echo "Loaded.  " | tee -a $LOGF
    mv $LOGF.save $LOGF
    mv $to_move READY 2>> /dev/null
}

echo "======================================="  | tee -a $LOGF
echo "Loading started."  | tee -a $LOGF
echo "======================================="  | tee -a $LOGF

if [ -f "$file" ]
then
    LOAD_FILE $file $g
elif [ -d "$file" ]
then
    for ff in `find $file -name '*.nt' -o -name '*.nt.bz2'` 
    do
	LOAD_FILE $ff $g
    done
else
   echo "The input is not file or directory"  | tee -a $LOGF   
fi
DOCPT
echo "======================================="  | tee -a $LOGF
echo "Check bad.nt file for skipped triples. "  | tee -a $LOGF
echo "======================================="  | tee -a $LOGF

exit 0
