#!/bin/sh

if [ $# -lt 4 ]
then
    echo "Usage `basename $0` [dsn] [user] [password] [email]"
    exit 1
fi

PORT=$1
USER=$2
PASS=$3
MAIL=$4
MAIL_SERVER=${MAIL_SERVER-}
SERVER=virtuoso
LOGF=`basename $0`.log
rm -f $LOGF

DEPS="load_nt.sh dbpedia_dav.vad dbpedia_post.sql dbpedia-ontology.owl umbel_class_hierarchy_v071.n3 umbel_abstract_concepts.n3 umbel_external_ontologies_linkage.n3 yago-class-hierarchy_en.nt umbel_subject_concepts.n3 opencyc-2008-06-10.owl opencyc-2008-06-10-readable.owl"

LOADSQL ()
{
    isql $PORT $USER $PASS verbose=off banner=off prompt=off errors=stdout echo=off < $1 >> $LOGF
}

EXECSQL()
{
    isql $PORT $USER $PASS verbose=off banner=off prompt=off errors=stdout "exec=$1" 
}

SENDMAIL()
{
    n=$1
    rm -f hdr.out smtpsend.out smtpsend.err
    echo 'From: "' "Virtuoso on " `uname -n` '" <virtuoso-nightly-builds@openlinksw.com>' >> hdr.out
    echo "Subject: DBpedia installation status" >> hdr.out
    echo "Date: "`date +"%a, %d %b %Y %T %Z"` >> hdr.out
    echo "" >> hdr.out
    cat $LOGF >> hdr.out
    if [ ! -z "$MAIL_SERVER" ]
    then
	EXECSQL "smtp_send ('$MAIL_SERVER', 'virtuoso-nightly-builds@openlinksw.com', '$n', file_to_string ('hdr.out'))" > smtpsend.out
    else
	ECHO "The MAIL_SERVER environment variable is not set, e.g. export MAIL_SERVER=mail.domain:25"
    fi
}

ECHO()
{
    echo "$*" | tee -a $LOGF
}

# MAIN

ECHO "==============================="
ECHO "  Install started"
ECHO "  "`date`
ECHO "==============================="

if [ ! -f dbpedia.ini ]
then
    ECHO "The required file dbpedia.ini is missing"
    exit 1
fi

if [ ! -d data ]
then
    ECHO "No data directory"
    exit 1
fi

SERVER_STARTED=0
if [ -f dbpedia_data.lck ]
then
    . ./dbpedia_data.lck ; ps -p $VIRT_PID | grep $VIRT_PID > /dev/null
    if [ $? -eq 0 ]
    then
	SERVER_STARTED=1
    fi
fi

if [ $SERVER_STARTED -eq 0 ]
then
    $SERVER 2>/dev/null 
    if [ $? -eq 127 ]
    then
	ECHO "Checking for VOS setup"
	SERVER=$SERVER-t
	$SERVER 2>/dev/null 
	if [ $? -eq 127 ]
	then
	    ECHO "Virtuoso server is not installed or not in the search path, installation is terminated"
	    exit 2
	fi
    fi
    ECHO "Starting Virtuoso server, please wait ..."
    $SERVER -c dbpedia.ini +wait
    if [ $? -ne 0 ]
    then
       ECHO "Cannot start Virtuoso server, please consult dbpedia.log file"
    fi
    ECHO "Started."
else
    ECHO "Virtuoso Server is already started"
fi

EXECSQL "select file_stat('`basename $0`')" | grep -e "[0-9]*-" 2>&1> /dev/null
if [ $? -ne 0 ]
then
    ECHO "This script must be started in server working directory"
    exit 1
fi

ECHO "Checking files"
for f in $DEPS 
do
    if [ ! -f $f ]
    then
	ECHO "The required file $f is not present in server working directory"
	exit 1
    else
	ECHO "$f : present"
    fi
done
ECHO "Installing dbpedia_dav.vad" 
EXECSQL "vad_install ('dbpedia_dav.vad')" >> $LOGF

sh ./load_nt.sh $PORT $USER $PASS data "http://dbpedia.org"
cat load_nt.sh.log >> $LOGF

ECHO "Running post-install scripts" 
LOADSQL dbpedia_post.sql

ECHO "==============================="
ECHO "  Install finished."
ECHO "  "`date`
ECHO "==============================="

SENDMAIL $MAIL
