<?php
if(!isset($gCms)) exit;

// Typical Database Initialization
$db = &$this->cms->db;
$dict = NewDataDictionary($db);
		
// mysql-specific, but ignored by other database
$taboptarray = array("mysql" => "TYPE=MyISAM");
		

// Creates the category table
$flds = "
	description C(255),
	id I KEY,
	name C(64),
	alias C(64),
	item_order I,
	active L,
	isdefault L,
    date_modified ".CMS_ADODB_DT."
	";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_prodcatalogue_category", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_prodcatalogue_category_seq");


// Creates the item table
$flds = "
	description X,
	somecheckbox L,
	dropdownlist I,
	image C(255),
	parent I,
	id I KEY,
	name C(64),
	alias C(64),
	item_order I,
	active L,
	isdefault L,
    date_modified ".CMS_ADODB_DT."
	";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_prodcatalogue_item", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_prodcatalogue_item_seq");


// Creates the table for multiple files
$flds = "
    fileid I,
	itemid I,
	fieldname C(64),
	filepath C(255)
	";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_prodcatalogue_multiplefilesfields", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_prodcatalogue_multiplefilesfields_seq");




// Creates the queries table
$flds = "
    id I,
	name C(64),
	what C(32),
	whereclause C(255),
	wherevalues C(255),
	queryorder C(32)
	";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_prodcatalogue_saved_queries", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_prodcatalogue_saved_queries_seq");


// INSERTING EXAMPLE TEMPLATES
	$template = '<h2>{$leveltitle}</h2>
<ul>
{foreach from=$itemlist item="item"}
	<li {if $item->is_selected}class="active"{/if}>{$item->detaillink}</li>
{/foreach}
</ul>';
	$this->SetTemplate("catlist",$template,$this->GetName());
    $this->SetPreference("listtemplate_category","catlist");
    
    $template = '<h2>{$leveltitle}</h2>
<style>
{literal}
a.listitem {
	padding: 5px 15px;
	display: block;
	height: 90px;
	border-bottom: 1px solid Gray;
	text-decoration: none;
	color: #000;
}
a.listitem img {
	float: right;
	border: 0;
}
a.listitem:hover {
	background-color: LightGray;
}
{/literal}
</style>
{foreach from=$itemlist item="item"}
	<a class="listitem{if $item->is_selected} active{/if}" href="{$item->detailurl}">
{if $item->image != ""}<img src="uploads/{$item->image_thumbnail}" alt=""/>{/if}
<p><br/><b>{$item->name}</b>{if $item->somecheckbox}<br/>The checkbox is checked!{/if}</p></a>
{/foreach}';
	$this->SetTemplate("itemlist",$template,$this->GetName());
    $this->SetPreference("listtemplate_item","itemlist");
    
    
	$template = '<h3>{$item->name}</h3>
{if $item->image != ""}<p><img src="uploads/{$item->image}" alt="{$item->alias}-image"/></p>{/if}
{if $item->somecheckbox}<p>The checkbox is checked!</p>{/if}
<b>{$labels->description}: </b>
<br/>{$item->description}
<p><b>{$labels->dropdownlist}: </b>{$item->dropdownlist_namevalue}</p>
{if count($item->addfiles) > 0}
<b>{$labels->addfiles}: </b><br/>
<ul>
{foreach from=$item->addfiles item="addfile"}
<li><a href="uploads/{$addfile}">{$addfile}</a></li>
{/foreach}
</ul>
{/if}';
	$this->SetTemplate("final_default",$template,$this->GetName());
    $this->SetPreference("finaltemplate","final_default");
    $this->SetPreference("searchresultstemplate", "catlist");


// permissions
$this->CreatePermission("_advanced", ": Advanced");
	$this->CreatePermission("prodcatalogue_manage_category", "prodcatalogue: Manage category");
	$this->CreatePermission("prodcatalogue_manage_item", "prodcatalogue: Manage item");
// events
	$this->CreateEvent("prodcatalogue_added");
	$this->CreateEvent("prodcatalogue_modified");
	$this->CreateEvent("prodcatalogue_deleted");
	
// prepare information for an eventual upgrade
	$this->SetPreference("makerversion","1.8.4");

// put mention into the admin log
	$this->Audit( 0, $this->Lang("friendlyname"), $this->Lang("installed",$this->GetVersion()));

?>
