<?php
if (!isset($gCms)) exit;
$admintheme = $gCms->variables["admintheme"];
if(isset($params["cancel"]) || !$this->CheckPermission("prodcatalogue_manage_item")){
	$newparams = array("active_tab" => "item");
	if(!isset($params["cancel"]))	$newparams["module_message"] = $this->Lang("error_denied");
	$this->Redirect($id, "defaultadmin", $returnid, $newparams);
}

$db =& $this->GetDb();
$parentoptions = $this->get_options("category");
$dropdownlistoptions = $this->get_predefinedoptions("item_dropdownlist");

if( isset($params["deletefile"]) && $params["deletefile"] > 0 ){
	// this is for the multiple files fields (additionnal tabs)
	$query = "DELETE FROM ".cms_db_prefix()."module_prodcatalogue_multiplefilesfields WHERE fileid=? LIMIT 1";
	$db->Execute( $query, array($params["deletefile"]) );
}


if(isset($params["itemid"])) {
	// if we are working on an item that exists, we load it. We must do this even when the form is submitted, otherwise we won't have the file fields
	$items = $this->get_level_item(array("id"=>$params["itemid"]));
	$item = $items[0];
}

// CHECK IF THE FORM IS BEING SUBMITTED :
// (we must detect all kinds of submit buttons, including files, since information must be saved before we go to file submission)
if (isset($params["submit"]) || 
	isset($params["apply"]) ||
	isset($params["add_image"]) ||
	isset($params["remove_image"]) 
	)
{
	debug_buffer("Edit Form has been submitted".__LINE__);

	// RETRIEVING THE FORM VALUES (and escaping it, if needed)
	if(!isset($item)) $item = new stdClass();
	if(isset($params["itemitem_order"])) $item->item_order = $params["itemitem_order"];
	$item->description = $params["itemdescription"];
		$item->somecheckbox = isset($params["itemsomecheckbox"])?$params["itemsomecheckbox"]:0;
		$item->dropdownlist = $params["itemdropdownlist"];
		$item->parent = $params["itemparent"];
		$item->name = $params["itemname"];
		
	$item->alias = $this->plcreatealias($item->name);
	
	// CHECK IF THE NEEDED VALUES ARE THERE
	if(	!isset($params["itemname"]) || $params["itemname"] == ""
		 )
	{
		echo $this->ShowErrors($this->Lang("error_missginvalue"));
	}elseif(false == $this->checkalias("module_prodcatalogue_item", $item->alias, isset($params["itemid"])?$params["itemid"]:false)){
		echo $this->ShowErrors($this->Lang("error_alreadyexists"));
	}else{
		############ DOING THE UPDATE

		// FIELDS TO UPDATE
		$query = (isset($item->id)?"UPDATE ":"INSERT INTO ").cms_db_prefix()."module_prodcatalogue_item SET 
			description=?,
			somecheckbox=?,
			dropdownlist=?,
			parent=?,
			name=?,
		alias=?,
		date_modified=?,
		active=".(isset($item->active)?$item->active:1).",
		isdefault=".(isset($item->isdefault)?$item->isdefault:0)."";
			
		// VALUES
		$values = array($item->description,
			$item->somecheckbox,
			$item->dropdownlist,
			$item->parent,
			addslashes($item->name),$item->alias,str_replace("'","",$db->DBTimeStamp(time())));

		if(isset($item->id)){
			$event = "prodcatalogue_modified";
			$query .= " WHERE id=?;";
			array_push($values,$item->id);
		}else{
			// NEW ITEM
			$event = "prodcatalogue_added";
			// get a new id from the sequence table
			$item->id = $db->GenID(cms_db_prefix()."module_prodcatalogue_item_seq");
			// new items get to the top - so we must put all other items down from one step, and then set this item's order to 1
			$query2 = "UPDATE ".cms_db_prefix()."module_prodcatalogue_item SET item_order=(item_order+1) WHERE parent=?";
			$db->Execute($query2, array($item->parent));
			$query .= ",item_order=1, id=".$item->id;
		}
		$db->Execute($query, $values);

		if(isset($params["oldparent"]) && $params["oldparent"] != $item->parent){
			// the item is changing parent, and we're ordering by parents
			// UPDATE THE ORDER OF THE ITEMS WITH THE OLD PARENT
			$query = "UPDATE ".cms_db_prefix()."module_prodcatalogue_item SET item_order=(item_order-1) WHERE item_order > ? AND parent=?";
			$db->Execute($query, array($item->item_order, $params["oldparent"]));
			// GET NEW ITEM ORDER
			$item->item_order = $this->countsomething("item","id",array("parent"=>$item->parent)) + 1;
			$query = "UPDATE ".cms_db_prefix()."module_prodcatalogue_item SET item_order=? WHERE id=?";
			$db->Execute($query, array($item->item_order, $item->id));
		}

		$redirect = true;
		//if(mysql_affected_rows()){	// mysql-only
		if($db->Affected_Rows()){
			// IF ANYTHING WAS MODIFIED, WE MUST UPDATE THE SEARCH INDEX AND SEND AN EVENT...
			if(isset($event))	$this->SendEvent($event, array("what"=>"item", "itemid" => $item->id, "alias"=>$item->alias));
			debug_buffer("SEARHC INDEX WAS UPDATED ".__LINE__);
			$module =& $this->GetModuleInstance("Search");
			if ($module != FALSE) {
				$text = "$item->description $item->name";
				$module->AddWords($this->GetName(), $item->id, "item", $text, NULL);
			  }
		}elseif(mysql_error()){
			// do not redirect :
			$redirect = false;
			echo $this->ShowErrors(mysql_error());
		}

		// REDIRECTING...
			if(isset($params["add_image"])){
				$params = array("itemid"=>$item->id,"field"=>"image","tablename"=>"prodcatalogue_item","prefix"=>"item", "startdir"=>"images/prodcatalogue", "size"=>"350x350", "thumb"=>"90x90", "crop"=>"1", "cropthumb"=>"1", "mode"=>"image");
				$this->Redirect($id, "browsefiles", $returnid, $params);
			}elseif(isset($params["remove_image"])){
				$params = array("itemid"=>$item->id,"field"=>"image","level"=>"item","tablename"=>"prodcatalogue_item","prefix"=>"item");
				$this->Redirect($id, "assignfile", $returnid, $params);
			}elseif($redirect == false){
			}elseif(isset($params["apply"])){
				$params["module_message"] = $this->lang("message_modified");
			}else{
				$params = array("module_message" => $this->lang("message_modified"), "active_tab"=>"item");
				$this->Redirect($id, "defaultadmin", $returnid, $params);	
			}
	}
	// END OF FORM SUBMISSION
}



/* ## PREPARING SMARTY ELEMENTS
CreateInputText : (id,name,value,size,maxlength)
CreateInputTextArea : (wysiwyg,id,text,name)
CreateInputSelectList : (id,name,items,selecteditems,size)
CreateInputDropdown : (id,name,items,sindex,svalue)
*/

$this->smarty->assign("description_label", $this->Lang("item_description"));
$this->smarty->assign("description_input", $this->CreateTextArea(true,$id,isset($item)?$item->description:"","itemdescription"));
$this->smarty->assign("somecheckbox_label", $this->Lang("item_somecheckbox"));
$this->smarty->assign("somecheckbox_input", $this->CreateInputCheckbox($id,"itemsomecheckbox",1,isset($item)?$item->somecheckbox:0));
$this->smarty->assign("dropdownlist_label", $this->Lang("item_dropdownlist"));
$this->smarty->assign("dropdownlist_input", $this->CreateInputDropdown($id,"itemdropdownlist",$dropdownlistoptions,-1,isset($item)?$item->dropdownlist:0));
$this->smarty->assign("image_label", $this->Lang("item_image"));
$this->smarty->assign("image_input", ((isset($item->image) && $item->image != "")?'<img src="../uploads/'.$item->image.'" /><br/>'.$this->CreateInputSubmit($id,"remove_image",$this->Lang("Remove"))." ":"").$this->CreateInputSubmit($id,"add_image",$this->Lang("item_select_image")));
$this->smarty->assign("name_label", $this->Lang("name"));
$this->smarty->assign("name_input", $this->CreateInputText($id,"itemname",isset($item)?$item->name:"",50,64));
$this->smarty->assign("parent_label", $this->Lang("category"));
$this->smarty->assign("parent_input", $this->CreateInputDropdown($id,"itemparent",$parentoptions,-1,isset($item)?$item->parent:0));if(isset($item)) $this->CreateInputHidden($id, "oldparent", $item->parent);
$this->smarty->assign("itemalias",isset($item->alias)?"(alias : ".$item->alias.")":"");
$this->smarty->assign("edittitle", $this->Lang("edit_item"));

$this->smarty->assign("submit", $this->CreateInputSubmit($id, "submit", lang("submit")));
$this->smarty->assign("apply", (isset($item) && isset($item->id))?$this->CreateInputSubmit($id, "apply", lang("apply")):"");
$this->smarty->assign("cancel", $this->CreateInputSubmit($id, "cancel", lang("cancel")));


// DISPLAYING
if(isset($item) && isset($item->id)){
	$tab = isset($params["active_tab"])?$params["active_tab"]:"item";
	echo $this->StartTabHeaders();
		echo $this->SetTabHeader("item", $this->Lang("item"), ($tab=="item"?true:false));echo $this->SetTabHeader("addfiles", $this->Lang("item_addfiles"), ($tab=="addfiles"?true:false));
		
	echo $this->EndTabHeaders();
	echo $this->StartTabContent();
	echo $this->StartTab("item");

		echo $this->CreateFormStart($id, "edititem", $returnid);
		echo $this->ProcessTemplate("edititem.tpl");
		echo $this->CreateInputHidden($id, "itemid", $item->id);
		if(isset($item) && isset($item->parent)) echo $this->CreateInputHidden($id, "oldparent", $item->parent);
		echo $this->CreateInputHidden($id, "itemitem_order", $item->item_order);
		echo $this->CreateFormEnd();
	
	echo $this->EndTab();
	
	echo $this->StartTab("addfiles");
		echo "<p>".$this->Lang("warning_tab")."</p>";
		$newparams = array("itemid"=>$item->id,"field"=>"item_addfiles","tablename"=>"prodcatalogue_multiplefilesfields","prefix"=>"item", "startdir"=>"", "mode"=>"other", "addfiles"=>true, "active_tab"=>"addfiles");
		echo "<p>".$this->CreateLink($id, "browsefiles", $returnid, $admintheme->DisplayImage("icons/system/newobject.gif", "","","","systemicon")." ".$this->Lang("addafile"), $newparams)."</p>";
		$item->addfiles = $this->getaddfiles("item_addfiles",$item->id);
		if(count($item->addfiles)>0){
			echo "<table>";
			foreach($item->addfiles as $addfile){
				echo '<tr><td><a href="../uploads'.$addfile->filepath.'" target="blank">'.$addfile->filepath."</a></td><td>";
				echo $this->CreateLink($id, $action, $returnid, $admintheme->DisplayImage("icons/system/delete.gif", $this->lang("delete"),"","","systemicon"), array("itemid"=>$item->id, "deletefile"=>$addfile->fileid, "active_tab"=>"addfiles"));
				echo "</td></tr>";
			}
			echo "</table>";
		}
	echo $this->EndTab();
	
	echo $this->EndTabContent();
	

}else{
	echo $this->CreateFormStart($id, "edititem", $returnid);
	echo $this->ProcessTemplate("edititem.tpl");
	echo $this->CreateFormEnd();
}
?>