<?php

/*	====================================================================================================
	
	content_dump - Version 0.6
	by Nils Haack <contentdump@opticalvalve.com>
	
	See help information for plug-in at the end (display in help section) or wiki 
	for detailled information about the use of this etension.
	
	====================================================================================================  */

/*
	Little Helper Function: id_array_make
	====================================================================================================
	adds ID of something (the item) to a list of IDs (the array).  If the ID already is part of the array,
	don't add it. Later on, we use this array of IDs (all required parents or users for our pages in the later content_dump) and
	use them for a query looking for more data
*/

function id_array_make($thearray,$theitem) {

	$found = 'false';
	$size = count($thearray);
	
	for ($q=0; $q<=$size-1; $q++){
		if ($thearray[$q] == $theitem) {
			$found = 'true';
		}
	}
	
	if ($found <> 'true') {
		$thearray[$size] = $theitem;
		$id_array_make = $thearray;
	} 
	
	return $thearray;
}

/*
	Look-Up Function: serve_parent_data
	====================================================================================================
	Looks for alias and content-name (=title) of the pages we require this data for (our previously build array of parent 
	pages). Afterwards, provide an array of classes to be used for adding the data to the items in our content_dump.
*/

function serve_parent_data($arraydata) {

	/* Get Global data */
		global $gCms;

	/* Get Database Configuration/Connection */
		$db = &$gCms->db;
		$sql_parents_query_start = "
			SELECT
				content_id,
				content_alias,
				content_name
			FROM
				".cms_db_prefix()."content
		";
				
		$size = count($arraydata);
		
		for ($i=0; $i<=$size-1; $i++){
		if ($i == 0) { $sql_parent_query_what .= " WHERE "."\n"."  content_id = ".$arraydata[$i]."\n";}
		if ($i > 0) {$sql_parent_query_what .= " OR content_id = ".$arraydata[$i]."\n";}
		}		

		$sql_parents_query = $sql_parents_query_start.'		'.$sql_parent_query_what;

		$dbparents = $db->Execute( $sql_parents_query );

		if( !$dbparents )
		{
		    echo 'DB error: '. $db->ErrorMsg()."<br/>";			
		}

		$parents_dump = array();

		while ($dbparents && $dbparentsrow = $dbparents->FetchRow())
		{
			$parent = new StdClass;
				$parent->id = $dbparentsrow['content_id'];
				$parent->alias = $dbparentsrow['content_alias'];
				$parent->title = $dbparentsrow['content_name'];
			$parents_dump[] = $parent; 
		}
		return $parents_dump;
	}


	
/*
	Look-Up Function: server_user_data
	====================================================================================================
	Looks up all users' information (ID, username, first & last name as well as email)  and apss them on as an
	array of classes. This will data be used to provide user details to each post
*/

function serve_user_data($arraydata) {
	/* Get Global data */
		global $gCms;

	/* Get Database Configuration/Connection */
		$db = &$gCms->db;
		
		$sql_users_query_start = "
			SELECT
				user_id,
				username,
				first_name,
				last_name,
				email
			FROM
				".cms_db_prefix()."users
			";
			
		$size = count($arraydata);
		
		for ($i=0; $i<=$size-1; $i++){
		if ($i == 0) { $sql_user_query_what = " WHERE "."\n"."  user_id = ".$arraydata[$i]."\n";}
		if ($i > 0) {$sql_user_query_what = $sql_user_query_what."  OR user_id = ".$arraydata[$i]."\n";}
			
		}
		
		$sql_users_query = $sql_users_query_start.'	'.$sql_user_query_what;
	
		$dbuser = $db->Execute( $sql_users_query );

		if( !$dbuser )
		{
		    echo 'DB error: '. $db->ErrorMsg()."<br/>";
		}

		$serve_user_data = array();

		while ($dbuser && $dbuserrow = $dbuser->FetchRow())
		{
			$user = new StdClass;
				$user->id = $dbuserrow['user_id'];
				$user->username = $dbuserrow['username'];
				$user->first_name = $dbuserrow['first_name'];
				$user->last_name = $dbuserrow['last_name'];
				$user->email = $dbuserrow['email'];
			$serve_user_data[] = $user;
		}
		
		return $serve_user_data;
}


/*
	Look-Up Function: serve_max_page
	====================================================================================================
	Provide the number of the highest page available.
*/

function serve_max_page($content,$count,$offset,$sql_exludes) {
	/* Get Global data */
		global $gCms;			
	/* Get Database Configuration/Connection */
			
		/* No extension required so we only check for the single specified block*/
		$sql_query_where = "Where prop_name='".$content."' ";
		
		for ($i=0; $i<=count($sql_exludes)-1; $i++) {
			$sql_query_excludes .= "AND ".cms_db_prefix()."content_props.content_id != ".$sql_exludes[$i]." \n";
		}	
			
		$db = &$gCms->db;
		
		$sql_user_query = "
		SELECT
		    content_id,
			prop_name
		FROM
		".cms_db_prefix()."content_props
		".$sql_query_where."										
		".$sql_query_excludes;
		
		$dbcontent = $db->Execute( $sql_user_query );

		if( !$dbcontent ) {
		    echo 'DB error: '. $db->ErrorMsg()."<br/>";
		}
		
		if ($dbcontent->RecordCount() >= 1) {
			$serve_max_page = ceil(($dbcontent->RecordCount()-$offset) / $count);
			return $serve_max_page;		
		} else {
			return false;
		}
		
}


/*
	Little Helper Function: sql_fort_param
	====================================================================================================
	is a function that allows the user to use simple words instead of the table column names to sort data
 	additionally, it makes it easy to expand the sql query string
*/

function sql_sort_param($sort_by,$flag,$order) {
/* If equal 0 the parameter is the first and thus the mySQL command ORDER BY will be added to the string */
if ($flag == 0) {$sql_sort_param = ' ORDER BY ';}

	/* Userfriendly selection of table columns for sorting*/
	switch($sort_by){
		case id: $sql_sort_param = $sql_sort_param.'content_id'; break;
		case alias: $sql_sort_param = $sql_sort_param.'content_alias'; break;
		case title: $sql_sort_param = $sql_sort_param.'content_name'; break;	
		case show: $sql_sort_param = $sql_sort_param.'show_in_menu'; break;
		case created: $sql_sort_param = $sql_sort_param.'create_date'; break;
		case modified: $sql_sort_param = $sql_sort_param.'modified_date'; break;
		case owner: $sql_sort_param = $sql_sort_param.'owner_id'; break;
		case hierarchy: $sql_sort_param = $sql_sort_param.'id_hierarchy'; break;
		case lasteditor: $sql_sort_param = $sql_sort_param.'last_modified_by'; break;	
		case active: $sql_sort_param = $sql_sort_param.'active'; break;
		default: $sql_sort_param = $sql_sort_param.'content_id'; break;
	}

	/* checks if the sorting order is set to from bottom to top, if not, it will set it to the reverse*/
	if ($order == 'up') {$sql_sort_param = $sql_sort_param.' ASC ';} else {$sql_sort_param = $sql_sort_param.' DESC ';}		
	
	/* If smaller/equal 1 the parameter is not the last and will be seperated with a comma from the next one */
	if ($flag >= 1) {$sql_sort_param = ', '.$sql_sort_param;}
	
	return $sql_sort_param;
}





/*
	Little Helper Function: strip_out
	====================================================================================================
	Either strips out smarty or HTML (incl JS and CSS)
*/

function strip_out($content,$mode) {

	$htmlexpressions = array('@<script[^>]*?>.*?</script>@si',  // Strip out javascript
               '@<style[^>]*?>.*?</style>@siU',    		// Strip style tags properly
               '@<[\/\!]*?[^<>]*?>@si',            		// Strip out HTML tags
               '@<![\s\S]*?--[ \t\n\r]*>@'         		// Strip multi-line comments including CDATA
	);

	if ($mode == 'html') {$strip_out = preg_replace($htmlexpressions, '', $content);} 
	elseif ($mode == 'smarty') {$strip_out = preg_replace('/\{.*?\}/', '', $content);} 	
	return $strip_out;
}



/*
	Main Plug-in Action
	====================================================================================================
	This is the real deal
*/

function smarty_cms_function_content_dump($params, &$smarty) {

/*
	Parameter Handling
	====================================================================================================
	Assign all parameters to internally used variables. By doing so, check for existance and assign default values if not 
	specified. Some of the main sql query string is assembled here.
*/

	/*  Check if parent page data should be included in  results entries */
		if ($params['parents'] == 'true') {$parents = true;}
		else {$parents = false;}
		
	/*  Check if user data should be looked up for each entry  */
		if ($params['users'] == 'true') {$users = true;}
		else {$users = false;}

	/*  Check for which content block to pick - if not set, pick default "contetn_en"  */
		if ($params['block_name']) {$block = $params['block_name'];}
		else {$block = 'content_en';}
		$sql_content_query_having = " HAVING prop_name='".$block."' "."\n";
		
	/*  Set a date format for your Content entries  */
		if ($params['dateformat']) {$dateformat = $params['dateformat'];}
		else {$dateformat = '%A, %e %B %Y';}
	
	/*  Check if start id is set, if so, tag will ony return pages that have this id or are located below  */
		if ($params['start_id']) {$sql_content_query_limit_sitearea = " AND id_hierarchy REGEXP '".$params['start_id']."' ";}
		else {$sql_content_query_limit_sitearea = ''; }
	
	/*  Check if first sorting item-sort-order is set - otherwise set to default , which is upwards */
		if ($params['first_sort_order']) {$first_sort_order = $params['first_sort_order'];}
		else {$first_sort_order = 'up';}

	/*  Check if second sorting item-sort-order is set - otherwise set to default , which is upwards */
		if ($params['second_sort_order']) {$second_sort_order = $params['second_sort_order'];}
		else {$second_sort_order = 'up';}	
		
	/*   Check for first sort parameter, if not set, first sort parameter will be the hierarchy date of the page  */
		if ($params['first_sort']) {$sql_content_query_first_sort = sql_sort_param($params['first_sort'],0,$first_sort_order);}
		else {$sql_content_query_first_sort = sql_sort_param('hierarchy',0,'up');}

	/*  Check for second sort parameter, if not set, second sort parameter will be the creation date of the page  */
		if ($params['second_sort']) {$sql_content_query_second_sort = sql_sort_param($params['second_sort'],2,$second_sort_order);}
		else {$sql_content_query_second_sort = '';}

	/*  Check for parameter exclude, if it contains ID(s) seperated by comma, it will create an array of IDs we can exclude later on  */
		if ($params['exclude']) {
			$exclude_ids = explode(",", $params['exclude']); 
			for ($i=0; $i<=count($exclude_ids)-1; $i++) {
				$sql_content_query_excludes .= "AND ".cms_db_prefix()."content.content_id != ".$exclude_ids[$i]." \n";
			}
		} else {
			$exclude_ids[0] = -1;
		}	
		
	/*   Limit the query results to a singe content_id by adding a condition to the query statement - if not set, do not add anything to the query string  */
		if ($params['this_only']) {$sql_content_query_this_only = "AND ".cms_db_prefix()."content.content_id = ".$params['this_only'];}
		else {$sql_content_query_this_only = '';}	

	/*  If set to compile, smarty tags in the content will be compiled - set to false per default !WARNING! MAY CAUSE RECURSION AND ULTIMATELY OUT OF MEMORY ERROR */
		if ($params['do_smarty']) {
			switch($params['do_smarty']){
					case neutral: $c_smarty = 'neutral' ; break;
					case compile: $c_smarty = 'compile';  break;
					case strip: $c_smarty = 'strip';  break;
					default: $c_smarty = 'neutral'; break;
				}
		} else {$c_smarty = 'neutral';}
 
	/*  If set to strip, HTML tags in the content will be removed (inluding JS, CSS and HTML) */
		if ($params['html'] == 'strip') {$c_html = 'strip';
		} else {$c_html = 'neutral';}
		
	/*  Check and set how the "active" page flag is handled */
		if ($params['active']) {
				switch($params['active']){
					case force: $sql_content_query_active = ' ' ; break;
					case active: $sql_content_query_active = ' AND active = 1 '."\n";  break;
					case inactive: $sql_content_query_active = ' AND active = 0 '."\n";  break;
					default: $sql_content_query_active = ' AND active = 1 '."\n"; break;
				}
		} else {$sql_content_query_active = ' AND active = 1 '."\n";}
		
	/*  Check and set how the "show_in_menu" page flag is handled */
		if ($params['show_in_menu']) {
				switch($params['show_in_menu']){
					case force: $sql_content_query_show = ' ' ; break;
					case show: $sql_content_query_show = ' AND show_in_menu = 1 '."\n" ; break;
					case hidden: $sql_content_query_show = 'AND show_in_menu = 0 '."\n" ; break;
					default: $sql_content_query_show = ' AND show_in_menu = 1 '."\n"; break;
				}
		} else {$sql_content_query_show = ' AND show_in_menu = 1 '."\n";}

	/*  Set the first item to show, if not set, it will begin with the first item shown  */
		if ($params['limit_start']) {
			$limit_start = $params['limit_start'];
			$limit_start_orig = $params['limit_start'];
		} else {
			$limit_start = 0;
			$limit_start_orig = 0;
		}	
		
	/*   Set the number of items to show, if no parameter is set, limit to 1000 results */
		if ($params['limit_count']) {
			$limit_count = $params['limit_count'];
			$limit_count_orig = $params['limit_count'];
		} else {
			$limit_count = 1000;
			$limit_count_orig = 1000;
		}
		
	/*   if parameter extension is used, explode prop_names and store in an array */
	
		if ($params['extensions']) {	
			$extensions = array ();
			$extensions = explode(",", $params['extensions']);
			$count_extensions = count($extensions);
			
			for ($i=0; $i<=$count_extensions-1; $i++){ 
				$sql_content_query_props .= " OR prop_name='".$extensions[$i]."' "."\n";	
			}
			$limit_count = $limit_count*($count_extensions+1);
			if ($limit_start >= 1 ){$limit_start = ($limit_start*($count_extension+1))-1;}
			
			$extension = true;	
		}	
	
	/*  Check if parameter page specified a page to display, does only make send when used with limit_count, which is the page size */
	
		if ($params['page'] != '') {		
			$page_number = $params['page'];
			// There is ni negative page or a page numbered zero
			if ($page_number <= 0) {$page_number = 1;}
			
			if ($page_number == 1) {
			// Page is one, we do not need to change anything
			} elseif ($page_number == 2) {	
			// this is the second page, 
				if ($limit_start == 0) {$limit_start = $limit_count;}				
				else {$limit_start = $limit_start + $limit_count-1;}
			} elseif ($page_number >=3) {
			// and this any following page
				if ($limit_start == 0) {$limit_start = $limit_count*($page_number-1);}				
				else {$limit_start = $limit_start + ($limit_count*($page_number-1))-1;}			
			}
			
			$pager_info = new StdClass;
				$pager_info->current = $page_number;
				$pager_info->max = serve_max_page($block,$limit_count_orig,$limit_start_orig,$exclude_ids);
				$pager_info->size = $limit_count_orig;
		}		


	/*  If start and count are not set, ignore the output limit and give back everything, else: assemble mysql limit statement */
		if( $params['limit_start'] or $params['limit_count']) {$sql_content_query_limit = ' LIMIT '.$limit_start.' , '.$limit_count;}
			
		
	/* Get Global CMS Information */
		global $gCms;

	/* Get Database Configuration/Connection */
		$db = &$gCms->db;


/*
	Starting query element for final content query
	====================================================================================================
*/

	$sql_content_query_start = "
		SELECT
			".cms_db_prefix()."content.content_id as content_id,
			content_name,
			show_in_menu,
			".cms_db_prefix()."content.create_date,
			".cms_db_prefix()."content.modified_date,
			owner_id,
			id_hierarchy,
			parent_id,
			last_modified_by,
			active, 
			prop_name,
			content,
			content_alias

		FROM
			".cms_db_prefix()."content, ".cms_db_prefix()."content_props

		WHERE
			".cms_db_prefix()."content.content_id = ".cms_db_prefix()."content_props.content_id			

		";
		
/*
	Assemble Content Query Link
	====================================================================================================
	>> Put all mysql query elements into one string
*/

	$sql_the_full_query =
		$sql_content_query_start.'
		'.$sql_content_query_excludes.'
		'.$sql_content_query_active.'
		'.$sql_content_query_show.'
		'.$sql_content_query_this_only.'
		'.$sql_content_query_limit_sitearea.'		
		'.$sql_content_query_having.'		
		'.$sql_content_query_props.'
		'.$sql_content_query_first_sort.'
		'.$sql_content_query_second_sort.'
		'.$sql_content_query_limit;
/*
	Execute mysql Command
	====================================================================================================
*/
		$dbresult = $db->Execute( $sql_the_full_query );

		if( !$dbresult )
		{
		    echo 'DB error: '. $db->ErrorMsg()."<br/>";
		}


/*
	Store Database Results in Array of Classes
	====================================================================================================
	>> Go for each mySQL Query result row and assign each row with its contents to a class called dump_item	
*/

	/* if we use extension checking... we need an extra array */
	if ($extension == true) {
		$content_props = array();
		$counter = 0;
	}

	$content_dump = array();
	$parent_ids = array();
	$user_ids = array();		
	$dump_count = 0;
	
	while ($dbresult && $dbqueryresultrow = $dbresult->FetchRow())
		{
			/*  Store the data of items with prop_name (=block-name) of parameter "block" into an array - this is our main content_dump item data*/
			if ($dbqueryresultrow['prop_name'] == $block) {
				
				$dump_item = new StdClass;
					$dump_item->item = $dump_count;
					
					$dump_item->content->id = $dbqueryresultrow['content_id'];
					$dump_item->content->alias = $dbqueryresultrow['content_alias'];
					$dump_item->content->title = $dbqueryresultrow['content_name'];	
					$dump_item->content->show = $dbqueryresultrow['show_in_menu'];
					$dump_item->content->active = $dbqueryresultrow['active'];
					$dump_item->content->data = $dbqueryresultrow['content'];
					
					/* See if the ID of this pages parent is already known as a page for which we need to lookup name and alias later on*/
					if ($parents = true) { 
						$parent_ids = id_array_make($parent_ids,$dbqueryresultrow['parent_id']);
					}					
									
					$dump_item->parents->id = $dbqueryresultrow['parent_id'];	
					$dump_item->parents->alias = '';	 		
					$dump_item->parents->title = '';

					if ($users = true) { 
						$user_ids = id_array_make($user_ids,$dbqueryresultrow['owner_id']);
						$user_ids = id_array_make($user_ids,$dbqueryresultrow['last_modified_by']);						
					}										

					$dump_item->created->by = $dbqueryresultrow['owner_id'];
					$dump_item->created->date = strftime($dateformat,strtotime($dbqueryresultrow['create_date']));
					$dump_item->modified->by = $dbqueryresultrow['last_modified_by'];
					$dump_item->modified->date = strftime($dateformat,strtotime($dbqueryresultrow['modified_date']));		
								
					$dump_item->extension = 0;
					
				$content_dump[] = $dump_item;
				$dump_count = $dump_count+1;
				
			} elseif (($extension == true) AND ($dbqueryresultrow['content'] != '')) {
			// If the content block is not our primary content block, let's check if we should assign it to our buffer array, that stores all the other props
				$content_props[$counter]['content_id'] = $dbqueryresultrow['content_id'];
				$content_props[$counter]['content'] = $dbqueryresultrow['content'];
				$content_props[$counter]['prop_name'] = $dbqueryresultrow['prop_name'];
				$counter = $counter + 1;
			}	
	}
	

	
/*
	Get the extra data into the reults (if needed)
	====================================================================================================
	>> To do so, we look at each result entry and compare it to the single data options (parents, extensions, users as well as strip options)	
*/
	
	$count_content_dump = count($content_dump);	

	if ($parents == true) {
		$theparents = array();
		$theparents = serve_parent_data($parent_ids);
		$count_theparents = count($theparents);	
	}

	if ($users == true) {
		$theusers = array();
		$theusers = serve_user_data($user_ids);
		$count_theusers = count($theusers);
	}
	
	if ($extension == true) {		
		$count_content_props = count($content_props);	
	}

for ($i=0; $i<=$count_content_dump-1; $i++){

	if ($parents == true) {			
		// Compare against parent IDs to expand parents data 
		for ($k1=0; $k1<=$count_theparents-1; $k1++){
			if ($content_dump[$i]->parents->id == $theparents[$k1]->id){
				/* Yeay... we found the parent page of our content_dump item...  */
				$content_dump[$i]->parents->alias = $theparents[$k1]->alias;			
				$content_dump[$i]->parents->title = $theparents[$k1]->title;					
			break;
			}		
		}		
	}

	if ($users == true) {
		// Compare against user_ids IDs to expand user data (extensions)
		for ($k3=0; $k3<=$count_theusers-1; $k3++){		
			if ($content_dump[$i]->created->by == $theusers[$k3]->id) {
				// we found the user who created the page
				$content_dump[$i]->created->by = $theusers[$k3];
			}
			if ($content_dump[$i]->modified->by == $theusers[$k3]->id) {
				// we found the user who made the last modification
				$content_dump[$i]->modified->by = $theusers[$k3];
			}
		}
	}

	if ($extension == true) {
		// Compare against content_prop IDs to expand entry data (extensions)
		
		for ($k2=0; $k2<=$count_content_props-1; $k2++){
			if ($content_dump[$i]->content->id == $content_props[$k2]['content_id']){
				//We found out that there is some extra content for this page, so let's flag the item
				$content_dump[$i]->extension = 1;
				//Now let's assign the data (remember: only when available) to class names (we use the prop_names as class-names)
				$content_dump[$i]->extensions->$content_props[$k2]['prop_name']->data = $content_props[$k2]['content'];
								
					if ($c_smarty == "compile") {
						// Extension data fields should be compiled
						$smarty->_compile_source('temporary template', $content_dump[$i]->content->data, $_compiled);			
						@ob_start();
						$smarty->_eval('?>' . $_compiled);
						$content_dump[$i]->content->data = @ob_get_contents();
						@ob_end_clean();		
					} elseif ($c_smarty == "strip") {
						// Extension data field should be stripped
						$content_dump[$i]->content->data = strip_out($content_dump[$i]->content->data,'smarty');
					} else {
					}	
					
					if ($c_html == "strip" ) {
						// HTML, JS and inline styles should be stripped
						$content_dump[$i]->extensions->$content_props[$k2]['prop_name']->data = strip_out($content_dump[$i]->extensions->$content_props[$k2]['prop_name']->data,'html');
					}	
				$content_dump[$i]->extensions->$content_props[$k2]['prop_name']->length = strlen($content_dump[$i]->extensions->$content_props[$k2]['prop_name']->data);
			}		
		}
	}	

	if ($c_smarty == "compile") {
		if ($content_dump[$i]->content->id != $gCms->variables['content_id']) {	
		// ^prevent calling page to be processed in smarty 		
			// THX to NaN for the great hint with the smarty processing
			$smarty->_compile_source('temporary template', $content_dump[$i]->content->data, $_compiled);			
			@ob_start();
			$smarty->_eval('?>' . $_compiled);
			$content_dump[$i]->content->data = @ob_get_contents();
			@ob_end_clean();		
		}	
	} elseif ($c_smarty == "strip") {
		$content_dump[$i]->content->data = strip_out($content_dump[$i]->content->data,'smarty');
	}		
	if ($c_html == "strip" ) {
		$content_dump[$i]->content->data = strip_out($content_dump[$i]->content->data,'html');
	}
}

/*
	Return Results
	====================================================================================================
	Only thing left... assign our result to smarty... and the you can go templating like crazy ;)
*/	
	
	$smarty = &$gCms->GetSmarty();
	$smarty->assign('dump', $content_dump);
	$smarty->assign('pager_info', $pager_info);
	return;
}

function smarty_cms_help_function_content_dump() {
?>
<h3>Version info: 0.6</h3>
<p>This plug-in version was created: 30 - Okt - 2008</p>
<h3>What can "content dump" do for you? </h3>
<p>"Content Dump" is the swiss army knife amongst the options for dumping your sites content 
into a single page. It offers a variety of independent parameters than can be combined to 
cater for a lot of your site internal content distribution needs.</p>
<p>Just attach some parameters and limit/organize the output to your data requirements. The
 smarty output allows you to freely design the results in your template or content block 
 (from the regular editors view, though you should always prefer to do it in the template). With smarty you can even control the output by limiting 
 it to specific values (e.g. only user "John Doe") or use modifiers to further manipulate 
 the content.</p>
<p><strong>For daily CMS needs - just like a swiss army knife - just like CMSMS.</strong></p>
<h3>---------------------------<br />Parameters:<br />---------------------------</h3>
<p>Following a description of the available parameters. You do not have to obey a specific order for them. Also you can use none of them or all 19, it's up to you...</p>

<h4>---------------------------<br />
Select items<br />
---------------------------</h4>

<p><em>Selecting the main content-block</em></p>
<p><strong>block_name</strong> can be used to define the content block you want to use as the $dump[n]->content->data element. Per default, it will be <em>"content_en"</em>, the page standard content block. If the block you want to show is {content block="summary"} in your source page's template, you would call it like in the following example:</p>
<p><code>{content_dump block_name="summary"}</code></p>

<p>---</p>
<p><em>Where should the dump begin?</em></p>
<p><strong>start_id</strong> can be used to define a starting point for your content collection. If not specified, it will begin with id <em>"-1"</em> and thus include all matching pages from all pages. A nice trick to use the tag in several pages based on the same template and limit the tag to this site area is to set <em>start_id=$content_id</em>. This way, you use the viewed page's id as the initial page and ignore all other content folders.</p>
<p><code>{content_dump start_id=16}
</code></p>

<p>---</p>
<p><em>Skip the first X items (offset).</em></p>
<p><strong>limit_start</strong> will allow you to do that. State the number of the item you would like your output to begin with. <em>Default is 0</em></p>
<p><code>{content_dump limit_start=5}</code></p>

<p>---</p>
<p><em>Limit the output to a specific number of items.</em></p>
<p><strong>limit_count</strong> can be used to limit the output to a specific number. In combination with page, it will define the size of a page.</p>
<p><code>{content_dump limit_count=10}</code></p>

<p>---</p>
<p><em>How can I paginate content_dump?</em></p>
<p><strong>page</strong> can be used to generate a page based view. Value is <em>page number</em>. It will basically move the view you have on the results by the number of items specified in limit_count. It alters the limit_start by adding limit_count to it, each time an increasing page is selected. Let's say you have limit_start=0 and limit_count=5, page=2 will alter limit_start to be 6.</p>
<p>Usage of this parameter will provide some extra smarty data elements. $pager_info->current, $pager_info->max and $pager_info->size. Representing the currently selected page, the maximum page available and the page size. Use smarty and this data to build easy and complex pagers alike.</p>
<p><code>{content_dump limit_count=5 page=2}</code></p>

<p>---</p>
<p><em>Show also inactive pages or only inactive pages.</em></p>
<p><strong>active</strong> can be used to control how the ACTIVE flag of pages should be interpreted. "force" shows all pages regardless of status. "active" show active pages only (default). "inactive" show inactive pages only.</p>
<p><code>{content_dump active="force"}
</code></p>

<p>---</p>
<p><em>Show in menu - what about that?</em></p>
<p><strong>show_in_menu</strong> can be used to control how the SHOW_in_menu flag of pages should be interpreted. "force" shows all pages regardless of status. "show" show pages set to "Show in Menu" only (default). "hidden" show pages that are set to "Don't Show in Menu" only.</p>
<p><code>{content_dump show_in_menu="hidden"}
</code></p>



<h4>---------------------------<br />
Exclude items<br />
---------------------------</h4>

<p><em>Exclude single items from the list</em></p>
<p><strong>exclude</strong> allows you to remove specific pages from the results. It takes any number of content <em>IDs seperated by comma</em>. Especially when forcing content_dump to compile smarty in found content-blocks, you can use this tag to break endless recursions or for any other reason where you want specific pages not to appear.</p>
<p><code>{content_dump exclude="13,23,53,12,32"}
</code></p>

<p>---</p>
<p><em>Just show the data of a specific element</em></p>
<p><strong>this_only</strong> is a parameter that will limit the result to this specific ID.</p>
<p><code>{content_dump this_only=55}
</code></p>


<h4>---------------------------<br />
Add more data to the item<br />
---------------------------</h4>
<p><em>Get more information about parent pages</em></p>
<p><strong>parents</strong> can be used to request more information about the parent pages (alias and title). Possible values are <em>true or false</em>. Using this parameters allows you to use the data element $dump[n]->parents->alias or $dump[n]->parents->title. The data element $dump[n]->parents->id will be provided in any case. Per default it is deactivated.<br />
</p>
<p><code>{content_dump parents=true}
</code></p>

<p>---</p>
<p><em>Get more information about users that wrote/edited the content</em></p>
<p><strong>users</strong> can be used to request more information about the users who last edited and created the content. Possible values are <em>true or false</em>. Per default $dump[n]->created->by and $dump[n]->modified->by will only return the user ID. If set to true, the mentioned class elements will be expanded by detailed user info (first-, last- and user name).</p>
<p><code>{content_dump users=true}
</code></p>

<p>---</p>
<p><em>I want to use more content-blocks from the pages</em></p>
<p><strong>extensions</strong> is your choice then. It takes a <em>comma seperated list of content_blocks</em>. If any of them (for an item) features content, $dump[n]->extension will be "1", other wise it will be "0" (default). This can be used to check for availability of "more" data. Each content_block will be added as a class below $dump[n]->extensions. E.g. {content block="more_text"} will be available as $dump[n]->extensions->more_text->data together with $dump[n]->extensions->more_text->length. Ideally, your content block names do not feature special charcacters and not " " or "-", use "_" instead.</p>
<p><code>{content_dump extensions="summary,image,other_block_name"}</code></p>

<h4>---------------------------<br />
Process data from items<br />
---------------------------</h4>

<p><em>Change the date format to someting else</em></p>
<p><strong>dateformat</strong> can be used to format the date output of content_dump. Check <a href="http://de.php.net/strftime" target="blank">http://de.php.net/strftime</a> for more ifo on the date format options. Per default it is set to <em>"%A, %e %B %Y"</em> (e.g. Sat, 20 September 2008). It is used for the two time stamps $dump[n]->created->date and $dump[n]->modified->date that are always returned with each item.</p>
<p><code>{content_dump dateformat="%A, %e %B %Y"}
</code></p>

<p>---</p>
<p><em>I want smarty from content-fields to be compiled, or removed</em></p>
<p><strong>do_smarty</strong> controls how smarty data that may be retrieved should be handled. There are three options <em>"compile, neutral and strip"</em>. "compile" compiles smarty data in in the pages found. "neutral" prints out the smarty code as regular text and is the default setting. "strip" deletes all smarty code from your page (well, everything between { and }).</p>
<p>However, be carefull not to construct a query that would have to compile 
itself, this will result in an out of memory error due to endless recursion.
If you use this tag only once with the compile parameter in your site, 
no problem, it prevents itself from being rendered. But if you have 
another occurences of this tag that would include the page that 
is calling the currently processed tag with compile="true", you should 
exclude all of these pages (content dump does not check for the compile 
parameter of other occurences of the tag).</p>
<p>If that called tag would feature other content blocks.. then again all would work nice. Just do not construct something with content_dump that is somewhere in the chain of events compiling itself.</p>
<p><code>{content_dump do_smarty="compile"}
</code></p>

<p>---</p>
<p><em>Remove HTML from content elements so I can safely truncate the data</em></p>
<p><strong>html</strong> is a parameter that allows you to remove any HTML, JavaScript and CSS from a content-block. <em>"strip" and "neutral" are the available options. "Neutral" will display the content as it is (after processing do_smarty settings) and is the default setting. "Strip" will remove the mentioned elements. </em></p>
<p><code>{content_dump html="neutral"}
</code></p>

<h4>---------------------------<br />
Sort items<br />
---------------------------</h4>

<p><em>Primary sorting of data elements</em></p>
<p><strong>first_sort</strong> sorts the found content by one of the following values: <em>id, title, created, modified, owner, hierarchy (default), lasteditor, active, show (show in menu)</em>. For time based (like newest contents) use created, for last updated lists use modified (both need to be reversed with sort_order). Hint: Sorting by owner or lasteditor takes place by ID, not name!</p>
<p><code>{content_dump first_sort="owner"}</code></p>

<p>---</p>
<p><em>Set the direction of primary sorting</em></p>
<p><strong>first_sort_order</strong> can be used to reverse the sorting filter. <em>"up" and "down"</em> are the available options, whereas "up" (A before B or yesterday before today) is the default direction.</p>
<p><code>{content_dump first_sort_order="up"}
</code></p>

<p>---</p>
<p><em>Secondary sorting of data elements</em></p>
<p><strong>second_sort</strong> sorts the found content by one of the following values: <em>id, title, created, modified, owner, hierarchy, lasteditor, active, show (show in menu)</em>. For time based (like newest contents) use created, for last updated lists use modified (both need to be reversed with sort_order). Hint: Sorting by owner or lasteditor takes place by ID, not name!</p>
<p><code>{content_dump first_sort="owner"}</code></p>

<p>---</p>
<p><em>Set the direction of secondary sorting</em></p>
<p><strong>second_sort_order</strong> can be used to reverse the sorting filter. <em>"up" and "down"</em> are the available options, whereas "up" (A before B or yesterday before today) is the default direction.</p>
<p><code>{content_dump first_sort_order="up"}
</code></p>

<h3>---------------------------<br />Maximum data structure for dump items:<br />---------------------------</h3>
<p><code>
$dump = array of classes<br/>
	n = integer<br/><br/>

$dump [ n ] -&gt; item  =  Counter for items in current list (integer)<br /><br />

$dump [ n ] -&gt; content -&gt; id <br />
$dump [ n ] -&gt; content -&gt; alias<br />
$dump [ n ] -&gt; content -&gt; title<br />
$dump [ n ] -&gt; content -&gt; show<br />
$dump [ n ] -&gt; content -&gt; active<br />
$dump [ n ] -&gt; content -&gt; data<br /><br />
				
$dump [ n ] -&gt; parents -&gt; id <br />	
$dump [ n ] -&gt; parents -&gt; alias<br />	 		
$dump [ n ] -&gt; parents -&gt; title<br /><br />

$dump [ n ] -&gt; created -&gt; date<br />
$dump [ n ] -&gt; created -&gt; by -&gt; username<br />
$dump [ n ] -&gt; created -&gt; by -&gt; last_name <br />
$dump [ n ] -&gt; created -&gt; by -&gt; first_name <br />
$dump [ n ] -&gt; created -&gt; by -&gt; email <br /><br />

$dump [ n ] -&gt; modified -&gt; date  <br />
$dump [ n ] -&gt; modified -&gt; by -&gt; username <br />
$dump [ n ] -&gt; modified -&gt; by -&gt; last_name  <br />
$dump [ n ] -&gt; modified -&gt; by -&gt; first_name  <br />
$dump [ n ] -&gt; modified -&gt; by -&gt; email <br /><br />

$dump [ n ] -&gt; extension <br /><br />

And for each extension you have named, you will get an equally named class element below
$dump [ n ] -&gt; extensions <br /><br />e.g.<br />
$dump [ n ] -> extensions -&gt; summary -&gt; data <br />
$dump [ n ] -&gt; extensions -&gt; summary -&gt; length  <br /><br />
</code></p>
<h3>---------------------------<br />Date structure of pager information<br />---------------------------</h3>
<p><code>
$pager_info -&gt; current<br />
$pager_info -&gt; max <br />
$pager_info -&gt; size <br />
</code></p>
<h3>---------------------------<br />Userfull smarty snippets for working with content_dump<br />---------------------------</h3>
<p>Below you find some code snippets you can use in your templates in conjunctionn with content_dump</p>
<h4>Prepare template for paging</h4>
<p><code>{assign var=page_call value=$smarty.get.show_page}<br />
{if $page_call == ""}{assign var=page_call value=1}{/if}<code></p>
<p>This will listen for URL parameter called show_page and its value. If no parameter found, create is and assign value 1. Use $page_call as the value of the page parameter {...page=$page_call...}</p>
<h4>"newer" "older" pager</h4>
<p><code>{if $page_call > 1 }<br />
&lt;a href="blog.htm?show_page={$pager_info->current-1}">newer articles&lt;/a><br />
{/if}<br /><br />

{if $pager_info->max > $page_call}<br />
&lt;a href="blog.htm?show_page={$pager_info->current+1}">older articles&lt;/a><br />
{/if}</code></p>
<h4>Page number list pager</h4>
<p><code>
{section name="i" start=1 loop=$pager_info->max+1 step=1}<br />
  &lt;a href="blog.htm?show_page={$smarty.section.i.index}">{$smarty.section.i.index}&lt;/a> <br />
{/section}<br />
</code></p>
<h4>Walk through all available elements</h4>
<p><code>
{content_dump ... }<br /><br />
{foreach from=$dump item=dump}<br />
 {$dump->content->data}<br />
{/foreach}<br /></code></p>
<h4>Display read more link</h4>
<p><code>
{content_dump ... }<br /><br />
{foreach from=$dump item=dump}<br />
 {if $dump->extension == 1}<br />
 &lt;a href="{$dump->content->alias}.htm">read more&lt;/a><br />
 {/if}<br />
{/foreach}<br /></code></p>

<p>---</p>
<h3>Version Information And History</h3>
<p>Author: Nils Haack &lt;contentdump@opticalvalve.com&gt;</p>
<p>Version: 0.6 (20091030)</p>
<p>Change History:<br />
<ul>
<li>0.6 Ability to load extra content props, html stripping, code-rework</li>
<li>0.5 Added "show_page" parameter and pagination mechanics</li>
<li>0.4.2 Fix in documentation (parameter "users" was not described) - NOT RELEASED</li>
<li>0.4.1 Bugfix: wrong limit_count if parameter "extension" is used</li>
<li>0.4 Added "extension" parameter, better parent loop-up, code clean-up and code comments</li>
<li>0.3 Added "parents", "active" and "show_in_menu" parameter and smarty compiling/stripping</li>
<li>0.2.1 User data look-up is now optional</li>
<li>0.2 Added "this_only", "limit_start" and "limit_count" parameters </li>
<li>0.1 Initial publication</li>
</ul>
</p>
<?php
}

function smarty_cms_about_function_content_dump() {
	?>
<h3>Plug-in Information</h3>
<p>Content_Dump is a multi-purpose content aggregation tool for getting contents from one place to another within a CMSms installation. It can be as precise as a single content-prop of a page or display full collections of pages and their elements.</p>
<p>The output is provided as a smarty data array. With the ability to serve data for all kind of activities, you can use it to build feature-rich paginated blogs, galleries, portfolios or other kinds of index-like presentations. The advantage: everything can be stored in pages and extra content blocks - keeping the learning curve low for editors by keeping a high flexibility for the site develeopment.</p>
<p>---</p>
<h3>Version Information And History</h3>
<p>Author: Nils Haack &lt;contentdump@opticalvalve.com&gt;</p>
<p>Version: 0.6 (20091030)</p>
<p>Change History:<br />
<ul>
<li>0.6 Ability to load extra content props, html stripping, code-rework</li>
<li>0.5 Added "show_page" parameter and pagination mechanics</li>
<li>0.4.2 Fix in documentation (parameter "users" was not described) - NOT RELEASED</li>
<li>0.4.1 Bugfix: wrong limit_count if parameter "extension" is used</li>
<li>0.4 Added "extension" parameter, better parent loop-up, code clean-up and code comments</li>
<li>0.3 Added "parents", "active" and "show_in_menu" parameter and smarty compiling/stripping</li>
<li>0.2.1 User data look-up is now optional</li>
<li>0.2 Added "this_only", "limit_start" and "limit_count" parameters </li>
<li>0.1 Initial publication</li>
</ul>
</p>
	<?php
}

?>