<?php
$lang['admin']['pagedefaultsupdated'] = 'Обновлены параметры страницы по умолчанию';
$lang['admin']['help_function_module_available'] = '<h3>What does this do?</h3>
<p>A plugin to test wether a given module (by name) is installed, and available for use.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><strong>(required)module</strong> - (string) The name of the module.</li>
<li><em>(optional)assign</em> - Assign the output of the plugin to the named smarty variable.</li>
</ul>
<h3>Example:</h3>
{module_available module=\'News\' assign=\'havenews\'}{if $havenews}{cms_module module=News}{/if}
<h3>Note:</h3>
<p>You cannot use the short form of the module call, i.e: <em>{News}</em> in this type of expression.</p>';
$lang['admin']['prettyurls_noeffect'] = 'Красивые URL-адреса не настроены... Этот адрес не будет иметь эффекта';
$lang['admin']['help_function_cms_lang_info'] = '<h3>What does this do?</h3>
<p>This plugin returns an object containing the information that CMSMS has about the selected language.  This can include locale information, encodings, language aliases etc.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><em>(optional)lang</em> - The language to return information for.  If the lang parameter is not specified then the information for the current CMSMS language is used.</li>
<li><em>(optional)assign</em> - Assign the output of the plugin to the named smarty variable.</li>
</ul>
<h3>Example:</h3>
<pre>{cms_lang_info assign=\'nls\'}{$nls->locale()}</pre>
<h3>See Also:</h3>
<p>the CmsNls class documentation.</p>';
$lang['admin']['help_function_cms_set_language'] = '<h3>What does this do?</h3>
<p>This plugin attempts to set the current language for use by translation strings and date formatting to the desired language.  The language specified must be known to CMSMS (The nls file must exist).  When this function is called, (and unless overridden in the config.php) an attempt will be made to set the locale to the local associated with the language.  The locale for the language must be installed on the server.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><strong>(required)lang</strong> - The desired language.  The language must be known to the CMSMS installation (nls file must exist).</li>
</ul>';
$lang['admin']['help_function_cms_get_language'] = '<h3>What does this do?</h3>
<p>This plugin returns the current CMSMS language name. The language is used for translation strings and date formatting.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><em>(optional)assign</em> - Assign the output of the plugin to the named smarty variable.</li>
</ul>';
$lang['admin']['help_modifier_cms_escape'] = '<h3>What does this do?</h3>
<p>This modifier is used to escape the string in one of many ways.  This can be used for converting the string to multiple different display formats, or to make user entered data with special characters displayable on a standard web page.</p>
<h3>Usage:</h3>
<pre><code>{$some_var_with_text|cms_escape[:<escape type>|[<character set>]]}</code></pre>
<h4>Valid escape types:</h4>
<ul>
<li>html <em>(default)</em> - use htmlspecialchars.</li>
<li>htmlall - use htmlentities.</li>
<li>url - raw url encode all entities.</li>
<li>urlpathinfo - Similar to the url escape type, but also encode /.</li>
<li>quotes - Escape unescaped single quotes.</li>
<li>hex - Escape every character into hex.</li>
<li>hexentity - Hex encode every character.</li>
<li>decentity - Decimal encode every character.</li>
<li>javascript - Escape quotes, backslashes, newlines etc.</li>
<li>mail - Encode an email address into something that is safe to display.</li>
<li>nonstd - Escape non standard characters, such as document quotes.</li>
</ul>
<h4>Character Set::</h4>
<p>If the character set is not specified, utf-8 is assumed. The character set is only applicable to the "html" and "htmlall" escape types.</p>';
$lang['admin']['help_modifier_cms_date_format'] = '<h3>What does this do?</h3>
<p>This modifier is used to format dates in a suitable format. It uses the standard strftime parameters. If no format string is specified, the system will use the date format string user preference (for logged in users) or the system date format preference.</p>
<p>This modifier is capable of understanding dates in many formats.  i.e: date-time strings output from the database or integer timestamps generated by the time() function.</p>
<h3>Usage:</h3>
<pre><code>{$some_date_var|cms_date_format[:<format string>]}</code></pre>
<h3>Example:</h3>
<pre><code>{\'2012-03-24 22:44:22\'|cms_date_format}</code></pre>';
$lang['admin']['help_modifier_summarize'] = '<h3>What does this do?</h3>
<p>This modifier is used to truncate a long sequence of text to a limited number of "words".</p>
<h3>Usage:</h3>
<pre><code>{$some_var_with_long_text|summarize:<number>}</code></pre>
<h3>Example:</h3>
<p>The following example would strip all html tags from the content and truncate it after 50 words.</p>
<pre><code>{content|strip_tags|summarize:50}</code></pre>';
$lang['admin']['module_param_lang'] = '<strong>Устарело</strong> - Переопределение текущего языка, который используется для выбора переведенных строк.';
$lang['admin']['server_db_grants'] = 'Проверка уровня доступа к базе данных';
$lang['admin']['error_nograntall_found'] = 'Could not find a suitable "GRANT ALL" permission.  This may mean you could have problems installing or removing modules.  Or even adding and deleting items, including pages';
$lang['admin']['msg_grantall_found'] = 'Found a "GRANT ALL" statement that appears to be suitable';
$lang['admin']['curlversion'] = 'Проверка версии curl';
$lang['admin']['curl'] = 'Проверка библиотеки curl';
$lang['admin']['test_curl'] = 'Проверка готовности curl';
$lang['admin']['test_curlversion'] = 'Проверка Curl Version';
$lang['admin']['curl_versionstr'] = 'версия %s, минимальная, рекомендуемая версия - %s';
$lang['admin']['lines_in_error'] = '%d линий содержат ошибки';
$lang['admin']['no_files_scanned'] = 'Ни одного файла не было отсканировано через процесс верификации (возможно файл повреждден или неправильный)';
$lang['admin']['stylesheetnotfound'] = 'Таблица стилей %d не найдена';
$lang['admin']['sysmain_updateurls'] = 'Обновить маршруты';
$lang['admin']['sysmain_confirmupdateurls'] = 'Вы уверены, что хотите обновить базу данных маршрутов';
$lang['admin']['routesrebuilt'] = 'Маршруты базы данных перестроены';
$lang['admin']['text_changeowner'] = 'Переключить данную страницу на другого пользователя';
$lang['admin']['changeowner'] = 'Поменять владельца';
$lang['admin']['xmlreader_class'] = 'Проверить XMLReader класс';
$lang['admin']['info_smarty_cacheudt'] = 'Если включено, все вызовы UDT (пользовательских тегов) будут кешироваться. Это будет актуально для тегов, которые отображают результаты запросов к БД. Вы можете отключить кеширование при вызове UDT с помощью параметра nocache, например: <code>{myusertag nocache}</code>';
$lang['admin']['prompt_smarty_cacheudt'] = 'Кешировать результаты выполнения UDT (пользовательских тегов)';
$lang['admin']['always'] = 'Всегда';
$lang['admin']['never'] = 'Никогда';
$lang['admin']['moduledecides'] = 'Решения модуля';
$lang['admin']['info_smarty_cachemodules'] = 'Select how to cache tags in various templates that call module actions.  If enabled, all module calls will be cached.  This may have negative effects on some modules, or modules with forms.  <em>(note: you can override this using the nocache option as described in the smarty manual)</em>.  If disabled no module calls will be cached which may have an effect on performance.   If you select to allow the module to decide, the default is that caching is not performed.  The module can override this, and you can disable caching using the nocache parameter when calling the module.';
$lang['admin']['prompt_smarty_cachemodules'] = 'Вызов кэша модуля';
$lang['admin']['info_smarty_compilecheck'] = 'If disabled, smarty will not check the modification dates of templates to see if they have been modified.  This can significantly improve performance.  However performing any template change (or even some content changes) may require a cache clearing';
$lang['admin']['prompt_smarty_compilecheck'] = 'Сделать проверку компилирования';
$lang['admin']['info_smarty_options'] = 'Следующие параметры имеют эффект только тогда, когда кэширование включено';
$lang['admin']['info_smarty_caching2'] = 'When enabled, the output from various plugins will be cached to increase performance.  This only applies to output on content pages marked as cachable, and only for non-admin users.  Note, this functionality may interfere with the behavior of some modules or plugins, or plugins that use non-inline forms.  This option has no effect for users of PHP 5.2.x';
$lang['admin']['prompt_use_smartycaching'] = 'Включить умное кэширование';
$lang['admin']['smarty_settings'] = 'Продвинутые настройки';
$lang['admin']['help_function_cms_init_editor'] = '<h3>What does this do?</h3>
  <p>This plugin is used to initialize the selected wysiwyg editor for display when wysiwyg functionalities are required for frontend data submission.  This module will find the selected frontend wysiwyg, determine if it has been requested, and if so generate the appropriate html code <em>(usually javascript links)</em> so that the wysiwyg will initialize properly when the page is loaded.  If no wysiwyg editors have been requested for the frontend request this plugin will produce no output.</p>
  <p><strong>Note:</strong> This plugin will work properly given the default configuration of CMSMS.  If you have modified the "process_whole_template" configuration variable from its default value, you may have to adjust the parameters supplied to this plugin.</p>
<h3>How do I use it?</h3>
<p>The first thing you must do is select the frontend WYSIWYG editor to use in the global settings page of the admin console.  Next If you use frontend wysiwyg editors on numerous pages, it may be best to place the {cms_init_editor} plugin directly into your page template.  If you only require the wysiwyg editor to be enabled on a limited amount of pages you may just place it into the "Page Specific Metadata" field in each page.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><em>(optional)wysiwyg</em> - Specify the name of the wysiwyg editor module to initialize.  Use with caution.  If you have a different wysiwyg editor selected in the global settings, this will force the specified  editor to be initialized.</li>
<li><em>(optional)force=0</em> - Normally this plugin will not initialize the specified (or detected) editor if it has not been marked as "active".  This parameter will override that behavior.  This parameter may be required of the "process_whole_template" configuration variable is set to a non default value.</li>
<li><em>(optional)assign</em> - Assign the output of the plugin to the named smarty variable.</li>
</ul>';
$lang['admin']['info_pagedefaults'] = 'Эта форма позволяет указать различные опции в качестве начальных установок при создании страниц. Эти опции не затрагивают редактирование существующих страниц.';
$lang['admin']['default_contenttype'] = 'Тип контента по умолчанию';
$lang['admin']['info_default_contenttype'] = 'Applicable when adding new content objects, this control specifies the type that is selected by default.  Please ensure that the selected item is not one of the "disallowed types".';
$lang['admin']['error_contenttype'] = 'Тип контента, ассоциирующийся с этой страницей неправильный или содержит ошибку';
$lang['admin']['info_disallowed_contenttypes'] = 'Select which content types to remove from the content type dropdown when editing or adding content.  Use CTRL+Click to select, unselect items.  Having no selected items will indicate that all content types are allowed. <em>(applies to all users)</em>';
$lang['admin']['disallowed_contenttypes'] = 'Content Types that are not Allowed';
$lang['admin']['search_module'] = 'Поисковой модуль';
$lang['admin']['info_search_module'] = 'Выберите модуль, который должен использовать индексированные слова при поиске, и будет предоставлять возможность поиска по сайту';
$lang['admin']['filecreatedirbadchars'] = 'Недопустимые символы были обнаружены в предоставленном имени каталога';
$lang['admin']['modulehelp_yourlang'] = 'Просмотреть на вашем языке';
$lang['admin']['info_umask'] = 'The "umask" is an octal value that is used to specify the default permission for newly created files (this is used for files in the cache directory, and uploaded files.  For more information see the appropriate <a href="http://en.wikipedia.org/wiki/Umask">wikipedia article.</a>';
$lang['admin']['general_operation_settings'] = 'Настройки общих операций';
$lang['admin']['info_checkversion'] = 'Если этот параметр включен, система будет выполнять ежедневные проверки на новую версию CMSMS';
$lang['admin']['checkversion'] = 'Разрешить периодические проверки наличия новой версии';
$lang['admin']['actioncontains'] = 'Action Contains';
$lang['admin']['filterapplied'] = 'Текущий фильтр';
$lang['admin']['automatedtask_success'] = 'Automated task performed';
$lang['admin']['siteprefsupdated'] = 'Обновлены глобальные настройки';
$lang['admin']['ip_addr'] = 'IP адрес';
$lang['admin']['warn_admin_ipandcookies'] = 'Warning: Admin activities use cookies and tracks your IP address';
$lang['admin']['event_desc_loginfailed'] = 'Отправлено после того как пользователь не смог войти в панель администратора';
$lang['admin']['event_help_loginfailed'] = '<p>Sent after a user failed to login into the admin panel.</p>';
$lang['admin']['modulehelp_english'] = 'Посмотреть на английском языке';
$lang['admin']['nopluginabout'] = 'Не доступной информации для этого плагина';
$lang['admin']['nopluginhelp'] = 'Помощь недоступна для этого плагина';
$lang['admin']['moduleupgraded'] = 'Успешно обновлено';
$lang['admin']['added_css'] = 'Добавлена таблица стилей';
$lang['admin']['toggle'] = 'Переключить';
$lang['admin']['added_group'] = 'Добавлена группа';
$lang['admin']['expanded_xml'] = 'Расширенный XML файл состоящий из %s %s';
$lang['admin']['installed_mod'] = 'Установлена версия %s';
$lang['admin']['uninstalled_mod'] = 'Деинсталлирован модуль %s';
$lang['admin']['upgraded_mod'] = 'Модуль %s обновлён с версии %s до %s';
$lang['admin']['edited_gcb'] = 'Изменён глобальный блок контента';
$lang['admin']['edited_content'] = 'Изменён контент';
$lang['admin']['added_content'] = 'Добавлен контент';
$lang['admin']['added_css_association'] = 'Добавлена привязка к таблице стилей';
$lang['admin']['deleted_group'] = 'Удалена группа';
$lang['admin']['deleted_content'] = 'Удалён контент';
$lang['admin']['edited_user'] = 'Изменён пользователь';
$lang['admin']['edited_udt'] = 'Изменён пользовательский тег';
$lang['admin']['content_copied'] = 'Содержимое элемента копируется в %s';
$lang['admin']['deleted_template'] = 'Удаленный Шаблон';
$lang['admin']['added_udt'] = 'Добавлен пользовательский тег';
$lang['admin']['deleted_udt'] = 'Удалён пользовательский тег';
$lang['admin']['added_gcb'] = 'Добавлен глобальный блок контента';
$lang['admin']['edited_group'] = 'Изменена группа';
$lang['admin']['deleted_css_association'] = 'Удалена привязка к таблице стилей';
$lang['admin']['user_logout'] = 'Выход';
$lang['admin']['user_login'] = 'Вход';
$lang['admin']['login_failed'] = 'Не удалось войти';
$lang['admin']['deleted_css'] = 'Удалена таблица стилей';
$lang['admin']['uploaded_file'] = 'Загруженный файл';
$lang['admin']['created_directory'] = 'Созданный каталог';
$lang['admin']['deleted_file'] = 'Удаленный файл';
$lang['admin']['deleted_directory'] = 'Удаленная директория';
$lang['admin']['edited_template'] = 'Измененный шаблон';
$lang['admin']['deleted_user'] = 'Удаленный пользователь';
$lang['admin']['deleted_module'] = 'Окончательно удалено %s';
$lang['admin']['deleted_gcb'] = 'Deleted Global Content Block';
$lang['admin']['added_user'] = 'Добавленный пользователь';
$lang['admin']['edited_user_preferences'] = 'Измененные настройки пользователя';
$lang['admin']['added_template'] = 'Добавленный шаблон';
$lang['admin']['event_desc_stylesheetpostcompile'] = 'Sent after a stylesheet is compiled through smarty';
$lang['admin']['event_desc_stylesheetprecompile'] = 'Sent before a stylesheet is compiled through smarty';
$lang['admin']['confirm_uploadmodule'] = 'Are you sure you would like to upload the selected XML file. Incorrectly uploading a module file may break a functioning website';
$lang['admin']['error_module_mincmsversion'] = 'This module requires a newer version of CMS Made Simple';
$lang['admin']['info_browser_cache_expiry'] = 'Задайте время (в минутах) в течение которого должно происходить кеширование в обозревателе.  Значение 0 отключит эту функцию.';
$lang['admin']['browser_cache_expiry'] = '<em>Время жизни временных файлов в обозревателе (в минутах)</em>';
$lang['admin']['info_browser_cache'] = 'Применяется только к страницам, отмеченным для кеширования и задает временной отрезок, в течение которого обозревателсь может загружать страницу из кеша. Если включено, то при повторном просмотре страницы один и тем же пользователем изменения будут не видны.';
$lang['admin']['allow_browser_cache'] = 'Разрешить обозревателю кеширование страницы';
$lang['admin']['server_cache_settings'] = 'Настройки кеширования сервера';
$lang['admin']['browser_cache_settings'] = 'Настройки кеширования обозревателя.';
$lang['admin']['help_function_browser_lang'] = '<h3>Для чего это нужно?</h3>
  <p>Этот плагин определяет и выдает язык браузера и сравнивает его со списком разрешенных языков для установки языка для сессии.</p>
<h3>Как это использовать?</h3>
<p>Вставьте тег как можно выше в шаблон страницы <em>(допустима вставка выше тега <head>)</em> и задайте язык используемый по умолчанию, а также языки разрешенных языков (обозначение языка задается двумя символами), после этого работайте с результатами, например:</p>
<pre><code>{browser_lang accept=de,fr,en,es default=en assign=tmp}{session_put var=lang val=$tmp}</code></pre>
<p><em>({session_put} плагин из модуля CGSimpleSmarty module</em></p>
<h3>Допустимые параметры</h3>
<ul>
<li><strong>accepted <em>(необходим)</em></strong><br/> - Разделенный через запятую список языков в двухзначном сокращении.</li>
<li>default<br/>- <em>(опционально)</em> Язык по умолчанию если ни один из языков в списке не поддерживается обозревателем. При пустом значении будет использоваться  английский язык (en) по умолчанию.</li>
<li>assign<br/>- <em>(опционально)</em> Имя переменной Smarty, в которой будет сохранен текущий язык сессии. Если не указано, то результат не возращается.</li>
</ul>';
$lang['admin']['info_target'] = 'Эта опция может использоваться в модуле Менеджер меню, чтобы указать, когда и как новые фрэймы или окна должны открываться. Некоторые шаблоны меню могут эту опцию игнорировать.';
$lang['admin']['close'] = 'Закрыть';
$lang['admin']['open'] = 'Открыть';
$lang['admin']['revert'] = 'Сбросить все изменения';
$lang['admin']['autoclearcache2'] = 'Удалить кэш-файлы, которые старше, чем указанное количество дней';
$lang['admin']['root'] = 'Корень';
$lang['admin']['info_content_autocreate_flaturls'] = 'Если включено, то все альтернативные ссылки будут создаваться как копия алиаса страницы (при этом они не будут синхронизироваться с алиасом в последующем)';
$lang['admin']['content_autocreate_flaturls'] = 'Автоматически созданные ссылки без иерархии';
$lang['admin']['content_autocreate_urls'] = 'Автоматически создавать альтернативные ссылки';
$lang['admin']['content_mandatory_urls'] = 'Обязательный ввод альтернативной ссылки для страницы';
$lang['admin']['content_imagefield_path'] = 'Путь для изображений';
$lang['admin']['info_content_imagefield_path'] = 'Укажите имя каталога, который содержит файлы изображений. Путь должен быть относительным по отношению к каталогу uploads/images';
$lang['admin']['content_thumbnailfield_path'] = 'Путь для эскиза';
$lang['admin']['info_content_thumbnailfield_path'] = 'Укажите имя каталога, который содержит эскизы изображений. Путь должен быть относительным по отношению к каталогу uploads/images и скорей всего совпадает с предыдущим значением.';
$lang['admin']['contentimage_path'] = 'Путь для тега {content_image}';
$lang['admin']['info_contentimage_path'] = 'Укажите имя каталога, который содержит изображения используемые в теге {content_image}. Путь должен быть относительным по отношению к каталогу uploads. Это значение будет использоваться по умолчанию для параметра dir в теге {content_image}.';
$lang['admin']['editcontent_settings'] = 'Настройки редактирования страниц';
$lang['admin']['help_page_url'] = 'Укажите альтернативный URL (относительно корня вашего сайта), который будет использован для дополнительного URL этой страницы. Например: drugoj/adres. Это поле имеет значение только при включенных ЧПУ.';
$lang['admin']['help_page_alias'] = 'Алиас используется в качестве заместителя ID страницы, чтобы однозначно ее определить. Он должен быть уникальным для этой страницы. Алиас также используется для создания URL этой страницы.';
$lang['admin']['help_page_searchable'] = 'Этот параметр указывает, должно ли содержимое для этой страницы находится через модуль Поиск.';
$lang['admin']['help_page_cachable'] = 'Чтобы ускорить загрузку сайта рекомендуется всегда включать кеширование страниц. Внимание! Не используйте эту функцию на страницах, на которых содержание может меняется в зависимости запроса (например, различный контент для зарегистрированных и незарегистрированных пользователей!)';
$lang['admin']['sitedownexcludeadmins'] = 'Исключить пользователей, которые залогинены в панели администратора CMSMS.';
$lang['admin']['your_ipaddress'] = 'Ваш текущий IP-адрес';
$lang['admin']['use_wysiwyg'] = 'Использовать визуальный редактор WYSIWYG';
$lang['admin']['contenttype_redirlink'] = 'Внешняя ссылка';
$lang['admin']['yes'] = 'Да';
$lang['admin']['no'] = 'Нет';
$lang['admin']['listcontent_showalias'] = 'Показывать колонку "Алиас страницы"';
$lang['admin']['listcontent_showurl'] = 'Показывать колонку "Ссылка"';
$lang['admin']['listcontent_showtitle'] = 'Показывать заголовок или текст меню';
$lang['admin']['listcontent_settings'] = 'Настройки списка страниц';
$lang['admin']['lctitle_page'] = 'Название существующих элементов контента';
$lang['admin']['lctitle_alias'] = 'Алиас существующих элементов контента. Некоторые элементы могут не иметь алиаса';
$lang['admin']['lctitle_url'] = 'Суффикс URL для элемента контента.  Если есть';
$lang['admin']['lctitle_template'] = 'Выбранный шаблон для элемента контента. Некоторые элементы могут не иметь шаблона';
$lang['admin']['lctitle_owner'] = 'Владелец элемента контента';
$lang['admin']['lctitle_active'] = 'Указывает, является ли данный элемент активным. Неактивные элементы не могут быть отображены.';
$lang['admin']['lctitle_default'] = 'Укажите элемент контента, который будет показан при вызове корневого URL. Может быть выбран только один элемент';
$lang['admin']['lctitle_move'] = 'Позволяет организовывать иерархию контента';
$lang['admin']['lctitle_multiselect'] = 'Выбрать все/Не выбирать ничего';
$lang['admin']['invalid_url2'] = 'The page URL specified is invalid.  It should contain only alphanumeric characters, or - or /.  Extensions must contain only alphanumeric chars and be less than 5 characters in length.  It is also possible that the URL specified is already in use.';
$lang['admin']['page_url'] = 'URL страницы';
$lang['admin']['runuserplugin'] = 'Выполнить все пользовательские теги';
$lang['admin']['output'] = 'Вывод';
$lang['admin']['run'] = 'Выполнить';
$lang['admin']['run_udt'] = 'Выполнить этот пользовательский тег';
$lang['admin']['stylesheetcopied'] = 'Стили скопированы';
$lang['admin']['templatecopied'] = 'Шаблоны скопированы';
$lang['admin']['ecommerce_desc'] = 'Модули для обеспечения электронной коммерции';
$lang['admin']['ecommerce'] = 'Электронная коммерция';
$lang['admin']['help_function_content_module'] = '<h3>Для чего это нужно?</h3>
<p>Этот тип блоков контента позволяет взаимодействовать с модулями и создавать различные типы блоков содержимого.</p>
<p>Some modules can define content block types for use in module templates.  i.e: The FrontEndUsers module may define a group list content block type.  It will then indicate how you can use the content_module tag to utilize that block type within your templates.</p>
<p><strong>Note:</strong> This block type must be used only with compatible modules.  You should not use this in any way except for as guided by addon modules.</p>';
$lang['admin']['error_parsing_content_blocks'] = 'Ошибка разбора блоков содиржимого (возможно, дублируются названия блоков)';
$lang['admin']['error_no_default_content_block'] = 'В этом шаблоне не был найден основной блок контента. Пожалуйста, убедитесь, что Ваш шаблон содержит тег {content} .';
$lang['admin']['help_function_cms_stylesheet'] = '	<h3>Для чего это нужно?</h3>
  <p>Замена для тега {stylesheet}, этот тег включает в себя кеширование файлов CSS и создает статические ссылки на сгенерированные файлы стилей, которые сохраняются в папке tmp/cache. При последующей загрузке файлы не обрабатываются, а читаются с диска. Дополнительно, тего дает возможность использовать Smarty в стилях</p>
  <p>Этот плагин .  By default, it grabs all of the stylesheets attached to the current template in the order specified by the designer, and generates stylesheet tags.</p>
  <p>Generated stylesheets are uniquely named according to the last modification date in the database, and are only generated if the stylesheet has changed.</p>
  <p>This tag is the replacement for the {stylesheet} tag.</p>
  <h3>How do I use it?</h3>
  <p>Just insert the tag into your template/page\'s head section like: <code>{cms_stylesheet}</code></p>
  <h3>What parameters does it take?</h3>
  <ul>
  <li><em>(optional)</em>name - Instead of getting all stylesheets for the given page, it will only get one specifically named one, whether it\'s attached to the current template or not.</li>
  <li><em>(optional)</em>templateid - If templateid is defined, this will return stylesheets associated with that template instead of the current one.</li>
  <li><em>(optional)</em>media - When used in conjunction with the name parameter this parameter will allow you to override the media type for that stylesheet.  When used in conjunction with the templateid parameter, the media parameter will only output stylesheet tags for those stylesheets that are marked as compatible with the specified media type.</li>
  </ul>
  <h3>Smarty Processing</h3>
  <p>When generating css files this system passes the stylesheets retrieved from the database through smarty.  The smarty delimiters have been changed from the CMSMS standard { and } to [[ and ]] respectively to ease transition in stylesheets.  This allows creating smarty variables i.e.: [[assign var=\'red\' value=\'#900\']] at the top of the stylesheet, and then using these variables later in the stylesheet, i.e:</p>
<pre>
<code>
h3 .error { color: [[$red]]; }<br/>
</code>
</pre>
<p>Because the cached files are generated in the tmp/cache directory of the CMSMS installation, the CSS relative working directory is not the root of the website.  Therefore any images, or other tags that require a url should use the [[root_url]] tag to force it to be an absolute url. i.e:</p>
<pre>
<code>
h3 .error { background: url([[root_url]]/uploads/images/error_background.gif); }<br/>
</code>
</pre>
<p><strong>Note:</strong> Due to the caching nature of the plugin, smarty variables should be placed at the top of EACH stylesheet that is attached to a template.</p>';
$lang['admin']['pseudocron_granularity'] = 'Периодичность (псевдо-)крона';
$lang['admin']['info_pseudocron_granularity'] = 'Этот параметр показывает, как часто (псевдо-)крон будет пытаться выполнить запланированные задачи.';
$lang['admin']['cron_request'] = 'При каждом запросе';
$lang['admin']['cron_15m'] = '15 минут';
$lang['admin']['cron_30m'] = '30 минут';
$lang['admin']['cron_60m'] = '1 час';
$lang['admin']['cron_120m'] = '2 часа';
$lang['admin']['cron_3h'] = '3 часа';
$lang['admin']['cron_6h'] = '6 часов';
$lang['admin']['cron_12h'] = '12 часов';
$lang['admin']['cron_24h'] = '24 часа';
$lang['admin']['adminlog_1day'] = '1 день';
$lang['admin']['adminlog_1week'] = '1 неделя';
$lang['admin']['adminlog_2weeks'] = '2 недели';
$lang['admin']['adminlog_1month'] = '1 месяц';
$lang['admin']['adminlog_3months'] = '3 месяца';
$lang['admin']['adminlog_6months'] = '6 месяцев';
$lang['admin']['adminlog_manual'] = 'Удаление вручную';
$lang['admin']['adminlog_lifetime'] = 'Время хранения записей логов';
$lang['admin']['info_adminlog_lifetime'] = 'Удалить лог-записи, которые старше указанного периода.';
$lang['admin']['filteruser'] = 'Имя пользователя -';
$lang['admin']['filtername'] = 'Имя события содержит';
$lang['admin']['filteraction'] = 'Действие содержит';
$lang['admin']['filterapply'] = 'Применить фильтры';
$lang['admin']['filterreset'] = 'Сбросить фильтры';
$lang['admin']['filters'] = 'Фильтры';
$lang['admin']['showfilters'] = 'Редактирование фильтров';
$lang['admin']['clearcache_taskdescription'] = 'Выполняется ежедневно, эта задача будет удалять кэшированные версии файлов, которые старше, чем возраст, установленный в глобальных настройках.';
$lang['admin']['clearcache_taskname'] = 'Очистить кэш';
$lang['admin']['info_autoclearcache'] = 'Укажите целое число. Введите 0 для отключения автоматической очистки кэша.';
$lang['admin']['autoclearcache'] = 'Автоматически очистить кэш каждые N дней';
$lang['admin']['listtemplates_pagelimit'] = 'Количество строк на странице при просмотре шаблонов';
$lang['admin']['liststylesheets_pagelimit'] = 'Количество строк на странице при просмотре таблицы стилей';
$lang['admin']['listgcbs_pagelimit'] = 'Количество строк на странице при просмотре блоков контента';
$lang['admin']['insecure'] = 'Небезопасные (HTTP)';
$lang['admin']['secure'] = 'Безопасные (HTTPS)';
$lang['admin']['secure_page'] = 'Использовать протокол HTTPS для этой страницы';
$lang['admin']['thumbnail_width'] = 'Ширина эскиза';
$lang['admin']['thumbnail_height'] = 'Высота эскиза';
$lang['admin']['E_STRICT'] = 'E_STRICT выключен в настройках error_reporting';
$lang['admin']['test_estrict_failed'] = 'E_STRICT включен в настройках error_reporting';
$lang['admin']['info_estrict_failed'] = 'Некоторые библиотеки CMSMS могут работать некорректно при включенном E_STRICT. Выключите перед тем, как продолжить.';
$lang['admin']['E_DEPRECATED'] = 'E_DEPRECATED выключен в настройках error_reporting';
$lang['admin']['test_edeprecated_failed'] = 'E_DEPRECATED включен в настройках error_reporting';
$lang['admin']['info_edeprecated_failed'] = 'При включенном E_DEPRECATED пользователи увидят большое количество предупреждений на сайте. Это может негативно отразиться на отображении и функциональности сайта.';
$lang['admin']['session_use_cookies'] = 'Сессиям разрешено использовать Cookies';
$lang['admin']['errorgettingcontent'] = 'Не удалось получить информацию для указанного объекта контента';
$lang['admin']['errordeletingcontent'] = 'Ошибка при удалении содержания (либо у этой страницы есть дочерние элементы или она установлена для использования по умолчанию)';
$lang['admin']['invalidemail'] = 'Данный электронный адрес недействителен';
$lang['admin']['info_deletepages'] = 'Примечание: в связи с ограничением прав, некоторые из страниц, которые Вы выбрали для удаления могут не показываться в ниже приведенном списке';
$lang['admin']['info_pagealias'] = 'Укажите уникальный алиас для этой страницы.';
$lang['admin']['info_autoalias'] = 'Если это поле будет незаполнено, то алиас будет создан автоматически.';
$lang['admin']['invalidparent'] = 'Вы должны выбрать родительскую страницу (обратитесь к администратору, если вы не видите эту опцию).';
$lang['admin']['forgotpwprompt'] = 'Введите имя пользователя. После этого на электронную почту, связанную с этим именем, будет выслана информация с новым логином.';
$lang['admin']['info_basic_attributes'] = 'Это поле позволяет указать, какие свойства контента будет разрешено редактировать пользователям не имеющим права на "Modify Page Structure".';
$lang['admin']['basic_attributes'] = 'Основные свойства';
$lang['admin']['no_permission'] = 'У Вас нет разрешения выполнить эту функцию.';
$lang['admin']['bulk_success'] = 'Массовая операция была успешно обновлена.';
$lang['admin']['no_bulk_performed'] = 'Нет массовой операции для выполнения.';
$lang['admin']['info_preview_notice'] = 'Предупреждение: Эта панель предварительного просмотра ведет себя как окно браузера, разрешающее Вам навигировать от первоначально просматриваемой страницы. Однако, это окно может повести себя непредсказуемо . Если Вы перешли от первоначальной страницы к просмотру следующей и после этого снова вернулись на первоначальную, то, возможно, что Вы не сможете увидеть изменения в содержании, пока Вы не подтвердите эти изменения на главной вкладке редактирования страницы, и затем перезагрузите эту вкладку. При создании новых страниц, если Вы уходите по ссылке с новой страницы, Вы не сможете вернуться к первоначальной, и должны будете обновить эту панель.';
$lang['admin']['sitedownexcludes'] = 'Исключите эти адреса из сообщений о недоступности сайта';
$lang['admin']['info_sitedownexcludes'] = 'Этот параметр позволяет вносить в список IP-адреса или сети, разделенные запятой, для которых не будет показываться сообщение о недоступности сайта. Это позволяет администраторам работать на сайте, пока анонимные посетители видят сообщение о недоступности сайта. <br/> <br/> Адреса могут быть определены в следующих форматах: <br/>
1. xxx.xxx.xxx.xxx - (точный адрес IP)<br/>
2. xxx.xxx.xxx. [yyy-zzz] - (диапазон адресов IP)<br/>
3. xxx.xxx.xxx.xxx/nn - (nnn = число битов, стиль cisco. то есть: 192.168.0.100/24 = все 192.168.0 подсети класса C)';
$lang['admin']['setup'] = 'Дополнительные настройки';
$lang['admin']['handle_404'] = 'Пользовательская страница 404';
$lang['admin']['sitedown_settings'] = 'Настройки сообщения о недоступности сайта';
$lang['admin']['general_settings'] = 'Общие настройки';
$lang['admin']['help_function_page_attr'] = '<h3>Для чего это нужно?</h3>
<p>Этот тег используется для выдачи аттрибутов определенной страницы.</p>
<h3>Как мне это использовать?</h3>
<p>Вставить тег в шаблон, например: <code>{page_attr key="extra1"}</code>.</p>
<h3>Какие параметры используются?</h3>
<ul>
  <li><strong>key [необходим]</strong> Включает название возвращаемого аттрибута.</li>
</ul>';
$lang['admin']['forge'] = 'CMS Made Simple - Forge';
$lang['admin']['disable_wysiwyg'] = 'Отключить визуальный редактор на этой странице (независимо от шаблона или пользовательских настроек)';
$lang['admin']['help_function_page_image'] = '<h3>Для чего это нужно?</h3>
<p>Этот тег используется для выдачи изображения или эскиза изображения определенной страницы.</p>
<h3>Как мне это использовать?</h3>
<p>Вставить тег в шаблон, например: <code>{page_image}</code>.</p>
<h3>Какие параметры используются?</h3>
<ul>
  <li>thumbnail - опционально возращает эскиз изображения вместо полного варианта.</li>
</ul>';
$lang['admin']['pagelink_circular'] = 'Внутренняя ссылка на страницу не может быть выбрана в качестве страницы назначения для другой внутренней ссылки';
$lang['admin']['destinationnotfound'] = 'Выбранная страница не может быть найдена или неверна';
$lang['admin']['help_function_dump'] = '<h3>Для чего это нужно?</h3>
  <p>Этот тег может быть использован для дампа содержимого любой Smarty переменной в более удобном для чтения формате. Это полезно для отладки и редактирования шаблонов, чтобы знать, Формат и тип данных.</p>
<h3>Как мне это использовать?</h3>
<p>Вставьте тег в шаблон, так: <code>{dump item=\'the_smarty_variable_to_dump\'}</code>.</p>
<h3>Какие параметры используются?</h3>
<ul>
<li><strong>item (required)</strong> - The smarty variable to dump the contents of.</li>
<li>maxlevel - The maximum number of levels to recurse (applicable only if recurse is also supplied.  The default value for this parameter is 3</li>
<li>nomethods - Skip output of methods from objects.</li>
<li>novars - Skip output of object members.</li>
<li>recurse - Recurse a maximum number of levels through the objects providing verbose output for each item until the maximum number of levels is reached.</li>
</ul>';
$lang['admin']['sqlerror'] = 'SQL ошибка в %s';
$lang['admin']['image'] = 'Изображение';
$lang['admin']['thumbnail'] = 'Эскиз';
$lang['admin']['searchable'] = 'Эта страница доступна для поиска';
$lang['admin']['help_function_content_image'] = '<h3>What does this do?</h3>
<p>This plugin allows template designers to prompt users to select an image file when editing the content of a page. It behaves similarly to the content plugin, for additional content blocks.</p>
<h3>How do I use it?</h3>
<p>Just insert the tag into your page template like: <code>{content_image block=\'image1\'}</code>.</p>
<h3>What parameters does it take?</h3>
<ul>
  <li><strong>(required)</strong> block - The name for this additional content block.
  <p>Example:</p>
  <pre>{content_image block=\'image1\'}</pre><br/>
  </li>

  <li><em>(optional)</em> label - A label or prompt for this content block in the edit content page.  If not specified, the block name will be used.</li>
 
  <li><em>(optional)</em> dir - The name of a directory (relative to the uploads directory, from which to select image files. If not specified, the uploads directory will be used.
  <p>Example: use images from the uploads/image directory.</p>
  <pre>{content_image block=\'image1\' dir=\'images\'}</pre><br/>
  </li>

  <li><em>(optional)</em> class - The css class name to use on the img tag in frontend display.</li>

  <li><em>(optional)</em> id - The id name to use on the img tag in frontend display.</li> 

  <li><em>(optional)</em> name - The tag name to use on the img tag in frontend display.</li> 

  <li><em>(optional)</em> width - The desired width of the image.</li>

  <li><em>(optional)</em> height - The desired height of the image.</li>

  <li><em>(optional)</em> alt - Alternative text if the image cannot be found.</li>


</ul>';
$lang['admin']['error_udt_name_chars'] = 'Коректное UDT название начинается с буквы или символа подчеркивания, за которой следует любое количество букв, цифр и подчеркиваний';
$lang['admin']['errorupdatetemplateallpages'] = 'Шаблон не активен';
$lang['admin']['hidefrommenu'] = 'Скрыть меню';
$lang['admin']['settemplate'] = 'Установить шаблон';
$lang['admin']['text_settemplate'] = 'Установить выбранные страницы в другой шаблон';
$lang['admin']['cachable'] = 'Кэшируется';
$lang['admin']['noncachable'] = 'Не кэшируется';
$lang['admin']['copy_from'] = 'Копировать с';
$lang['admin']['copy_to'] = 'Копировать на';
$lang['admin']['copycontent'] = 'Скопировать содержимое пункта';
$lang['admin']['md5_function'] = 'md5 функция';
$lang['admin']['tempnam_function'] = 'функция tempnam';
$lang['admin']['register_globals'] = 'PHP register_globals ';
$lang['admin']['output_buffering'] = 'PHP output_buffering ';
$lang['admin']['disable_functions'] = 'disable_functions in PHP ';
$lang['admin']['xml_function'] = 'Базовая поддержка XML (Expat)';
$lang['admin']['magic_quotes_gpc'] = '"Магические кавычки" для GET / POST / COOKIE';
$lang['admin']['magic_quotes_gpc_on'] = 'Одинарные и двойные кавычки, а также обратная косая черта экранируются автоматически. Могут возникнуть проблемы при сохранении шаблонов.';
$lang['admin']['magic_quotes_runtime'] = '"Магические кавычки" на выполнение';
$lang['admin']['magic_quotes_runtime_on'] = 'Most functions that return data will have quotes escaped with a backslash. You can to have problems';
$lang['admin']['file_get_contents'] = 'Тест file_get_contents';
$lang['admin']['check_ini_set'] = 'Тест ini_set';
$lang['admin']['check_ini_set_off'] = 'Вы можете испытывать трудности с некоторой функциональности без этой способности. Этот тест может терпеть неудачу если safe_mode включен';
$lang['admin']['file_uploads'] = 'Закачивание Файлов';
$lang['admin']['test_remote_url'] = 'Тест для удаленных URL';
$lang['admin']['test_remote_url_failed'] = 'Вы, вероятно, не сможет открыть файл на удаленном сервере.';
$lang['admin']['test_allow_url_fopen_failed'] = 'Если возможность fopen открывать URL отключена, вы не сможете получить доступ к объектам использующим FTP или HTTP протокол';
$lang['admin']['connection_error'] = 'Исходящие соединения HTTP, судя по всему, не работают! Существует брандмауэр или некоторые ACL для внешних подключений? Это приведет к сбою работы менеджера модулей, и возможно сбою других функций.';
$lang['admin']['remote_connection_timeout'] = 'Тайм-аут подключения!';
$lang['admin']['search_string_find'] = 'Подключение OK!';
$lang['admin']['connection_failed'] = 'Ошибка соединения!';
$lang['admin']['remote_response_ok'] = 'Удаленный ответ: ОК!';
$lang['admin']['remote_response_404'] = 'Удаленный ответ: не найдено!';
$lang['admin']['remote_response_error'] = 'Удаленный ответ: ошибка!';
$lang['admin']['notifications_to_handle'] = 'У Вас есть необработанные уведомления (<b>%d</b>) ';
$lang['admin']['notification_to_handle'] = 'У Вас есть необработанные уведомления (<b>%d</b>)';
$lang['admin']['notifications'] = 'Уведомления';
$lang['admin']['dashboard'] = 'Инфо панель';
$lang['admin']['ignorenotificationsfrommodules'] = 'Игнорировать уведомления от этих модулей';
$lang['admin']['admin_enablenotifications'] = 'Разрешить пользователям просматривать уведомления <br/><em>(уведомления будут показаны на всех страницах админ-центра)</em>';
$lang['admin']['enablenotifications'] = 'Разрешить пользовательские уведомления администратора в разделе';
$lang['admin']['test_check_open_basedir_failed'] = 'Ограничение open_basedir  действует. Вы можете испытывать трудности с некоторым дополнительным функционалом, с этим ограничением';
$lang['admin']['config_writable'] = 'config.php имеет права на запись. Безопаснее установить разрешение только для чтения';
$lang['admin']['caution'] = 'Внимание!';
$lang['admin']['create_dir_and_file'] = 'Проверка если HTTPD процесс может создать файл внутри директории, он создан';
$lang['admin']['os_session_save_path'] = 'Проверка невозможна из-за os.path';
$lang['admin']['unlimited'] = 'Неограничено';
$lang['admin']['open_basedir'] = 'PHP опция open_basedir';
$lang['admin']['open_basedir_active'] = 'Проверка невозможна из-за включенной опции open_basedir';
$lang['admin']['invalid'] = 'Неверно';
$lang['admin']['checksum_passed'] = 'Все контрольные суммы совпадают с загруженными файлами';
$lang['admin']['error_retrieving_file_list'] = 'Ошибка при получении списка файлов';
$lang['admin']['files_checksum_failed'] = 'Невозможно создать контрольные суммы для файлов';
$lang['admin']['failure'] = 'Ошибка';
$lang['admin']['help_function_process_pagedata'] = '<h3>What does this do?</h3>
<p>This plugin will process the data in the "pagedata" block of content pages through smarty.  It allows you to specify page specific data to smarty without changing the template for each page.</p>
<h3>How do I use it?</h3>
<ol>
  <li>Insert smarty assign variables and other smarty logic into the pagedata field of some of your content pages.</li>
  <li>Insert the <code>{process_pagedata}</code> tag into the very top of your page template.</li>
</ol>
<br/>
<h3>What parameters does it take?</h3>
<p>None at this time</p>';
$lang['admin']['page_metadata'] = 'Мета (meta) для данной страницы';
$lang['admin']['pagedata_codeblock'] = 'Данные или логика Smarty для данной страницы';
$lang['admin']['error_uploadproblem'] = 'Произошла ошибка во время загрузки';
$lang['admin']['error_nofileuploaded'] = 'Файлы не были загружены';
$lang['admin']['files_failed'] = 'Файлы не прошли проверку функцией md5sum';
$lang['admin']['files_not_found'] = 'Файлы не найдены';
$lang['admin']['info_generate_cksum_file'] = 'Эта функция позволит Вам создать контрольную сумму файла и сохранить её на локальном компьютере для последующей проверки. Это должно быть сделано непосредственно перед запуском веб-сайта и/или после любых обновлений или значительных изменений.';
$lang['admin']['info_validation'] = 'Эта функция сравнивает контрольную сумму из загруженного файла с файлами текущей установки. Она может помочь в поиске проблем при загрузке, или точно установить, какие файлы были изменены, если ваша система была взломанна. Контрольная сумма файла генерируется для каждого выпуска CMS Made Simple начиная с версии 1.4 и выше.';
$lang['admin']['download_cksum_file'] = 'Загрузить контрольную сумму файла';
$lang['admin']['perform_validation'] = 'Провести проверку';
$lang['admin']['upload_cksum_file'] = 'Отправить контрольную сумму файла';
$lang['admin']['checksumdescription'] = 'Проверить целостность CMS-файлов, путем сравнения контрольных сумм';
$lang['admin']['system_verification'] = 'Контроль системы';
$lang['admin']['extra1'] = 'Дополнительный атрибут 1';
$lang['admin']['extra2'] = 'Дополнительный атрибут 2';
$lang['admin']['extra3'] = 'Дополнительный атрибут 3';
$lang['admin']['start_upgrade_process'] = 'Начало процесса обновления';
$lang['admin']['warning_upgrade'] = '<em><strong>Предупреждение:</strong></em> CMSMS нуждается в обновлении.';
$lang['admin']['warning_upgrade_info1'] = 'В настоящее время работает схема версии %s. и вам нужно обновить её до версии %s';
$lang['admin']['warning_upgrade_info2'] = 'Нажмите пожалуйста следующую ссылку: %s.';
$lang['admin']['warning_mail_settings'] = 'Ваши настройки почты не сконфигурированы. Это может сказаться на способности вашего сайта отправлять сообщения по электронной почте.  Вы должны перейти в <a href="%s">Extensions >> CMSMailer</a> и настроить параметры почты согласно информации, представленной вашим хостером.';
$lang['admin']['view_page'] = 'Показать эту страницу в новом окне';
$lang['admin']['off'] = 'Выкл';
$lang['admin']['on'] = 'Вкл';
$lang['admin']['invalid_test'] = 'Неверное значение тестового параметра!';
$lang['admin']['copy_paste_forum'] = 'Посмотреть отчет в текстовой форме <em>(для его добавления в форум)</em>';
$lang['admin']['permission_information'] = 'Информация о разрешениях';
$lang['admin']['server_os'] = 'Операционная система сервера';
$lang['admin']['server_api'] = 'API сервера';
$lang['admin']['server_software'] = 'Программное обеспечение сервера';
$lang['admin']['server_information'] = 'Информация о сервере';
$lang['admin']['session_save_path'] = 'Переменная session.save_path';
$lang['admin']['max_execution_time'] = 'Максимальное время выполнения';
$lang['admin']['gd_version'] = 'Версия GD';
$lang['admin']['upload_max_filesize'] = 'Максимальный размер загружаемого файла';
$lang['admin']['post_max_size'] = 'Максимальный размер запроса через POST';
$lang['admin']['memory_limit'] = 'Лимит памяти PHP';
$lang['admin']['server_db_type'] = 'База данных сервера';
$lang['admin']['server_db_version'] = 'Версия СУБД';
$lang['admin']['phpversion'] = 'Текущая версия PHP';
$lang['admin']['safe_mode'] = 'Безопасный режим PHP';
$lang['admin']['php_information'] = 'Информация PHP';
$lang['admin']['cms_install_information'] = 'Установочная информация';
$lang['admin']['cms_version'] = 'Версия CMS';
$lang['admin']['installed_modules'] = 'Установленные модули';
$lang['admin']['config_information'] = 'Информация о конфигурации';
$lang['admin']['systeminfo_copy_paste'] = 'Скопируйте и вставьте выделенный текст для размещения вашего сообщения в форуме';
$lang['admin']['help_systeminformation'] = 'Отображённая ниже информация, собрана из разных мест и представлена здесь в кратком виде для того, чтобы вы сразу могли видеть все настройки при диагностировании проблемы или для обращения за помощью по установке вашей CMS Made Simple.';
$lang['admin']['systeminfo'] = 'Информация о системе';
$lang['admin']['systeminfodescription'] = 'Вывод различной информации о Вашей системе, которая может быть полезна при диагностике проблемы.';
$lang['admin']['systemmaintenance'] = 'Обслуживание системы';
$lang['admin']['systemmaintenancedescription'] = 'Various functions for maintaining the health of your system. You can also browser the changelog of CMSMadeSimple';
$lang['admin']['sysmaintab_database'] = 'База данных';
$lang['admin']['sysmaintab_changelog'] = 'Изменения';
$lang['admin']['sysmaintab_content'] = 'Кэш и содержание';
$lang['admin']['sysmain_content_status'] = 'Статус содержимого';
$lang['admin']['sysmain_cache_status'] = 'Статус Кэша';
$lang['admin']['sysmain_database_status'] = 'Статус базы данных';
$lang['admin']['sysmain_updatehierarchy'] = 'Обновление позиций иерархии страниц';
$lang['admin']['sysmain_confirmupdatehierarchy'] = 'Вы действительно хотите обновить позиции иерархии страниц?';
$lang['admin']['sysmain_update'] = 'Обновить';
$lang['admin']['sysmain_pagesfound'] = 'страниц найдено';
$lang['admin']['sysmain_hierarchyupdated'] = 'Позиции иерархии страниц обновлены';
$lang['admin']['sysmain_nostr_errors'] = 'No structural errors were detected in the database';
$lang['admin']['sysmain_str_error'] = 'Structural error detected in table';
$lang['admin']['sysmain_str_errors'] = 'Structural errors detected in tables';
$lang['admin']['sysmain_tablesfound'] = 'tables found (out of which %d are not seq-tables)';
$lang['admin']['sysmain_repair'] = 'Repair';
$lang['admin']['sysmain_repairtables'] = 'Repair tables';
$lang['admin']['sysmain_tablesrepaired'] = 'Tables repaired';
$lang['admin']['sysmain_optimizetables'] = 'Optimize tables';
$lang['admin']['sysmain_tablesoptimized'] = 'Tables optimized';
$lang['admin']['sysmain_optimize'] = 'Optimize';
$lang['admin']['sysmain_confirmclearcache'] = 'Are you sure you want to clear the cache?';
$lang['admin']['sysmain_nocontenterrors'] = 'No content errors detected';
$lang['admin']['sysmain_pagesmissinalias'] = 'pages missing aliases';
$lang['admin']['sysmain_confirmfixaliases'] = 'Are you sure you want to add aliases to pages missing it?';
$lang['admin']['sysmain_fixaliases'] = 'Add aliases where missed';
$lang['admin']['sysmain_aliasesfixed'] = 'aliases fixed';
$lang['admin']['sysmain_pagesinvalidtypes'] = 'pages with invalid content type';
$lang['admin']['sysmain_confirmfixtypes'] = 'Are you sure you want to convert all with invalid content into standard content pages?';
$lang['admin']['sysmain_fixtypes'] = 'Convert into standard content pages';
$lang['admin']['sysmain_typesfixed'] = 'page content types fixed';
$lang['admin']['welcome_user'] = 'Добро пожаловать';
$lang['admin']['itsbeensincelogin'] = '%s с вашего последнего входа ';
$lang['admin']['days'] = 'дней';
$lang['admin']['day'] = 'день';
$lang['admin']['hours'] = 'часов';
$lang['admin']['hour'] = 'час';
$lang['admin']['minutes'] = 'минут';
$lang['admin']['minute'] = 'минута';
$lang['admin']['help_css_max_age'] = 'Этот параметр должен быть установлен сравнительно высоко для статических сайтов, и должен быть равен 0 во время разработки сайта';
$lang['admin']['css_max_age'] = 'Максимальное количество времени (в секундах), в течение которого шаблоны могут находится в кэше браузера';
$lang['admin']['error'] = 'Ошибка';
$lang['admin']['new_version_available'] = '<em>Примечание:</em> Вышла новая версия CMS Made Simple. Просьба сообщить об этом администратору.';
$lang['admin']['master_admintheme'] = 'Административный шаблон по умолчанию (страница для входа и для новых пользователей)';
$lang['admin']['contenttype_separator'] = 'Разделитель';
$lang['admin']['contenttype_sectionheader'] = 'Секция заголовка';
$lang['admin']['contenttype_content'] = 'Контент';
$lang['admin']['contenttype_pagelink'] = 'Внутренняя ссылка на страницу';
$lang['admin']['nogcbwysiwyg'] = 'Запретить визуальные редакторы в глобальном контенте блоков';
$lang['admin']['destination_page'] = 'Страница назначения';
$lang['admin']['additional_params'] = 'Дополнительные параметры';
$lang['admin']['help_function_current_date'] = '	<h3>What does this do?</h3>
	<p>Prints the current date and time.  If no format is given, it will default to a format similar to \'Jan 01, 2004\'.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{current_date format="%A %d-%b-%y %T %Z"}</code></p>
	<h3>What parameters does it take?</h3>
	<ul>
		<li><em>(optional)</em>format - Date/Time format using parameters from php\'s strftime function.  See <a href="http://php.net/strftime" target="_blank">here</a> for a parameter list and information.</li>
		<li><em>(optional)</em>ucword - If true return uppercase the first character of each word.</li>
	</ul>
	</p>';
$lang['admin']['help_function_valid_xhtml'] = '<h3>What does this do?</h3>
<p>Returns a link to the w3c HTML validator.</p>
<h3>How do I use it?</h3>
<p>Just insert the tag into your template/page like: <code>{valid_xhtml}</code></p>
<h3>What parameters does it take?</h3>
<p>
    <ul>
	<li><em>(optional)</em> url         (string)     - The URL used for validation, if none is given http://validator.w3.org/check/referer is used.</li>
	<li><em>(optional)</em> class       (string)     - If set, this will be used as class attribute for the link (a) element</li>
	<li><em>(optional)</em> target      (string)     - If set, this will be used as target attribute for the link (a) element</li>
	<li><em>(optional)</em> image       (true/false) - If set to false, a text link will be used instead of an image/icon.</li>
	<li><em>(optional)</em> text        (string)     - If set, this will be used for the link text or alternate text for the image. Default is \'valid XHTML 1.0 Transitional\'.<br /> When an image is used, the given string will also be used for the image alt attribute (by default, this can be overridden by using the \'alt\' parameter).</li>
	<li><em>(optional)</em> image_class (string)     - Only if \'image\' is not set to false. If set, this will be used as class attribute for the image (img) element</li>
	<li><em>(optional)</em> src         (string)     - Only if \'image\' is not set to false. The icon to show. Default is http://www.w3.org/Icons/valid-xhtml10</li>
	<li><em>(optional)</em> width       (string)     - Only if \'image\' is not set to false. The image width. Default is 88 (width of http://www.w3.org/Icons/valid-xhtml10)</li>
	<li><em>(optional)</em> height      (string)     - Only if \'image\' is not set to false. The image height. Default is 31 (height of http://www.w3.org/Icons/valid-xhtml10)</li>
	<li><em>(optional)</em> alt         (string)     - Only if \'image\' is not set to false. The alternate text (\'alt\' attribute) for the image (element). If none is given the link text will be used.</li>
    </ul>
</p>';
$lang['admin']['help_function_valid_css'] = '<h3>What does this do?</h3>
<p>Returns a link to the w3c CSS validator.</p>
<h3>How do I use it?</h3>
<p>Just insert the tag into your template/page like: <code>{valid_css}</code></p>
<h3>What parameters does it take?</h3>
<p>
    <ul>
        <li><em>(optional)</em> url         (string)     - The URL used for validation, if none is given http://jigsaw.w3.org/css-validator/check/referer is used.</li>
	<li><em>(optional)</em> class       (string)     - If set, this will be used as class attribute for the link (a) element</li>
	<li><em>(optional)</em> target      (string)     - If set, this will be used as target attribute for the link (a) element</li>
	<li><em>(optional)</em> image       (true/false) - If set to false, a text link will be used instead of an image/icon.</li>
	<li><em>(optional)</em> text        (string)     - If set, this will be used for the link text or alternate text for the image. Default is \'Valid CSS 2.1\'.<br /> When an image is used, the given string will also be used for the image alt attribute (by default, this can be overridden by using the \'alt\' parameter).</li>
	<li><em>(optional)</em> image_class (string)     - Only if \'image\' is not set to false. If set, this will be used as class attribute for the image (img) element</li>
        <li><em>(optional)</em> src         (string)     - Only if \'image\' is not set to false. The icon to show. Default is http://jigsaw.w3.org/css-validator/images/vcss</li>
        <li><em>(optional)</em> width       (string)     - Only if \'image\' is not set to false. The image width. Default is 88 (width of http://jigsaw.w3.org/css-validator/images/vcss)</li>
        <li><em>(optional)</em> height      (string)     - Only if \'image\' is not set to false. The image height. Default is 31 (height of http://jigsaw.w3.org/css-validator/images/vcss)</li>
	<li><em>(optional)</em> alt         (string)     - Only if \'image\' is not set to false. The alternate text (\'alt\' attribute) for the image (element). If none is given the link text will be used.</li>
    </ul>
</p>';
$lang['admin']['help_function_title'] = '	<h3>What does this do?</h3>
	<p>Prints the title of the page.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{title}</code></p>
	<h3>What parameters does it take?</h3>
	<p><em>(optional)</em> assign (string) - Assign the results to a smarty variable with that name.</p>';
$lang['admin']['help_function_stylesheet'] = '	<h3>What does this do?</h3>
	<p>Gets stylesheet information from the system.  By default, it grabs all of the stylesheets attached to the current template.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page\'s head section like: <code>{stylesheet}</code></p>
	<h3>What parameters does it take?</h3>
	<ul>
		<li><em>(optional)</em>name - Instead of getting all stylesheets for the given page, it will only get one spefically named one, whether it\'s attached to the current template or not.</li>
		<li><em>(optional)</em>media - If name is defined, this allows you set a different media type for that stylesheet.</li>
	</ul>
	</p>';
$lang['admin']['help_function_sitename'] = '        <h3>Для чего это нужно?</h3>
        <p>Показывает имя сайта. Оно определяется во время установки и может быть изменено в разделе Общие настройки административного раздела.</p>
        <h3>Как это использовать?</h3>
        <p>Просто поместите тэг <code>{sitename}</code> на страницу или в шаблон.</p>
        <h3>Какие параметры используются?</h3>
	<p><em>(Не обязательный)</em> assign (строка) - Результат помещается в переменную смарти с заданным именем.</p>';
$lang['admin']['help_function_search'] = '	<h3>Для чего это нужно?</h3>
	<p>На самом деле это всего лишь тег-обертка для модуля поиска, чтобы упростить синтаксис тега. 
	Вместо того, чтобы использовать <code>{cms_module module=\'Search\'}</code> теперь можно просто использовать <code>{search}</code> , чтобы вставить модуль в шаблон.
	</p>
	<h3>Как это использовать?</h3>
	<p>Просто вставьте <code>{search}</code> в шаблон в том месте где вы хотите отобразить окно поиска. Для получения помощи по модулю поиска, пожалуйста обратитесь к справке по этому модулю.</p>';
$lang['admin']['help_function_root_url'] = '	<h3>Для чего это нужно?</h3>
	<p>Выводит корневой адрес сайта</p>
	<h3>Как это использовать?</h3>
	<p>Просто вставьте тег в шаблон/страницу, так: <code>{root_url}</code></p>
	<h3>Какие параметры используются?</h3>
	<p>В настоящее время отсутствуют.</p>';
$lang['admin']['help_function_repeat'] = '  <h3>Для чего это нужно?</h3>
  <p>Повторяет заданную последовательность символов, заданное количество раз</p>
  <h3>Как это использовать?</h3>
  <p>Вставить тег похожий на следующий в ваш шаблон/страницу, например так: <code>{repeat string=\'repeat this \' times=\'3\'}</code></p>
  <h3>Какие параметры используются?</h3>
  <ul>
  <li>string=\'text\' - Повторяемая строка</li>
  <li>times=\'num\' - Количество раз для повтора.</li>
  </ul>';
$lang['admin']['help_function_recently_updated'] = '	<h3>Для чего это нужно?</h3>
	<p>Outputs a list of recently updated pages.</p>
	<h3>Как это использовать?</h3>
	<p>Just insert the tag into your template/page like: <code>{recently_updated}</code></p>
	<h3>What parameters does it take?</h3>
	<ul>
	 <li><p><em>(optional)</em> number=\'10\' - Number of updated pages to show.</p><p>Example: <pre>{recently_updated number=\'15\'}</pre></p></li>
 	 <li><p><em>(optional)</em> leadin=\'Last changed\' - Text to show left of the modified date.</p><p>Example: <pre>{recently_updated leadin=\'Last Changed\'}</pre></p></li>
 	 <li><p><em>(optional)</em> showtitle=\'true\' - Shows the titleattribute if it exists as well (true|false).</p><p>Example: <pre>{recently_updated showtitle=\'true\'}</pre></p></li>											 	
	 <li><p><em>(optional)</em> css_class=\'some_name\' - Warp a div tag with this class around the list.</p><p>Example: <pre>{recently_updated css_class=\'some_name\'}</pre></p></li>											 	
	 <li><p><em>(optional)</em> dateformat=\'d.m.y h:m\' - default is d.m.y h:m , use the format you whish (php -date- format)</p><p>Example: <pre>{recently_updated dateformat=\'D M j G:i:s T Y\'}</pre></p></li>											 	
	</ul>
	<p>or combined:</p>
	<pre>{recently_updated number=\'15\' showtitle=\'false\' leadin=\'Last Change: \' css_class=\'my_changes\' dateformat=\'D M j G:i:s T Y\'}</pre>';
$lang['admin']['help_function_print'] = '	<h3>What does this do?</h3>
	<p>This is actually just a wrapper tag for the Printing module to make the tag syntax easier. 
	Instead of having to use <code>{cms_module module=\'Printing\'}</code> you can now just use <code>{print}</code> to insert the module on pages and templates.
	</p>
	<h3>How do I use it?</h3>
	<p>Just put <code>{print}</code> on a page or in a template. For help about the Printing module, what parameters it takes etc., please refer to the Printing module help.';
$lang['admin']['login_info_title'] = 'Информация';
$lang['admin']['login_info'] = 'Для работы в администраторском интерфейсе должны быть';
$lang['admin']['login_info_params'] = '<ol> 
  <li>Разрешены cookies в вашем браузере</li> 
  <li>Разрешены javascript в вашем браузере </li> 
  <li>Активированы Windows popup для следующего адреса:</li> 
</ol>';
$lang['admin']['help_function_news'] = '	<h3>What does this do?</h3>
	<p>This is actually just a wrapper tag for the News module to make the tag syntax easier. 
	Instead of having to use <code>{cms_module module=\'News\'}</code> you can now just use <code>{news}</code> to insert the module on pages and templates.
	</p>
	<h3>How do I use it?</h3>
	<p>Just put <code>{news}</code> on a page or in a template. For help about the News module, what parameters it takes etc., please refer to the News module help.';
$lang['admin']['help_function_modified_date'] = '        <h3>What does this do?</h3>
        <p>Prints the date and time the page was last modified.  If no format is given, it will default to a format similar to \'Jan 01, 2004\'.</p>
        <h3>How do I use it?</h3>
        <p>Just insert the tag into your template/page like: <code>{modified_date format="%A %d-%b-%y %T %Z"}</code></p>
        <h3>What parameters does it take?</h3>
        <ul>
                <li><em>(optional)</em>format - Date/Time format using parameters from php\'s strftime function.  See <a href="http://php.net/strftime" target="_blank">here</a> for a parameter list and information.</li>
        </ul>';
$lang['admin']['help_function_metadata'] = '	<h3>What does this do?</h3>
	<p>Displays the metadata for this page. Both global metdata from the global settings page and metadata for each page will be shown.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template like: <code>{metadata}</code></p>
	<h3>What parameters does it take?</h3>
	<ul>
		<li><em>(optional)</em>showbase (true/false) - If set to false, the base tag will not be sent to the browser.  Defaults to true if use_hierarchy is set to true in config.php.</li>
	</ul>';
$lang['admin']['help_function_menu_text'] = '	<h3>What does this do?</h3>
	<p>Prints the menu text of the page.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{menu_text}</code></p>
	<h3>What parameters does it take?</h3>
	<p>None at this time.</p>';
$lang['admin']['help_function_menu'] = '	<h3>What does this do?</h3>
	<p>This is actually just a wrapper tag for the Menu Manager module to make the tag syntax easier. 
	Instead of having to use <code>{cms_module module=\'MenuManager\'}</code> you can now just use <code>{menu}</code> to insert the module on pages and templates.
	</p>
	<h3>How do I use it?</h3>
	<p>Just put <code>{menu}</code> on a page or in a template. For help about the Menu Manager module, what parameters it takes etc., please refer to the Menu Manager module help.';
$lang['admin']['help_function_last_modified_by'] = '        <h3>What does this do?</h3>
        <p>Prints last person that edited this page.  If no format is given, it will default to a ID number of user .</p>
        <h3>How do I use it?</h3>
        <p>Just insert the tag into your template/page like: <code>{last_modified_by format="fullname"}</code></p>
        <h3>What parameters does it take?</h3>
        <ul>
                <li><em>(optional)</em>format - id, username, fullname</li>
        </ul>';
$lang['admin']['help_function_image'] = '  <h3>What does this do?</h3>
  <p>Creates an image tag to an image stored within your images directory</p>
  <h3>How do I use it?</h3>
  <p>Just insert the tag into your template/page like: <code>{image src="something.jpg"}</code></p>
  <h3>What parameters does it take?</h3>
  <ul>
     <li><em>(required)</em>  <tt>src</tt> - Image filename within your images directory.</li>
     <li><em>(optional)</em>  <tt>width</tt> - Width of the image within the page. Defaults to true size.</li>
     <li><em>(optional)</em>  <tt>height</tt> - Height of the image within the page. Defaults to true size.</li>
     <li><em>(optional)</em>  <tt>alt</tt> - Alt text for the image -- needed for xhtml compliance. Defaults to filename.</li>
     <li><em>(optional)</em>  <tt>class</tt> - CSS class for the image.</li>
     <li><em>(optional)</em>  <tt>title</tt> - Mouse over text for the image. Defaults to Alt text.</li>
     <li><em>(optional)</em>  <tt>addtext</tt> - Additional text to put into the tag</li>
  </ul>';
$lang['admin']['help_function_html_blob'] = '	<h3>Для чего это нужно?</h3>
	<p>Смотрите описание в справке для global_content.</p>';
$lang['admin']['help_function_google_search'] = '	<h3>What does this do?</h3>
	<p>Search\'s your website using Google\'s search engine.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{google_search}</code><br>
	<br>
	Note: Google needs to have your website indexed for this to work. You can submit your website to google <a href="http://www.google.com/addurl.html">here</a>.</p>
	<h3>What if I want to change the look of the textbox or button?</h3>
	<p>The look of the textbox and button can be changed via css. The textbox is given an id of textSearch and the button is given an id of buttonSearch.</p>

	<h3>What parameters does it take?</h3>
	<ul>
		<li><em>(optional)</em> domain - This tells google the website domain to search. This script tries to determine this automatically.</li>
		<li><em>(optional)</em> buttonText - The text you want to display on the search button. The default is "Search Site".</li>
	</ul>
	</p>';
$lang['admin']['help_function_global_content'] = '	<h3>What does this do?</h3>
	<p>Inserts a global content block into your template or page.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{global_content name=\'myblob\'}</code>, where name is the name given to the block when it was created.</p>
	<h3>What parameters does it take?</h3>
	<ul>
		<li>name - The name of the global content block to display.</li>
	</ul>';
$lang['admin']['help_function_get_template_vars'] = '	<h3>What does this do?</h3>
	<p>Dumps all the known smarty variables into your page</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{get_template_vars}</code></p>
	<h3>What parameters does it take?</h3>
											  <p>None at this time</p>';
$lang['admin']['help_function_uploads_url'] = '	<h3>What does this do?</h3>
	<p>Prints the uploads url location for the site.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{uploads_url}</code></p>
	<h3>What parameters does it take?</h3>
	<p><em>(optional)</em> assign (string) - Assign the results to a smarty variable with that name.</p>';
$lang['admin']['help_function_embed'] = '	<h3>What does this do?</h3>
	<p>Enable inclusion (embeding) of any other application into the CMS. The most usual use could be a forum. 
	This implementation is using IFRAMES so older browsers can have problems. Sorry bu this is the only known way 
	that works without modifing the embeded application.</p>
	<h3>How do I use it?</h3>
        <ul>
        <li>a) Add <code>{embed header=true}</code> into the head section of your page template, or into the metadata section in the options tab of a content page.  This will ensure that the required javascript gets included.   If you insert this tag into the metadata section in the options tab of a content page you must ensure that <code>{metadata}</code> is in your page template.</li>
        <li>b) Add <code>{embed url="http://www.google.com"}</code> into your page content or in the body of your page template.</li>
        </ul>
        <br/>
        <h4>Example to make the iframe larger</h4>
	<p>Add the following to your style sheet:</p>
        <pre>#myframe { height: 600px; }</pre>
        <br/>
        <h3>What parameters does it take?</h3>
        <ul>
            <li><em>(required)</em>url - the url to be included 
            <li><em>(required)</em>header=true - this will generate the header code for good resizing of the IFRAME.</li>
            <li>(optional)name - an optional name to use for the iframe (instead of myframe).<p>If this option is used, it must be used identically in both calls, i.e: {embed header=true name=foo} and {embed name=foo url=http://www.google.com} calls.</p>
        </ul>';
$lang['admin']['help_function_description'] = '	<h3>What does this do?</h3>
	<p>Prints the description (title attribute) of the page.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{description}</code></p>
	<h3>What parameters does it take?</h3>
	<p>None at this time.</p>';
$lang['admin']['help_function_created_date'] = '        <h3>What does this do?</h3>
        <p>Prints the date and time the page was created.  If no format is given, it will default to a format similar to \'Jan 01, 2004\'.</p>
        <h3>How do I use it?</h3>
        <p>Just insert the tag into your template/page like: <code>{created_date format="%A %d-%b-%y %T %Z"}</code></p>
        <h3>What parameters does it take?</h3>
        <ul>
                <li><em>(optional)</em>format - Date/Time format using parameters from php\'s strftime function.  See <a href="http://php.net/strftime" target="_blank">here</a> for a parameter list and information.</li>
        </ul>';
$lang['admin']['help_function_content'] = '	<h3>What does this do?</h3>
	<p>This is where the content for your page will be displayed.  It\'s inserted into the template and changed based on the current page being displayed.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template like: <code>{content}</code>.</p>
	<h3>What parameters does it take?</h3>
	<ul>
		<li><em>(optional)</em>block - Allows you to have more than one content block per page.  When multiple content tags are put on a template, that number of edit boxes will be displayed when the page is edited.
<p>Example:</p>
<pre>{content block="Second Content Block"}</pre>
<p>Now, when you edit a page there will a textarea called "Second Content Block".</li>
		<li><em>(optional)</em>wysiwyg (true/false) - If set to false, then a wysiwyg will never be used while editing this block.  If true, then it acts as normal.  Only works when block parameter is used.</li>
		<li><em>(optional)</em>oneline (true/false) - If set to true, then only one edit line will be shown while editing this block.  If false, then it acts as normal.  Only works when block parameter is used.</li>
		<li><em>(optional)</em>assign - Assigns the content to a smarty parameter, which you can then use in other areas of the page, or use to test whether content exists in it or not.
<p>Example of passing page content to a User Defined Tag as a parameter:</p>
<pre>
         {content assign=pagecontent}
         {table_of_contents thepagecontent="$pagecontent"}
</pre>
</li>
	</ul>';
$lang['admin']['help_function_contact_form'] = '  <h2>NOTE: This plugin is deprecated</h2>
  <h3>This plugin has been removed as of CMS made simple version 1.5</h3>
  <p>You can use the module FormBuilder instead.</p>';
$lang['admin']['help_function_cms_versionname'] = '	<h3>What does this do?</h3>
	<p>This tag is used to insert the current version name of CMS into your template or page.  It doesn\'t display any extra besides the version name.</p>
	<h3>How do I use it?</h3>
	<p>This is just a basic tag plugin.  You would insert it into your template or page like so: <code>{cms_versionname}</code>
	<h3>What parameters does it take?</h3>
	<p>It takes no parameters.</p>';
$lang['admin']['help_function_cms_version'] = '	<h3>What does this do?</h3>
	<p>This tag is used to insert the current version number of CMS into your template or page.  It doesn\'t display any extra besides the version number.</p>
	<h3>How do I use it?</h3>
	<p>This is just a basic tag plugin.  You would insert it into your template or page like so: <code>{cms_version}</code>
	<h3>What parameters does it take?</h3>
	<p>It takes no parameters.</p>';
$lang['admin']['about_function_cms_selflink'] = '		<p>Author: Ted Kulp <tedkulp@users.sf.net></p>
		<p>Version: 1.1</p>
		<p>Modified: Martin B. Vestergaard <mbv@nospam.dk></p>
		<p>Version: 1.41</p>
		<p>Modified: Russ Baldwin</p>
		<p>Version: 1.42</p>
		<p>Modified: Marcus Bointon <coolbru@users.sf.net></p>
		<p>Version: 1.43</p>
		<p>Modified: Tatu Wikman <tsw@backspace.fi></p>
		<p>Version: 1.44</p>
		<p>Modified: Hans Mogren <http://hans.bymarken.net/></p>
		<p>Version: 1.45</p>

		<p>
		Change History:<br/>
		1.46 - Fixes a problem with too many queries when using the dir=start option.<br/>
		1.45 - Added a new option for "dir", "up", for links to the parent page e.g. dir="up" (Hans Mogren).<br />
		1.44 - Added new parameters "ext" and "ext_info" to allow external links with class="external" and info text after the link, ugly hack but works thinking about rewriting this(Tatu Wikman)<br />
		1.43 - Added new parameters "image" and "imageonly" to allow attachment of images to be used for page links, either instead of or in addition to text links. (Marcus Bointon)<br />
		1.42 - Added new parameter "anchorlink" and a new option for "dir" namely, "anchor", for internal page links. e.g. dir="anchor" anchorlink="internal_link". (Russ)<br />
		1.41 - added new parameter "href" (LeisureLarry)<br />
		1.4 - fixed bug next/prev linking to non-content pages. (Thanks Teemu Koistinen for this fix)<br />
		1.3 - added option "more"<br />
		1.2 - by Martin B. Vestergaard
		<ul>
		<li>changed default text to Page Name (was Page Alias)</li>
		<li>added option dir=next/prev to display next or previous item in the hirachy - thanks to 100rk</li>
		<li>added option class to add a class= statement to the a-tag.</li>
		<li>added option menu to display menu-text in sted of Page Name</li>
		<li>added option lang to display link-labels in different languages</li>
		</ul>
		1.1 - Changed to new content system<br />
		1.0 - Initial release
		</p>';
$lang['admin']['help_function_cms_selflink'] = '		<h3>Для чего это нужно?</h3>
		<p>Создает внутренние ссылки на любую страницу внутри сайта на CMS Made Simple и может быть использован как в шаблоне, так и в редакторе TinyMCE. При использовании параметра ext может быть использован для создания внешних ссылок.</p>
		<h3>Как использовать?</h3>
		<p>Добавьте в шаблон или прямо в содержимое страницы: <code>{cms_selflink page="1"}</code> или <code>{cms_selflink page="alias"}</code> используя при этом, в первом случае ID страницы, а во втором случае ее алиас.</p>
		<h3>Допустимые параметры</h3>
		<p>
		<ul>
		<li><em>(опционально)</em> <tt>page</tt> - ID или алиас страницы, на которую должна вести ссылка.</li>
		<li><em>(опционально)</em> <tt>dir anchor (ссылки на ту же саму страницу)</tt> - New option for an internal page link. If this is used then <tt>anchorlink</tt> should be set to your link. </li> <!-- Russ - 25-04-2006 -->
		<li><em>(optional)</em> <tt>anchorlink</tt> - New paramater for an internal page link. If this is used then <tt>dir ="anchor"</tt> should also be set. No need to add the #, because it is added automatically.</li> <!-- Russ - 25-04-2006 -->
		<li><em>(optional)</em> <tt>urlparam</tt> - Specify additional parameters to the URL.  <strong>Do not use this in conjunction with the <em>anchorlink</em> parameter</em></strong>
		<li><em>(optional)</em> <tt>tabindex ="a value"</tt> - Set a tabindex for the link.</li> <!-- Russ - 22-06-2005 -->
		<li><em>(optional)</em> <tt>dir start/next/prev/up (previous)</tt> - Links to the default start page or the next or previous page, or the parent page (up). If this is used <tt>page</tt> should not be set.</li> <!-- mbv - 21-06-2005 -->
		<B>Note!</B> Only one of the above may be used in the same cms_selflink statement!!
		<li><em>(optional)</em> <tt>text</tt> - Text to show for the link.  If not given, the Page Name is used instead.</li>
		<li><em>(optional)</em> <tt>menu 1/0</tt> - If 1 the Menu Text is used for the link text instead of the Page Name</li> <!-- mbv - 21-06-2005 -->
		<li><em>(optional)</em> <tt>target</tt> - Optional target for the a link to point to.  Useful for frame and javascript situations.</li>
		<li><em>(optional)</em> <tt>class</tt> - Class for the A link. Useful for styling the link.</li> <!-- mbv - 21-06-2005 -->
		<li><em>(optional)</em> <tt>lang</tt> - Display link-labels  ("Next Page"/"Previous Page") in different languages (0 for no label.) Danish (dk), English (en) or French (fr), for now.</li> <!-- mbv - 21-06-2005 -->
		<li><em>(optional)</em> <tt>id</tt> - Optional css_id for the <a> link.</li> <!-- mbv - 29-06-2005 -->
		<li><em>(optional)</em> <tt>more</tt> - place additional options inside the <a> link.</li> <!-- mbv - 29-06-2005 -->
		<li><em>(optional)</em> <tt>label</tt> - Label to use in with the link if applicable.</li>
		<li><em>(optional)</em> <tt>label_side left/right</tt> - Side of link to place the label (defaults to "left").</li>
		<li><em>(optional)</em> <tt>title</tt> - Text to use in the title attribute.  If none is given, then the title of the page will be used for the title.</li>
		<li><em>(optional)</em> <tt>rellink 1/0</tt> - Make a relational link for accessible navigation.  Only works if the dir parameter is set and should only go in the head section of a template.</li>
		<li><em>(optional)</em> <tt>href</tt> - If href is used only the href value is generated (no other parameters possible). <strong>Example:</strong> <a href="{cms_selflink href="alias"}"><img src=""></a></li>
		<li><em>(optional)</em> <tt>image</tt> - A url of an image to use in the link. <strong>Example:</strong> {cms_selflink dir="next" image="next.png" text="Next"}</li>
		<li><em>(optional)</em> <tt>alt</tt> - Alternative text to be used with image (alt="" will be used if no alt parameter is given).</li>
		<li><em>(optional)</em> <tt>imageonly</tt> - If using an image, whether to suppress display of text links. If you want no text in the link at all, also set lang=0 to suppress the label. <B>Example:</B> {cms_selflink dir="next" image="next.png" text="Next" imageonly=1}</li>
		<li><em>(optional)</em> <tt>ext</tt> - For external links, will add class="external and info text. <strong>warning:</strong> only text, target and title parameters are compatible with this parameter</li>
		<li><em>(optional)</em> <tt>ext_info</tt> - Used together with "ext" defaults to (external link)</li>
		</ul>
		</p>';
$lang['admin']['about_function_cms_module'] = '	<p>Author: Ted Kulp<tedkulp@users.sf.net></p>
	<p>Version: 1.0</p>
	<p>
	Change History:<br/>
	None
	</p>';
$lang['admin']['help_function_cms_module'] = '	<h3>What does this do?</h3>
	<p>This tag is used to insert modules into your templates and pages.  If a module is created to be used as a tag plugin (check it\'s help for details), then you should be able to insert it with this tag.</p>
	<h3>How do I use it?</h3>
	<p>It\'s just a basic tag plugin.  You would insert it into your template or page like so: <code>{cms_module module="somemodulename"}</code>
	<h3>What parameters does it take?</h3>
	<p>There is only one required parameter.  All other parameters are passed on to the module.
	<ul>
		<li>module - Name of the module to insert.  This is not case sensitive.</li>
	</ul>
	</p>';
$lang['admin']['about_function_breadcrumbs'] = '<p>Author: Marcus Deglos <<a href="mailto:md@zioncore.com">md@zioncore.com</a>></p>
<p>Version: 1.7</p>
<p>
Change History:<br/>
1.1 - Modified to use new content rewrite (wishy)<br />
1.2 - Added parameters: delimiter, initial, and root (arl)<br />
1.3 - Added parameter: classid (tdh / perl4ever)<br />
1.4 - Added parameter currentclassid and fixed some bugs (arl)<br />
1.5 - Modified to use new hierarchy manager<br />
1.6 - Modified to skip any parents that are marked to be "not shown in menu" except for root<br />
1.7 - Added root_url parameter (elijahlofgren)<br />
</p>';
$lang['admin']['help_function_breadcrumbs'] = '<h3>What does this do?</h3>
<p>Prints a breadcrumb trail .</p>
<h3>How do I use it?</h3>
<p>Just insert the tag into your template/page like: <code>{breadcrumbs}</code></p>
<h3>What parameters does it take?</h3>
<p>
<ul>
<li><em>(optional)</em> <tt>delimiter</tt> - Text to seperate entries in the list (default ">>").</li>
<li><em>(optional)</em> <tt>initial</tt> - 1/0 If set to 1 start the breadcrumbs with a delimiter (default 0).</li>
<li><em>(optional)</em> <tt>root</tt> - Page alias of a page you want to always appear as the first page in
    the list. Can be used to make a page (e.g. the front page) appear to be the root of everything even though it is not.</li>
<li><em>(optional)</em> <tt>root_url</tt> - Override the URL of the root page. Useful for making link be to \'/\' instead of \'/home/\'. This requires that the root page be set as the default page.</li>

<li><em>(optional)</em> <tt>classid</tt> - The CSS class for the non current page names, i.e. the first n-1 pages in the list. If the name is a link it is added to the <a href> tags, otherwise it is added to the <span> tags.</li>
<li><em>(optional)</em> <tt>currentclassid</tt> - The CSS class for the <span> tag surrounding the current page name.</li>
<li><em>(optional)</em> <tt>starttext</tt> - Text to append to the front of the breadcrumbs list, something like "You are here".</li>
</ul>
</p>';
$lang['admin']['about_function_anchor'] = '	<p>Author: Ted Kulp<tedkulp@users.sf.net></p>
	<p>Version: 1.1</p>
	<p>
	Change History:<br/>
	<strong>Update to version 1.1 from 1.0</strong> <em>2006/07/19</em><br/>
	Russ added the means to insert a title, a tabindex and a class for the anchor link. Westis added accesskey and changed parameter names to not include \'anchorlink\'.<br/>
	</hr>
	</p>';
$lang['admin']['help_function_anchor'] = '	<h3>What does this do?</h3>
	<p>Makes a proper anchor link.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{anchor anchor=\'here\' text=\'Scroll Down\'}</code></p>
	<h3>What parameters does it take?</h3>
	<p>
	<ul>
	<li><tt>anchor</tt> - Where we are linking to.  The part after the #.</li>
	<li><tt>text</tt> - The text to display in the link.</li>
	<li><tt>class</tt> - The class for the link, if any</li>
	<li><tt>title</tt> - The title to display for the link, if any.</li>
	<li><tt>tabindex</tt> - The numeric tabindex for the link, if any.</li>
	<li><tt>accesskey</tt> - The accesskey for the link, if any.</li>
	<li><em>(optional)</em> <tt>onlyhref</tt> - Only display the href and not the entire link. No other options will work</li>
	</ul>
	</p>';
$lang['admin']['help_function_site_mapper'] = '<h3>What does this do?</h3>
  <p>This is actually just a wrapper tag for the <a href="listmodules.php?action=showmodulehelp&module=MenuManager">Menu Manager module</a> to make the tag syntax easier, and to simplify creating a sitemap.</p>
<h3>How do I use it?</h3>
  <p>Just put <code>{site_mapper}</code> on a page or in a template. For help about the Menu Manager module, what parameters it takes etc., please refer to the Menu Manager module help</a>.</p>
  <p>By default, if no template option is specified the minimal_menu.tpl file will be used.</p>
  <p>Any parameters used in the tag are available in the menumanager template as <code>{$menuparams.paramname}</code></p>';
$lang['admin']['help_function_redirect_url'] = '<h3>What does this do?</h3>
  <p>This plugin allows you to easily redirect to a specified url.  It is handy inside of smarty conditional logic (for example, redirect to a splash page if the site is not live yet).</p>
<h3>How do I use it?</h3>
<p>Simply insert this tage into your page or template: <code>{redirect_url to=\'www.cmsmadesimple.org\'}</code></p>';
$lang['admin']['help_function_redirect_page'] = '<h3>What does this do?</h3>
 <p>This plugin allows you to easily redirect to another page.  It is handy inside of smarty conditional logic (for example, redirect to a login page if the user is not logged in.)</p>
<h3>How do I use it?</h3>
<p>Simply insert this tage into your page or template: <code>{redirect_page page=\'some-page-alias\'}</code></p>';
$lang['admin']['help_function_cms_jquery'] = '<h3>What does this do?</h3>
 <p>This plugin allows you output the javascript libraries and plugins used from the admin.</p>
<h3>How do I use it?</h3>
<p>Simply insert this tag into your page or template: <code>{cms_jquery}</code></p>

<h3>Sample</h3>
<pre><code>{cms_jquery cdn=\'true\' exclude=\'jquery.ui.nestedSortable-1.3.4.js\' append=\'uploads/NCleanBlue/js/ie6fix.js\'}</code></pre>
<h4><em>Outputs</em></h4>
<pre><code><script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.2/jquery.min.js"></script>
<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.14/jquery-ui.min.js"></script>
<script type="text/javascript" src="http://localhost/1.10.x/lib/jquery/js/jquery.json-2.2.js"></script>
<script type="text/javascript" src="uploads/NCleanBlue/js/ie6fix.js"></script>
</code></pre>

<h3><em>Included Defaults</em></h3>
<ul>
	<li><tt>jQuery</tt><em>(1.6.2)</em> - jquery-1.6.2.min.js</li>
	<li><tt>jQuery UI</tt><em>(1.8.14)</em> - jquery-ui-1.8.14.custom.min.js</li>
	<li><tt>nestedSortable</tt>(1.3.4) - jquery/js/jquery.ui.nestedSortable-1.3.4.js</li>
	<li><tt>jQuery json</tt><em>(2.2)</em> - jquery/js/jquery.json-2.2.js</li>
</ul>
    
<h3>What parameters does it take?</h3>
<ul>
	<li><em>(optional) </em><tt>exclude</tt> - use comma seperated value(CSV) list of scripts you would like to exclude. <code>\'jquery.ui.nestedSortable.js,jquery.json-2.2.js\'</code></li>
	<li><em>(optional) </em><tt>append</tt> - use comma seperated value(CSV) list of script paths you would like to append. <code>\'/uploade/jquery.ui.nestedSortable.js,http://code.jquery.com/jquery-1.6.2.min.js\'</code></li>
	<li><em>(optional) </em><tt>cdn</tt> - cdn=\'true\' will insert jQuery and jQueryUI Frameworks using Google\'s Content Delivery Netwok. Default is false.</li>
	<li><em>(optional) </em><tt>ssl</tt> - use to use the ssl_url as the base path.</li>
	<li><em>(optional) </em><tt>custom_root</tt> - use to set any base path wished.<code>custom_root=\'http://test.domain.com/\'</code> <br/>NOTE: overwrites ssl option and works with the cdn option</li>
	<li><em>(optional)</em> <tt>assign</tt> - Assign the results to the named smarty variable.</li>
	</ul>

';
$lang['admin']['of'] = 'из';
$lang['admin']['first'] = 'Первая';
$lang['admin']['last'] = 'Последняя';
$lang['admin']['adminspecialgroup'] = 'Предупреждение: члены этой группы автоматически имеют все права';
$lang['admin']['disablesafemodewarning'] = 'Отключить предупреждение администратора о включении безопасного режима ';
$lang['admin']['date_format_string'] = 'Строка формата даты';
$lang['admin']['date_format_string_help'] = '<em>strftime</em> отформатированная строка формата даты. Попробуйте погуглить \'strftime\'';
$lang['admin']['last_modified_at'] = 'Последнее обновление';
$lang['admin']['last_modified_by'] = 'Последнее изменение ';
$lang['admin']['read'] = 'Читать';
$lang['admin']['write'] = 'Писать';
$lang['admin']['execute'] = 'Выполнять';
$lang['admin']['group'] = 'Группа';
$lang['admin']['other'] = 'Другие';
$lang['admin']['event_desc_moduleupgraded'] = 'Отправлять после того, как модуль обновлён';
$lang['admin']['event_help_moduleupgraded'] = '<p>Отправлять после того, как модуль обновлён</p>';
$lang['admin']['event_desc_moduleinstalled'] = 'Отправлять после того, как модуль установлен';
$lang['admin']['event_help_moduleinstalled'] = '<p>Отправлять после того, как модуль удален</p>';
$lang['admin']['event_desc_moduleuninstalled'] = 'Отправлять после того, как модуль удален';
$lang['admin']['event_help_moduleuninstalled'] = '<p>Отправлять после того, как модуль удален.</p>';
$lang['admin']['event_desc_edituserdefinedtagpost'] = 'Отправлять после того, как тег пользователя обновлён';
$lang['admin']['event_help_edituserdefinedtagpost'] = '<p>Отправлять после того, как тег пользователя обновлён.</p>';
$lang['admin']['event_desc_edituserdefinedtagpre'] = 'Отправлять до обновления тега пользователя';
$lang['admin']['event_help_edituserdefinedtagpre'] = '<p>Отправлять до обновления тега пользователя.</p>';
$lang['admin']['event_desc_deleteuserdefinedtagpre'] = 'Отправлять до удаления тега пользователя';
$lang['admin']['event_help_deleteuserdefinedtagpre'] = '<p>Отправлять до удаления тега пользователя.</p>';
$lang['admin']['event_desc_deleteuserdefinedtagpost'] = 'Отправлять после того, как тег пользователя удалён';
$lang['admin']['event_help_deleteuserdefinedtagpost'] = '<p>Отправлять после того, как тег пользователя удалён.</p>';
$lang['admin']['event_desc_adduserdefinedtagpost'] = 'Отправлять после того, как тег пользователя вставлен';
$lang['admin']['event_help_adduserdefinedtagpre'] = '<p>Отправлять после того, как тег пользователя вставлен.</p>';
$lang['admin']['event_desc_adduserdefinedtagpre'] = 'Отправлять до вставки тега пользователя';
$lang['admin']['event_help_adduserdefinedtagpost'] = '<p>Отправлять до вставки тега пользователя.</p>';
$lang['admin']['global_umask'] = 'Маска создания файла (umask)';
$lang['admin']['errorcantcreatefile'] = 'Невозможно создать файл  (возможно, проблема с правами доступа?)';
$lang['admin']['errormoduleversionincompatible'] = 'Модуль несовместим с данной версией CMS';
$lang['admin']['errormodulenotloaded'] = 'Внутренняя ошибка системы, модуль не был обработан';
$lang['admin']['errormodulenotfound'] = 'Внутренняя ошибка системы, не найден экземпляр класса модуля';
$lang['admin']['errorinstallfailed'] = 'Установка модуля прошла неудачно';
$lang['admin']['errormodulewontload'] = 'Проблема при создании объекта доступного модуля';
$lang['admin']['frontendlang'] = 'Язык по умолчанию для интерфейса пользователей';
$lang['admin']['info_edituser_password'] = 'Измените данное поле, чтобы изменить пароль пользователя';
$lang['admin']['info_edituser_passwordagain'] = 'Измените данное поле, чтобы изменить пароль пользователя';
$lang['admin']['originator'] = 'Инициатор';
$lang['admin']['module_name'] = 'Название модуля';
$lang['admin']['event_name'] = 'Название события';
$lang['admin']['event_description'] = 'Описание события';
$lang['admin']['error_delete_default_parent'] = 'Вы не можете удалить родителя страницы по умолчанию';
$lang['admin']['jsdisabled'] = 'Извините, эта функция требует, включения Javascript';
$lang['admin']['order'] = 'Порядок';
$lang['admin']['reorderpages'] = 'Изменить порядок страниц';
$lang['admin']['reorder'] = 'Изменить порядок';
$lang['admin']['page_reordered'] = 'Порядок страниц был изменён.';
$lang['admin']['pages_reordered'] = 'Порядок страниц был успешно изменён';
$lang['admin']['sibling_duplicate_order'] = 'Две страницы одного уровня не могут иметь один и тот же порядковый номер. Порядок следования страниц не был изменён.';
$lang['admin']['no_orders_changed'] = 'Вы хотели изменить порядок следования страниц, но не поменяли номера ни одной из них. Порядок следования страниц не был изменён.';
$lang['admin']['order_too_small'] = 'Ноль не может быть порядковым номером страницы. Порядок следования страниц не был изменён.';
$lang['admin']['order_too_large'] = 'Порядковый номер страницы не может быть больше, чем число страниц на данном уровне. Порядок следования страниц не был изменен.';
$lang['admin']['user_tag'] = 'Тег пользователя';
$lang['admin']['add'] = 'Добавить';
$lang['admin']['CSS'] = 'СSS';
$lang['admin']['about'] = 'Инфо';
$lang['admin']['action'] = 'Действие';
$lang['admin']['actionstatus'] = 'Действие/Статус';
$lang['admin']['active'] = 'Активный';
$lang['admin']['addcontent'] = 'Добавить новый контент';
$lang['admin']['cantremove'] = 'Не могу удалить';
$lang['admin']['changepermissions'] = 'Сменить права';
$lang['admin']['changepermissionsconfirm'] = 'ВНИМАНИЕ\\n\\nБудет произведена проверка, есть ли у веб-сервера права на запись для всех файлов, принадлежащих модулю. \\nУверены ли вы, что хотите продолжить?';
$lang['admin']['contentadded'] = 'Контент был успешно занесён в базу данных.';
$lang['admin']['contentupdated'] = 'Контент был успешно обновлён.';
$lang['admin']['contentdeleted'] = 'Контент был успешно удалён из базы данных.';
$lang['admin']['success'] = 'Операция выполнена';
$lang['admin']['addcss'] = 'Добавить новый CSS';
$lang['admin']['addgroup'] = 'Добавить новую группу';
$lang['admin']['additionaleditors'] = 'Дополнительные редакторы';
$lang['admin']['addtemplate'] = 'Добавить новый шаблон';
$lang['admin']['adduser'] = 'Добавить нового пользователя';
$lang['admin']['addusertag'] = 'Добавить тег пользователя';
$lang['admin']['adminaccess'] = 'Доступ к административному интерфейсу';
$lang['admin']['adminlog'] = 'Журнал администратора';
$lang['admin']['adminlogcleared'] = 'Журнал администратора был успешно очищен';
$lang['admin']['adminlogempty'] = 'Журнал администратора пуст';
$lang['admin']['adminsystemtitle'] = 'Административный интерфейс';
$lang['admin']['adminpaneltitle'] = 'Административный интерфейс CMS Made Simple';
$lang['admin']['advanced'] = 'Дополнительно';
$lang['admin']['aliasalreadyused'] = 'Этот алиас уже используется на другой странице. Измените "Алиас страницы" на закладке "Настройки" на какой-нибудь другой. ';
$lang['admin']['aliasmustbelettersandnumbers'] = 'Алиас должен состоять из букв и цифр';
$lang['admin']['aliasnotaninteger'] = 'Алиас не может быть числом';
$lang['admin']['allpagesmodified'] = 'Все страницы изменены';
$lang['admin']['assignments'] = 'Подключить пользователя';
$lang['admin']['associationexists'] = 'Связь уже существует';
$lang['admin']['autoinstallupgrade'] = 'Автоматически устанавливать/обновлять';
$lang['admin']['back'] = 'Назад в меню';
$lang['admin']['backtoplugins'] = 'Назад к списку плагинов';
$lang['admin']['cancel'] = 'Отмена';
$lang['admin']['cantchmodfiles'] = 'Не могу поменять права доступа к некоторым файлам';
$lang['admin']['cantremovefiles'] = 'Проблема с перемещением файлов  (права доступа?)';
$lang['admin']['confirmcancel'] = 'Вы уверены, что хотите отменить внесённые изменения? Нажмите OK, чтобы отменить все изменения. Нажмите Отмена, чтобы продолжить редактирование.';
$lang['admin']['canceldescription'] = 'Отменить изменения';
$lang['admin']['clearadminlog'] = 'Очистить журнал администратора';
$lang['admin']['code'] = 'Код';
$lang['admin']['confirmdefault'] = 'Вы действительно хотите установить страницу по умолчанию для сайта?';
$lang['admin']['confirmdeletedir'] = 'Вы действительно хотите удалить папку с её содержимым?';
$lang['admin']['content'] = 'Контент';
$lang['admin']['contentmanagement'] = 'Управление контентом';
$lang['admin']['contenttype'] = 'Тип контента';
$lang['admin']['copy'] = 'Копировать';
$lang['admin']['copytemplate'] = 'Копировать шаблон';
$lang['admin']['create'] = 'Создать';
$lang['admin']['createnewfolder'] = 'Создать папку';
$lang['admin']['cssalreadyused'] = 'Имя CSS уже используется';
$lang['admin']['cssmanagement'] = 'Управление CSS';
$lang['admin']['currentassociations'] = 'Имеющиеся связи';
$lang['admin']['currentdirectory'] = 'Данная папка';
$lang['admin']['currentgroups'] = 'Имеющиеся группы';
$lang['admin']['currentpages'] = 'Имеющиеся страницы';
$lang['admin']['currenttemplates'] = 'Имеющиеся шаблоны';
$lang['admin']['currentusers'] = 'Имеющиеся пользователи';
$lang['admin']['custom404'] = 'Сообщение об ошибке 404';
$lang['admin']['database'] = 'База данных';
$lang['admin']['databaseprefix'] = 'Префикс базы данных';
$lang['admin']['databasetype'] = 'Тип базы данных';
$lang['admin']['date'] = 'Дата';
$lang['admin']['default'] = 'По умолчанию';
$lang['admin']['delete'] = 'Удалить';
$lang['admin']['deleteconfirm'] = 'Вы действительно хотите удалить?';
$lang['admin']['deleteassociationconfirm'] = 'Вы уверены, что хотите удалить ассоциацию с - %s - ?';
$lang['admin']['deletecss'] = 'Удалить CSS';
$lang['admin']['dependencies'] = 'Зависимость';
$lang['admin']['description'] = 'Описание';
$lang['admin']['directoryexists'] = 'Эта папка уже существует.';
$lang['admin']['down'] = 'Вниз';
$lang['admin']['edit'] = 'Редактирование';
$lang['admin']['editconfiguration'] = 'Редактирование конфигурации';
$lang['admin']['editcontent'] = 'Редактирование контента';
$lang['admin']['editcss'] = 'Редактирование стиля';
$lang['admin']['editcsssuccess'] = 'Таблица стилей обновлена';
$lang['admin']['editgroup'] = 'Редактирование группы';
$lang['admin']['editpage'] = 'Редактирование страницы';
$lang['admin']['edittemplate'] = 'Редактирование шаблона';
$lang['admin']['edittemplatesuccess'] = 'Шаблон обновлён';
$lang['admin']['edituser'] = 'Редактирование пользователя';
$lang['admin']['editusertag'] = 'Редактирование тега пользователя';
$lang['admin']['usertagadded'] = 'Тег пользователя был успешно добавлен';
$lang['admin']['usertagupdated'] = 'Тег пользователя был успешно обновлён';
$lang['admin']['usertagdeleted'] = 'Тег пользователя был успешно удалён';
$lang['admin']['email'] = 'Адрес e-mail';
$lang['admin']['errorattempteddowngrade'] = 'Установка модуля приведёт к возврату на старую версию. Операция отменена.';
$lang['admin']['errorchildcontent'] = 'Есть дочерний контент. Удалите его сначала.';
$lang['admin']['errorcopyingtemplate'] = 'Ошибка копирования шаблона';
$lang['admin']['errorcouldnotparsexml'] = 'Ошибка при анализе XML файла. Пожалуйста, удостоверьтесь, что вы загружаете .xml файл, а не .tar.gz или zip файл.';
$lang['admin']['errorcreatingassociation'] = 'Ошибка создания связи';
$lang['admin']['errorcssinuse'] = 'Стиль используется страницей или шаблоном. Пожалуйста, сначала удалите эти связи.';
$lang['admin']['errordefaultpage'] = 'Нельзя удалить страницу по умолчанию. Пожалуйста, сначала назначьте другую страницу по умолчанию.';
$lang['admin']['errordeletingassociation'] = 'Ошибка удаления связи';
$lang['admin']['errordeletingcss'] = 'Ошибка удаления css';
$lang['admin']['errordeletingdirectory'] = 'Не могу удалить папку. Проблемы с правами?';
$lang['admin']['errordeletingfile'] = 'Не могу удалить файл. Проблемы с правами?';
$lang['admin']['errordirectorynotwritable'] = 'Нет прав для записи в папку. Это может быть связано с правами на запись в файл или правами владельца. Это может быть также вызвано безопасным режимом. ';
$lang['admin']['errordtdmismatch'] = 'Версия DTD в XML файле не присутствует или несовместима';
$lang['admin']['errorgettingcssname'] = 'Ошибка получения имени стиля';
$lang['admin']['errorgettingtemplatename'] = 'Ошибка получения имени шаблона';
$lang['admin']['errorincompletexml'] = 'XML файл неполный или неверный';
$lang['admin']['uploadxmlfile'] = 'Установить модуль через файл XML';
$lang['admin']['cachenotwritable'] = 'Нет прав на запись в папку для кэша. Очистить кэш, поэтому, невозможно. Пожалуйста удостоверьтесь, что у веб-сервера полные права rwe на папку /tmp/cache  (chmod 777)';
$lang['admin']['error_nomodules'] = 'No modules installed! Check Extensions > Modules';
$lang['admin']['modulesnotwritable'] = 'Нет прав на запись в папку с модулями. Если вы хотите иметь возможность устанавливать модули через XML, вам надо дать веб серверу полные права rwe на папку с модулями (chmod 777).';
$lang['admin']['noxmlfileuploaded'] = 'Файл не был загружен. Чтобы установить модуль через XML вы должны выбрать и загрузить .xml файл модуля со своего компьютера.';
$lang['admin']['errorinsertingcss'] = 'Ошибка добавления стиля';
$lang['admin']['errorinsertinggroup'] = 'Ошибка добавления группы';
$lang['admin']['errorinsertingtag'] = 'Ошибка добавления тега пользователя';
$lang['admin']['errorinsertingtemplate'] = 'Ошибка добавления шаблона';
$lang['admin']['errorinsertinguser'] = 'Ошибка добавления пользователя';
$lang['admin']['errornofilesexported'] = 'Ошибка экспорта файла в XML';
$lang['admin']['errorretrievingcss'] = 'Ошибка извлечения таблицы стилей';
$lang['admin']['errorretrievingtemplate'] = 'Ошибка извлечения шаблона';
$lang['admin']['errortemplateinuse'] = 'Шаблон ещё используется страницей. Пожалуйста, сначала удалите её.';
$lang['admin']['errorupdatingcss'] = 'Ошибка обновления таблицы стилей';
$lang['admin']['errorupdatinggroup'] = 'Ошибка обновления группы';
$lang['admin']['errorupdatingpages'] = 'Ошибка обновления страниц';
$lang['admin']['errorupdatingtemplate'] = 'Ошибка обновления шаблона';
$lang['admin']['errorupdatinguser'] = 'Ошибка обновления пользователя';
$lang['admin']['errorupdatingusertag'] = 'Ошибка обновления тега пользователя';
$lang['admin']['erroruserinuse'] = 'Этот пользователь до сих пор владеет созданными им страницами. Пожалуйста, сначала смените владельца.';
$lang['admin']['eventhandlers'] = 'События';
$lang['admin']['eventhandler'] = 'Обработчик события';
$lang['admin']['editeventhandler'] = 'Редактировать обработчик события';
$lang['admin']['eventhandlerdescription'] = 'Связать пользовательский тег с событием';
$lang['admin']['export'] = 'Экспорт';
$lang['admin']['event'] = 'Событие';
$lang['admin']['false'] = 'False ';
$lang['admin']['settrue'] = 'Установить True';
$lang['admin']['filecreatedirnodoubledot'] = 'Папка не может содержать \'..\'.';
$lang['admin']['filecreatedirnoname'] = 'Не могу создать папку с пустым именем.';
$lang['admin']['filecreatedirnoslash'] = 'Имя папки не может содержать \'/\' или \'\\\'.';
$lang['admin']['filemanagement'] = 'Управление файлами';
$lang['admin']['filename'] = 'Имя файла';
$lang['admin']['filenotuploaded'] = 'Не могу загрузить файл. Проблемы с правами?';
$lang['admin']['filesize'] = 'Pазмер файла';
$lang['admin']['firstname'] = 'Имя';
$lang['admin']['groupmanagement'] = 'Управление группами';
$lang['admin']['grouppermissions'] = 'Права групп';
$lang['admin']['handler'] = 'Обработчик (тег пользователя)';
$lang['admin']['headtags'] = 'Теги заголовка';
$lang['admin']['help'] = 'Помощь';
$lang['admin']['new_window'] = 'новое окно';
$lang['admin']['helpwithsection'] = 'Помощь %s';
$lang['admin']['helpaddtemplate'] = '<p>Шаблоны управляют видом вашего сайта. </p><p>Можно создавать шаблоны и присоединять к ним таблицы стилей.</p>';
$lang['admin']['helplisttemplate'] = '<p>Здесь вы имеете возможность создавать, редактировать и удалять шаблоны. </p><p> Для создания нового шаблона нажмите на "Добавить шаблон". </p><p>Если вы хотите назначить шаблон для всех страниц сайта, то нажмите на "Установить для всех".</p>';
$lang['admin']['home'] = 'Домой';
$lang['admin']['homepage'] = 'Домашняя страница';
$lang['admin']['hostname'] = 'Имя хоста';
$lang['admin']['idnotvalid'] = 'Данный ID не действителен';
$lang['admin']['imagemanagement'] = 'Менеджер изображений';
$lang['admin']['informationmissing'] = 'Отсутствует информация';
$lang['admin']['install'] = 'Установить';
$lang['admin']['invalidcode'] = 'Введён неверный код';
$lang['admin']['illegalcharacters'] = 'Недопустимые символы в поле %s.';
$lang['admin']['invalidcode_brace_missing'] = 'Нечетное число скобок';
$lang['admin']['invalidtemplate'] = 'Шаблон не действителен';
$lang['admin']['itemid'] = 'ID объекта';
$lang['admin']['itemname'] = 'Имя объекта';
$lang['admin']['language'] = 'Язык';
$lang['admin']['lastname'] = 'Фамилия';
$lang['admin']['logout'] = 'Выход';
$lang['admin']['loginprompt'] = 'Введите свои данные для доступа в административную панель.';
$lang['admin']['logintitle'] = 'Вход в CMS Made Simple';
$lang['admin']['menutext'] = 'Текст меню';
$lang['admin']['missingparams'] = 'Некоторые параметны потеряны или неверны';
$lang['admin']['modifygroupassignments'] = 'Изменить входящих в группу';
$lang['admin']['moduleabout'] = 'Инфо о модуле %s';
$lang['admin']['modulehelp'] = 'Справка для модуля %s';
$lang['admin']['msg_defaultcontent'] = 'Добавьте здесь код, который должен присутствовать как контент по умолчанию на всех новых страницах';
$lang['admin']['msg_defaultmetadata'] = 'Добавьте здесь код, который должен присутствовать в секции метаданных всех новых страниц';
$lang['admin']['wikihelp'] = 'Помощь сообщества';
$lang['admin']['moduleinstalled'] = 'Модуль уже установлен';
$lang['admin']['moduleinterface'] = 'Интерфейс %s';
$lang['admin']['modules'] = 'Модули';
$lang['admin']['move'] = 'Переместить';
$lang['admin']['name'] = 'Имя';
$lang['admin']['needpermissionto'] = 'У вас должны быть права \'%s\' для того, чтобы сделать это.';
$lang['admin']['needupgrade'] = 'Нужен апгрейд';
$lang['admin']['newtemplatename'] = 'Новое имя шаблона';
$lang['admin']['next'] = 'Следующая';
$lang['admin']['noaccessto'] = 'Нет доступа к %s';
$lang['admin']['nocss'] = 'Нет стиля';
$lang['admin']['noentries'] = 'Нет записей';
$lang['admin']['nofieldgiven'] = 'Не задан %s!';
$lang['admin']['nofiles'] = 'Нет файлов';
$lang['admin']['nopasswordmatch'] = 'Пароли не совпадают';
$lang['admin']['norealdirectory'] = 'Папки не существует';
$lang['admin']['norealfile'] = 'Файла не существует';
$lang['admin']['notinstalled'] = 'Не установлен';
$lang['admin']['overwritemodule'] = 'Перезаписать имеющийся модуль';
$lang['admin']['owner'] = 'Владелец';
$lang['admin']['pagealias'] = 'Алиас страницы';
$lang['admin']['content_id'] = 'ID контента';
$lang['admin']['pagedefaults'] = 'Страница по умолчанию';
$lang['admin']['pagedefaultsdescription'] = 'Установить значения по умолчанию для новых страниц';
$lang['admin']['parent'] = 'Родитель';
$lang['admin']['password'] = 'Пароль';
$lang['admin']['passwordagain'] = 'Пароль (ещё раз)';
$lang['admin']['permission'] = 'Право';
$lang['admin']['permissions'] = 'Права';
$lang['admin']['permissionschanged'] = 'Права были обновлены.';
$lang['admin']['pluginabout'] = 'Инфо о теге %s';
$lang['admin']['pluginhelp'] = 'Справка для тега %s';
$lang['admin']['pluginmanagement'] = 'Управление плагинами';
$lang['admin']['prefsupdated'] = 'Свойства были изменены.';
$lang['admin']['accountupdated'] = 'Аккаунт пользователя был обновлен';
$lang['admin']['preview'] = 'Предпросмотр';
$lang['admin']['previewdescription'] = 'Предварительный просмотр изменений';
$lang['admin']['previous'] = 'Предыдущая';
$lang['admin']['remove'] = 'Удалить';
$lang['admin']['removeconfirm'] = 'Это действие навсегда удалить файлы, составляющие этот модуль из этой установки.\\nВы действительно хотите продолжить?';
$lang['admin']['removecssassociation'] = 'Удалить связь со стилем';
$lang['admin']['saveconfig'] = 'Сохранить настройки';
$lang['admin']['send'] = 'Отправить';
$lang['admin']['setallcontent'] = 'Установить для всех страниц';
$lang['admin']['setallcontentconfirm'] = 'Вы действительно хотите использовать этот шаблон для всех страниц?';
$lang['admin']['showinmenu'] = 'Показать в меню';
$lang['admin']['use_name'] = 'In the parent page dropdown, show the page title instead of the menu text';
$lang['admin']['showsite'] = 'Показать сайт';
$lang['admin']['sitedownmessage'] = 'Сообщение о недоступности сайта';
$lang['admin']['siteprefs'] = 'Общие настройки';
$lang['admin']['status'] = 'Статус';
$lang['admin']['stylesheet'] = 'Стиль';
$lang['admin']['submit'] = 'Отправить';
$lang['admin']['submitdescription'] = 'Сохранить изменения';
$lang['admin']['tags'] = 'Теги';
$lang['admin']['template'] = 'Шаблон';
$lang['admin']['templateexists'] = 'Шаблон с таким именем уже существует';
$lang['admin']['templatemanagement'] = 'Управление шаблонами';
$lang['admin']['title'] = 'Заголовок';
$lang['admin']['tools'] = 'Инструменты';
$lang['admin']['true'] = 'True ';
$lang['admin']['setfalse'] = 'Установить False';
$lang['admin']['type'] = 'Тип';
$lang['admin']['typenotvalid'] = 'Неверный тип';
$lang['admin']['uninstall'] = 'Отключить';
$lang['admin']['uninstallconfirm'] = 'Вы действительно хотите отключить этот модуль? Название: ';
$lang['admin']['up'] = 'Вверх';
$lang['admin']['upgrade'] = 'Обновление';
$lang['admin']['upgradeconfirm'] = 'Вы действительно хотите сделать обновление?';
$lang['admin']['uploadfile'] = 'Загрузить файл';
$lang['admin']['url'] = 'Ссылка';
$lang['admin']['useadvancedcss'] = 'Использовать управление дополнительными стилями';
$lang['admin']['user'] = 'Пользователь';
$lang['admin']['userdefinedtags'] = 'Теги пользователя';
$lang['admin']['usermanagement'] = 'Управление пользователями';
$lang['admin']['username'] = 'Имя пользователя';
$lang['admin']['usernameincorrect'] = 'Имя пользователя или пароль неверны';
$lang['admin']['userprefs'] = 'Настройки пользователя';
$lang['admin']['useraccount'] = 'Аккаунт пользователя';
$lang['admin']['lang_settings_legend'] = 'Языковые настройки';
$lang['admin']['content_editor_legend'] = 'Настройки редактора контента';
$lang['admin']['admin_layout_legend'] = 'Настройки шаблона админской панели';
$lang['admin']['usersassignedtogroup'] = 'Пользователи из группы: %s';
$lang['admin']['usertagexists'] = 'Тег с этим именем уже существует.';
$lang['admin']['usewysiwyg'] = 'Использовать визуальный редактор для контента';
$lang['admin']['version'] = 'Версия';
$lang['admin']['view'] = 'Просмотр';
$lang['admin']['welcomemsg'] = 'Добро пожаловать, %s';
$lang['admin']['directoryabove'] = 'уровень выше';
$lang['admin']['nodefault'] = 'Нет выбранного по умолчанию';
$lang['admin']['blobexists'] = 'Имя блока контента существует';
$lang['admin']['blobmanagement'] = 'Управление блоками контента';
$lang['admin']['errorinsertingblob'] = 'Ошибка добавления блока контента';
$lang['admin']['addhtmlblob'] = 'Добавить блок контента ';
$lang['admin']['edithtmlblob'] = 'Редактирование блока контента ';
$lang['admin']['edithtmlblobsuccess'] = 'Блок контента обновлен';
$lang['admin']['tagtousegcb'] = 'Тег для использования этого блока';
$lang['admin']['gcb_wysiwyg'] = 'Включить визуальный редактор в блоках контента';
$lang['admin']['gcb_wysiwyg_help'] = 'Включить визуальный редактор для редактирования блоков контента';
$lang['admin']['filemanager'] = 'Управление файлами';
$lang['admin']['imagemanager'] = 'Управление изображениями';
$lang['admin']['encoding'] = 'Кодировка';
$lang['admin']['clearcache'] = 'Очистить кэш';
$lang['admin']['clear'] = 'Очистить';
$lang['admin']['cachecleared'] = 'Кэш очищен';
$lang['admin']['apply'] = 'Применить';
$lang['admin']['applydescription'] = 'Сохранить изменения и продолжить редактирование';
$lang['admin']['none'] = 'Нет';
$lang['admin']['wysiwygtouse'] = 'Выбрать визуальный редактор';
$lang['admin']['syntaxhighlightertouse'] = 'Выбрать подсветку синтаксиса';
$lang['admin']['hasdependents'] = 'Имеет зависимости';
$lang['admin']['missingdependency'] = 'Потерянная зависимость';
$lang['admin']['minimumversion'] = 'Минимальная версия';
$lang['admin']['minimumversionrequired'] = 'Минимально необходимая версия CMSMS';
$lang['admin']['maximumversion'] = 'Максимальная версия';
$lang['admin']['maximumversionsupported'] = 'Максимальная поддерживаемая версия CMSMS';
$lang['admin']['depsformodule'] = 'Зависимости для модуля %s ';
$lang['admin']['installed'] = 'установлено';
$lang['admin']['author'] = 'Автор';
$lang['admin']['changehistory'] = 'История изменений';
$lang['admin']['moduleerrormessage'] = 'Сообщение об ошибке для модуля %s';
$lang['admin']['moduleupgradeerror'] = 'Ошибка при обновлении модуля';
$lang['admin']['moduleinstallmessage'] = 'Сообщение об установке модуля %s';
$lang['admin']['moduleuninstallmessage'] = 'Сообщение об удалении модуля %s';
$lang['admin']['admintheme'] = 'Тема для Административного интерфейса';
$lang['admin']['addstylesheet'] = 'Добавить стиль';
$lang['admin']['editstylesheet'] = 'Редактирование стиля';
$lang['admin']['addcssassociation'] = 'Добавить связь со стилем';
$lang['admin']['attachstylesheet'] = 'Присоединить этот стиль';
$lang['admin']['attachtemplate'] = 'Присоединить к этому шаблону';
$lang['admin']['main'] = 'Главная';
$lang['admin']['pages'] = 'Страницы';
$lang['admin']['page'] = 'Страница';
$lang['admin']['files'] = 'Файлы';
$lang['admin']['layout'] = 'Оформление';
$lang['admin']['usersgroups'] = 'Пользователи и группы';
$lang['admin']['extensions'] = 'Pасширения';
$lang['admin']['preferences'] = 'Настройки';
$lang['admin']['admin'] = 'Администрирование сайта';
$lang['admin']['viewsite'] = 'Просмотр сайта';
$lang['admin']['templatecss'] = 'Прикрепить шаблон к CSS';
$lang['admin']['plugins'] = 'Плагины';
$lang['admin']['movecontent'] = 'Переместить страницы';
$lang['admin']['module'] = 'Модуль';
$lang['admin']['usertags'] = 'Теги пользователя';
$lang['admin']['htmlblobs'] = 'Блоки контента';
$lang['admin']['adminhome'] = 'Главная';
$lang['admin']['liststylesheets'] = 'Таблицы стилей';
$lang['admin']['preferencesdescription'] = 'Здесь вы задаёте настройки сайта.';
$lang['admin']['adminlogdescription'] = 'Показывает список действий, совершённых админом.';
$lang['admin']['mainmenu'] = 'Главное меню';
$lang['admin']['users'] = 'Пользователи';
$lang['admin']['usersdescription'] = 'Управление пользователями.';
$lang['admin']['groups'] = 'Группы';
$lang['admin']['groupsdescription'] = 'Управление группами.';
$lang['admin']['groupassignments'] = 'Входящие в группу';
$lang['admin']['groupassignmentdescription'] = 'Здесь вы подключаете пользователей к группе.';
$lang['admin']['groupperms'] = 'Права группы';
$lang['admin']['grouppermsdescription'] = 'Управление правами группы';
$lang['admin']['pagesdescription'] = 'Здесь вы добавляете и редактируете страницы.';
$lang['admin']['htmlblobdescription'] = 'Блоки контента - фрагменты html, которые вы можете помещать на страницу или шаблон.';
$lang['admin']['templates'] = 'Шаблоны';
$lang['admin']['templatesdescription'] = 'Здесь вы добавляете и редактируете шаблоны. Шаблоны определяют внешний вид вашего сайта.';
$lang['admin']['stylesheets'] = 'Стили';
$lang['admin']['stylesheetsdescription'] = 'Управление стилями это улучшенный метод редактирования таблиц стилей отдельно от шаблона. ';
$lang['admin']['filemanagerdescription'] = 'Загрузка и управление файлами.';
$lang['admin']['imagemanagerdescription'] = 'Загрузка и управление изображениями.';
$lang['admin']['moduledescription'] = 'Расширения функциональности.';
$lang['admin']['tagdescription'] = 'Теги - небольшие расширения функциональности которые можно добавлять к шаблону или непосредственно к контенту.';
$lang['admin']['usertagdescription'] = 'Теги, создаваемые пользователем для выполнения специфических задач непосредственно из браузера.';
$lang['admin']['installdirwarning'] = '<em><strong>Внимание:</strong></em> Папка install все еще существует. Пожалуйста удалите ее полностью .';
$lang['admin']['subitems'] = 'Подпункты';
$lang['admin']['extensionsdescription'] = 'Модули, теги и пр.';
$lang['admin']['usersgroupsdescription'] = 'Пользователи и группы.';
$lang['admin']['layoutdescription'] = 'Свойства оформления.';
$lang['admin']['admindescription'] = 'Функции управление сайтом.';
$lang['admin']['contentdescription'] = 'Добавление и редактирование содержания.';
$lang['admin']['enablecustom404'] = 'Включить сообщение об ошибке 404';
$lang['admin']['enablesitedown'] = 'Включить сообщение о недоступности сайта';
$lang['admin']['enablewysiwyg'] = 'Использование редактора WYISWYG для сообщения о недоступности сайта';
$lang['admin']['bookmarks'] = 'Закладки';
$lang['admin']['user_created'] = 'Пользовательский ярлык';
$lang['admin']['forums'] = 'Форумы';
$lang['admin']['wiki'] = 'Wiki ';
$lang['admin']['irc'] = 'IRC ';
$lang['admin']['team'] = 'Команда';
$lang['admin']['documentation'] = 'Документация';
$lang['admin']['module_help'] = 'Помощь по работе с модулем';
$lang['admin']['managebookmarks'] = 'Управление закладками';
$lang['admin']['editbookmark'] = 'Правка закладки';
$lang['admin']['addbookmark'] = 'Добавить закладку';
$lang['admin']['recentpages'] = 'Последние страницы';
$lang['admin']['groupname'] = 'Имя группы';
$lang['admin']['selectgroup'] = 'Выбрать группу';
$lang['admin']['updateperm'] = 'Обновить права';
$lang['admin']['admincallout'] = 'Закладки в административном интерфейсе';
$lang['admin']['showbookmarks'] = 'Показать закладки';
$lang['admin']['hide_help_links'] = 'Скрыть ссылку на справку';
$lang['admin']['hide_help_links_help'] = 'Поставьте галку, чтобы отключить wiki и ссылки на справку модуля в заголовках страниц.';
$lang['admin']['showrecent'] = 'Показать последние страницы';
$lang['admin']['attachtotemplate'] = 'Присоединить стиль к шаблону';
$lang['admin']['attachstylesheets'] = 'Присоединить стили';
$lang['admin']['indent'] = 'Использовать отступы для обозначения иерархии';
$lang['admin']['adminindent'] = 'Вывод содержания';
$lang['admin']['contract'] = 'Скрыть секцию';
$lang['admin']['expand'] = 'Раскрыть секцию';
$lang['admin']['expandall'] = 'Раскрыть все секции';
$lang['admin']['contractall'] = 'Скрыть все секции';
$lang['admin']['menu_bookmarks'] = '[ + ]';
$lang['admin']['globalconfig'] = 'Общие настройки';
$lang['admin']['adminpaging'] = 'Количество на странице';
$lang['admin']['nopaging'] = 'Показать все';
$lang['admin']['myprefs'] = 'Мои настройки';
$lang['admin']['myprefsdescription'] = 'Здесь вы настраиваете административную часть.';
$lang['admin']['myaccount'] = 'Мой аккаунт';
$lang['admin']['myaccountdescription'] = 'Здесь Вы можете обновить настройки вашего аккаунта.';
$lang['admin']['adminprefs'] = 'Настройки пользователя';
$lang['admin']['adminprefsdescription'] = 'Здесь вы настраиваете свойства админа.';
$lang['admin']['managebookmarksdescription'] = 'Управление закладками.';
$lang['admin']['options'] = 'Опции';
$lang['admin']['langparam'] = 'Параметр, используемый для указания языка, на котором будет отображаться модуль во фронтенде. Не все модули требуют этот параметр.';
$lang['admin']['parameters'] = 'Параметры';
$lang['admin']['mediatype'] = 'Медиа Тип';
$lang['admin']['media_query'] = 'Медиа Запрос';
$lang['admin']['media_query_description'] = '<strong>Примечание:</strong> Когда используется Медиа Запрос, выбранный Медиа Тип будет проигнорирован.<br /> Используйте любые выражения рекомендованные <a href="http://www.w3.org/TR/css3-mediaqueries/" rel="external" title="W3C">W3C</a>.';
$lang['admin']['mediatype_'] = 'Не задано : будет использоваться везде';
$lang['admin']['mediatype_all'] = 'all : Подходит для всех устройств.';
$lang['admin']['mediatype_aural'] = 'aural : Предназначено для синтезаторов речи.';
$lang['admin']['mediatype_braille'] = 'braille : Предназначено для тактильных устройств для слепых.';
$lang['admin']['mediatype_embossed'] = 'embossed : Предназначено для брайлевских принтеров.';
$lang['admin']['mediatype_handheld'] = 'handheld : Предназначено для КПК';
$lang['admin']['mediatype_print'] = 'print : Предназначено для вывода на печать.';
$lang['admin']['mediatype_projection'] = 'projection : Предназначено для проекторов или прозрачек.';
$lang['admin']['mediatype_screen'] = 'screen : Предназначено для компьютерных экранов.';
$lang['admin']['mediatype_tty'] = 'tty : Предназначено для устройств вывода с моноширинными шрифтами.';
$lang['admin']['mediatype_speech'] = 'Речь : Intended for speech synthesizers.';
$lang['admin']['mediatype_tv'] = 'tv : Предназначено для вывода на устройствах телевизионного типа.';
$lang['admin']['assignmentchanged'] = 'Связи групп были обновлены';
$lang['admin']['stylesheetexists'] = 'Таблица стилей существует';
$lang['admin']['errorcopyingstylesheet'] = 'Ошибка копирования таблицы стилей';
$lang['admin']['copystylesheet'] = 'Копировать таблицу стилей';
$lang['admin']['newstylesheetname'] = 'Название новой таблицы стилей';
$lang['admin']['target'] = 'Назначение';
$lang['admin']['xml'] = 'ХML';
$lang['admin']['xmlmodulerepository'] = 'URL soap-сервера ModuleRepository';
$lang['admin']['metadata'] = 'Метаданные';
$lang['admin']['globalmetadata'] = 'Глобальные метаданные';
$lang['admin']['titleattribute'] = 'SEO описание (мета-тег)';
$lang['admin']['tabindex'] = 'Индекс вкладки';
$lang['admin']['accesskey'] = 'Клавиша доступа';
$lang['admin']['sitedownwarning'] = '<strong>Предупреждение:</strong> Ваш сайт сейчас недоступен. Удалите файл %s для решения проблемы.';
$lang['admin']['deletecontent'] = 'Удалить контент';
$lang['admin']['deletepages'] = 'Удалить эти страницы?';
$lang['admin']['selectall'] = 'Выделить все';
$lang['admin']['selecteditems'] = 'С выделенным';
$lang['admin']['inactive'] = 'Неактивный';
$lang['admin']['deletetemplates'] = 'Удалить шаблоны';
$lang['admin']['templatestodelete'] = 'Эти шаблоны будут удалены';
$lang['admin']['wontdeletetemplateinuse'] = 'Эти шаблоны используются и не могут быть удалены';
$lang['admin']['deletetemplate'] = 'Удалить таблицы стилей';
$lang['admin']['stylesheetstodelete'] = 'Эти таблицы стилей будут удалены';
$lang['admin']['sitename'] = 'Название сайта';
$lang['admin']['goto'] = 'Вернуться к:';
$lang['admin']['siteadmin'] = 'Администратор сайта';
$lang['admin']['images'] = 'Управление изображениями';
$lang['admin']['blobs'] = 'Глобальные блоки контента';
$lang['admin']['groupmembers'] = 'Права групп';
$lang['admin']['troubleshooting'] = '(Решение проблем)';
$lang['admin']['event_desc_loginpost'] = 'Отправляется после того, как пользователь вошел через панель админа';
$lang['admin']['event_desc_logoutpost'] = 'Отправляется после того, как пользователь вышел из панели админа';
$lang['admin']['event_desc_adduserpre'] = 'Отправляется перед тем, как создан новый пользователь';
$lang['admin']['event_desc_adduserpost'] = 'Отправляется после того, как создан новый пользователь';
$lang['admin']['event_desc_edituserpre'] = 'Отправляется до того, как редактирование пользователя сохранено';
$lang['admin']['event_desc_edituserpost'] = 'Отправляется после того, как редактирование пользователя сохранено';
$lang['admin']['event_desc_deleteuserpre'] = 'Отправляется до того, как пользователь удален из системы';
$lang['admin']['event_desc_deleteuserpost'] = 'Отправляется после того, как пользователь удален из сисемы';
$lang['admin']['event_desc_addgrouppre'] = 'Отправляется до того, как была создана новая группа';
$lang['admin']['event_desc_addgrouppost'] = 'Отправляется после того, как была создана новая группа';
$lang['admin']['event_desc_changegroupassignpre'] = 'Отправить до сохранения прав группы';
$lang['admin']['event_desc_changegroupassignpost'] = 'Отправить после сохранения прав группы';
$lang['admin']['event_desc_editgrouppre'] = 'Отправляется до того, как редактирование группы  сохранено';
$lang['admin']['event_desc_editgrouppost'] = 'Отправляется после того, как редактирование группы  сохранено';
$lang['admin']['event_desc_deletegrouppre'] = 'Отправляется до того, как группа была удалена из системы';
$lang['admin']['event_desc_deletegrouppost'] = 'Отправляется после того, как группа была удалена из системы';
$lang['admin']['event_desc_addstylesheetpre'] = 'Отправляется до того, как таблица стилей была создана';
$lang['admin']['event_desc_addstylesheetpost'] = 'Отправляется после того, как таблица стилей была создана ';
$lang['admin']['event_desc_editstylesheetpre'] = 'Отправляется до того, как изменения в таблице стилей были сохранены';
$lang['admin']['event_desc_editstylesheetpost'] = 'Отправляется после того, как изменения в таблице стилей были сохранены';
$lang['admin']['event_desc_deletestylesheetpre'] = 'Отправляется до того, как таблица стилей была удалена из системы';
$lang['admin']['event_desc_deletestylesheetpost'] = 'Отправляется после того, как таблица стилей была удалена из системы';
$lang['admin']['event_desc_addtemplatepre'] = 'Отправляется до того, как создан новый шаблон';
$lang['admin']['event_desc_addtemplatepost'] = 'Отправляется после того, как создан новый шаблон';
$lang['admin']['event_desc_edittemplatepre'] = 'Отправляется до того, как изменения шаблона были сохранены';
$lang['admin']['event_desc_edittemplatepost'] = 'Отправляется после того, как изменения шаблона были сохранены';
$lang['admin']['event_desc_deletetemplatepre'] = 'Отправляется до того, как шаблон был удалён из  системы';
$lang['admin']['event_desc_deletetemplatepost'] = 'Отправляется после того, как шаблон был удалён из  системы';
$lang['admin']['event_desc_templateprecompile'] = 'Отправляется до того, как шаблон отдаётся на обработку smarty';
$lang['admin']['event_desc_templatepostcompile'] = 'Отправляется после того, как шаблон отдаётся на обработку smarty';
$lang['admin']['event_desc_addglobalcontentpre'] = 'Отправляется до того, как создан новый глобальный блок содержимого';
$lang['admin']['event_desc_addglobalcontentpost'] = 'Отправляется после того, как создан новый глобальный блок содержимого';
$lang['admin']['event_desc_editglobalcontentpre'] = 'Отправляется до того, как изменения в глобальном блоке содержимого сохранены ';
$lang['admin']['event_desc_editglobalcontentpost'] = 'Отправляется после того, как изменения в глобальном блоке содержимого сохранены ';
$lang['admin']['event_desc_deleteglobalcontentpre'] = 'Отправляется до того, как глобальной блок содержимого удален из системы';
$lang['admin']['event_desc_deleteglobalcontentpost'] = 'Отправляется после того, как глобальной блок содержимого удален из системы';
$lang['admin']['event_desc_globalcontentprecompile'] = 'Отправляется до того, как глобальной блок содержимого отдаётся на обработку smarty.';
$lang['admin']['event_desc_globalcontentpostcompile'] = 'Отправляется после того, как глобальной блок содержимого отдаётся на обработку smarty.';
$lang['admin']['event_desc_contenteditpre'] = 'Отправляется до того, как изменения в содержимом сохранены';
$lang['admin']['event_desc_contenteditpost'] = 'Отправляется после того, как изменения в содержимом сохранены';
$lang['admin']['event_desc_contentdeletepre'] = 'Отправляется до того, как  содержимое удалено из системы';
$lang['admin']['event_desc_contentdeletepost'] = 'Отправляется после того, как  содержимое удалено из системы';
$lang['admin']['event_desc_contentstylesheet'] = 'Отправляется до того, как таблица стилей отправлена браузеру';
$lang['admin']['event_desc_contentprecompile'] = 'Отправляется до того, как содержание отправлено smarty для обработки';
$lang['admin']['event_desc_contentpostcompile'] = 'Отправляется после того, как было обрботано smarty';
$lang['admin']['event_desc_contentpostrender'] = 'Отправляется до того, как был отправлен браузеру комбинированный html ';
$lang['admin']['event_desc_smartyprecompile'] = 'Отправляется до того, как какое- либо содержимое, предназначенное для smarty отправлено на обработку ';
$lang['admin']['event_desc_smartypostcompile'] = 'Отправляется после того, как какое- либо содержимое, предназначенное для smarty отправлено на обработку ';
$lang['admin']['event_help_loginpost'] = '<p>Отправляется после того, как пользователь входит в панель админа.</p>
<h4>Параметры</h4>
<ul>
<li>\'user\' - Ссылка на объект пользователя.</li>
</ul>
';
$lang['admin']['event_help_logoutpost'] = '<p>Отправляется после того, как пользователь выходит из панели админа.</p>
<h4>Параметры</h4>
<ul>
<li>\'user\' -Ссылка на объект пользователя.</li>
</ul>
';
$lang['admin']['event_help_adduserpre'] = '<p>Отправляется до того, как создан новый пользователь.</p>
<h4>Параметры</h4>
<ul>
<li>\'user\' - Ссылка на объект пользователя.</li>
</ul>
';
$lang['admin']['event_help_adduserpost'] = '<p>Отправляется после того, как создан новый пользователь.</p>
<h4>Параметры</h4>
<ul>
<li>\'user\' - Ссылка на объект пользователя.</li>
</ul>
';
$lang['admin']['event_help_edituserpre'] = '<p>Отправляется до того, как изменения профиля пользователя сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'user\' - Ссылка на объект пользователя.</li>
</ul>
';
$lang['admin']['event_help_edituserpost'] = '<p>Отправляется после того, как изменения профиля пользователя сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'user\' - Ссылка на объект пользователя.</li>
</ul>
';
$lang['admin']['event_help_deleteuserpre'] = '<p>Отправляется до того,к ак пользователь удален из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'user\' - Ссылка на объект пользователя.</li>
</ul>
';
$lang['admin']['event_help_deleteuserpost'] = '<p>Отправляется после того, как пользователь удален из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'user\' - Ссылка на объект пользователя.</li>
</ul>
';
$lang['admin']['event_help_addgrouppre'] = '<p>Отправляется до того, как создана новая группа.</p>
<h4>Параметры</h4>
<ul>
<li>\'group\' - Ссылка на объект группы.</li>
</ul>
';
$lang['admin']['event_help_addgrouppost'] = '<p>Отправляется после того, как создана новая группа.</p>
<h4>Параметры</h4>
<ul>
<li>\'group\' - Ссылка на объект группы.</li>
</ul>
';
$lang['admin']['event_help_changegroupassignpre'] = '<p>Отправляется до того, как сохранены назначения группы.</p>
<h4>Параметры></h4>
<ul>
<li>\'group\' - Ссылка на объект группы.</li>
<li>\'users\' - Массив ссылок на объекты пользователей группы.</li>
';
$lang['admin']['event_help_changegroupassignpost'] = '<p>Отправляется после того, как сохранены назначения группы</p>
<h4>Параметры></h4>
<ul>
<li>\'group\' - Ссылка на объект группы.</li>
<li>\'users\' - Массив ссылок на объекты пользователей группы.</li>
';
$lang['admin']['event_help_editgrouppre'] = '<p>Отправляется до того, как изменения в профиле группы  были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'group\' - Ссылка на объект группы.</li>
</ul>
';
$lang['admin']['event_help_editgrouppost'] = '<p>Отправляется после того, как изменения в профиле группы были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'group\' - Ссылка на объект группы.</li>
</ul>
';
$lang['admin']['event_help_deletegrouppre'] = '<p>Отправляется до того, как группа была удалена из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'group\' - Ссылка на объект группы.</li>
</ul>
';
$lang['admin']['event_help_deletegrouppost'] = '<p>Отправляется после того, как группа была удалена из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'group\' - Ссылка на объект группы.</li>
</ul>
';
$lang['admin']['event_help_addstylesheetpre'] = '<p>Отправляется до того, как создана новая таблица стилей.</p>
<h4>Параметры</h4>
<ul>
<li>\'stylesheet\' - Ссылка на объект таблицы стилей.</li>
</ul>
';
$lang['admin']['event_help_addstylesheetpost'] = '<p>Отправляется после того, как создана новая таблица стилей.</p>
<h4>Параметры</h4>
<ul>
<li>\'stylesheet\' - Ссылка на объект таблицы стилей.</li>
</ul>
';
$lang['admin']['event_help_editstylesheetpre'] = '<p>Отправляется до того, как изменения в профиле таблицы стилей были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'stylesheet\' - Ссылка на объект таблицы стилей.</li>
</ul>
';
$lang['admin']['event_help_editstylesheetpost'] = '<p>Отправляется после того, как изменения в профиле таблицы стилей были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'stylesheet\' - Ссылка на объект таблицы стилей.</li>
</ul>
';
$lang['admin']['event_help_deletestylesheetpre'] = '<p>Отправляется до того, как таблица стилей была удалена из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'stylesheet\' - Ссылка на объект таблицы стилей.</li>
</ul>
';
$lang['admin']['event_help_deletestylesheetpost'] = '<p>Отправляется после того, как таблица стилей была удалена из системы.</p>
<h4>параметры</h4>
<ul>
<li>\'stylesheet\' - Ссылка на объект таблицы стилей.</li>
</ul>
';
$lang['admin']['event_help_addtemplatepre'] = '<p>Отправляется до того, как был создан новый шаблон.</p>
<h4>Параметры</h4>
<ul>
<li>\'template\' - Ссылка на объект шаблона.</li>
</ul>
';
$lang['admin']['event_help_addtemplatepost'] = '<p>Отправляется после того, как был создан новый шаблон.</p>
<h4>Параметры</h4>
<ul>
<li>\'template\' - Ссылка на объект шаблона.</li>
</ul>
';
$lang['admin']['event_help_edittemplatepre'] = '<p>Отправляется до того, как изменения в  профиле шаблона были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'template\' - Ссылка на объект шаблона.</li>
</ul>
';
$lang['admin']['event_help_edittemplatepost'] = '<p>Отправляется после того, как изменения в профиле шаблона были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'template\' - Ссылка на объект шаблона.</li>
</ul>
';
$lang['admin']['event_help_deletetemplatepre'] = '<p>Отправляется до того, как шаблон был удален из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'template\' - Ссылка на объект шаблона.</li>
</ul>
';
$lang['admin']['event_help_deletetemplatepost'] = '<p>Отправляется после того, как шаблон был удален из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'template\' - Ссылка на объект шаблона.</li>
</ul>
';
$lang['admin']['event_help_templateprecompile'] = '<p>Отправляется до того, как шаблон был отослан smarty для обработки.</p>
<h4>Параметры</h4>
<ul>
<li>\'template\' - Ссылка на текст шаблона.</li>
</ul>
';
$lang['admin']['event_help_templatepostcompile'] = '<p>Отправляется после того, как шаблон был отослан smarty для обработки.</p>
<h4>Параметры</h4>
<ul>
<li>\'template\' - Ссылка на текст шаблона.</li>
</ul>
';
$lang['admin']['event_help_addglobalcontentpre'] = '<p>Отправляется до того, как был создан новый глобальный блок содержания.</p>
<h4>Параметры</h4>
<ul>
<li>\'global_content\' - Ссылка на объект блока контента.</li>
</ul>
';
$lang['admin']['event_help_addglobalcontentpost'] = '<p>Отправляется после того, как был создан новый глобальный блок содержания.</p>
<h4>Параметры</h4>
<ul>
<li>\'global_content\' - Ссылка на объект блока контента.</li>
</ul>
';
$lang['admin']['event_help_editglobalcontentpre'] = '<p>Отправляется до того, как изменения в глобальном блоке содержания были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'global_content\' - Ссылка на объект блока контента.</li>
</ul>
';
$lang['admin']['event_help_editglobalcontentpost'] = '<p>Отправляется после того, как изменения в глобальном блоке содержания были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'global_content\' - Ссылка на объект блока контента.</li>
</ul>
';
$lang['admin']['event_help_deleteglobalcontentpre'] = '<p>Отправляется до того, как глобальный блок содержания был удален из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'global_content\' - Ссылка на объект блока контента.</li>
</ul>
';
$lang['admin']['event_help_deleteglobalcontentpost'] = '<p>Отправляется после того, как глобальный блок содержания был удален из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'global_content\' - Ссылка на объект блока контента.</li>
</ul>
';
$lang['admin']['event_help_globalcontentprecompile'] = '<p>Отправляется до того, как глобальный блок содержания был отослан smarty для обработки.</p>
<h4>Parameters</h4>
<ul>
<li>\'global_content\' - Ссылка на текст блока контента.</li>
</ul>
';
$lang['admin']['event_help_globalcontentpostcompile'] = '<p>Отправляется после того, как глобальный блок содержания был обработан smarty.</p>
<h4>Параметры</h4>
<ul>
<li>\'global_content\' - Ссылка на текст блока контента.</li>
</ul>
';
$lang['admin']['event_help_contenteditpre'] = '<p>Отправляется до того, как изменения содержания были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'global_content\' - Ссылка на объект контента.</li>
</ul>
';
$lang['admin']['event_help_contenteditpost'] = '<p>Отправляется до того, как изменения содержания были сохранены.</p>
<h4>Параметры</h4>
<ul>
<li>\'content\' - Ссылка на объект контента.</li>
</ul>
';
$lang['admin']['event_help_contentdeletepre'] = '<p>Отправляется до того, как содержание было удалено из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'content\' - Ссылка на объект контента.</li>
</ul>
';
$lang['admin']['event_help_contentdeletepost'] = '<p>Отправляется после того, как содержание было удалено из системы.</p>
<h4>Параметры</h4>
<ul>
<li>\'content\' - Ссылка на объект контента.</li>
</ul>
';
$lang['admin']['event_help_contentstylesheet'] = '<p>Отправляется до того, как таблица стилей была отослана браузеру.</p>
<h4>Параметры</h4>
<ul>
<li>\'content\' - Ссылка на текст таблицы стилей.</li>
</ul>
';
$lang['admin']['event_help_contentprecompile'] = '<p>Отправляется до того, как содержание было отослано smarty для обработки.</p>
<h4>Параметры</h4>
<ul>
<li>\'content\' - Ссылка на текст контента.</li>
</ul>
';
$lang['admin']['event_help_contentpostcompile'] = '<p>Отправляется после того, как содержание было обработано smarty.</p>
<h4>Параметры</h4>
<ul>
<li>\'content\' - Ссылка на текст контента.</li>
</ul>
';
$lang['admin']['event_help_contentpostrender'] = '<p>Отправляется до того, как объединённый html был отправлен браузеру.</p>
<h4>Параметры</h4>
<ul>
<li>\'content\' - Ссылка на текст html.</li>
</ul>
';
$lang['admin']['event_help_smartyprecompile'] = '<p>Отправляется до того, как какое- либо содержание, предназначенное smarty было отослано для обработки.</p>
<h4>Параметры</h4>
<ul>
<li>\'content\' - Ссылка на текст.</li>
</ul>
';
$lang['admin']['event_help_smartypostcompile'] = '<p>Отправляется до того, как какое- либо содержание, предназначенное smarty было обработано.</p>
<h4>Параметры</h4>
<ul>
<li>\'content\' - Ссылка на текст.</li>
</ul>
';
$lang['admin']['filterbymodule'] = 'Фильтровать по модулю';
$lang['admin']['showall'] = 'Показать все';
$lang['admin']['core'] = 'Ядро';
$lang['admin']['defaultpagecontent'] = 'Контент страницы по умолчанию';
$lang['admin']['file_url'] = 'Ссылка на файл (вместо URL)';
$lang['admin']['no_file_url'] = 'Пусто (используйте URL выше)';
$lang['admin']['defaultparentpage'] = 'Страница-родитель по-умолчанию';
$lang['admin']['error_udt_name_whitespace'] = 'Ошибка: Определённые пользователем теги не могут содержать пробелов в имени тега.';
$lang['admin']['warning_safe_mode'] = '<strong><em>ПРЕДУПРЕЖДЕНИЕ:</em></strong> Включен безопасный режим PHP.  Это может вызвать трудности с загрузкой файлов через интерфейс браузера, а также модулей и изображений. Для выключения безопасного режима, обратитесь к администратору вашего сайта.';
$lang['admin']['test'] = 'Проверка';
$lang['admin']['results'] = 'Результаты';
$lang['admin']['untested'] = 'Не проверено';
$lang['admin']['unknown'] = 'Неизвестно';
$lang['admin']['download'] = 'Загрузка';
$lang['admin']['frontendwysiwygtouse'] = 'Визуальный редактор для использования на сайте';
$lang['admin']['backendwysiwygtouse'] = 'Серверная часть (бэкэнд) wysiwyg (для новых пользователей)';
$lang['admin']['all_groups'] = 'Все группы';
$lang['admin']['error_type'] = 'Ошибочный тип';
$lang['admin']['contenttype_errorpage'] = 'Страница ошибки';
$lang['admin']['errorpagealreadyinuse'] = 'Код ошибки уже используется';
$lang['admin']['404description'] = 'Страница не найдена';
$lang['admin']['usernotfound'] = 'Пользователь не найден';
$lang['admin']['passwordchange'] = 'Пожалуйста создайте новый пароль';
$lang['admin']['recoveryemailsent'] = 'Письмо было отправлено по заданному адресу.  Для дальнейших инструкций, проверьте пожалуйста  папку входящих сообщений .';
$lang['admin']['errorsendingemail'] = 'При отправке сообщения возникла ошибка.  Свяжитесь с вашим администратором. ';
$lang['admin']['passwordchangedlogin'] = 'Пароль был изменен.  Пожалуйста авторизуйтесь, используя новые данные доступа.';
$lang['admin']['nopasswordforrecovery'] = 'Адрес электронной почты не установлен для этого пользователя. Восстановление пароля не возможно. Пожалуйста свяжитесь со своим администратором.';
$lang['admin']['lostpw'] = 'Забыли ваш пароль?';
$lang['admin']['lostpwemailsubject'] = '[%s] пароль восстановлен';
$lang['admin']['lostpwemail'] = 'Вы получили это письмо, потому что кто-то обратился с просьбой, изменить (%s) пароль, связанный с учетной записью пользователя (%s). Если Вы хотите бы сбросить пароль для этой учетной записи, просто нажмите на ссылку ниже или вставьте её в область url на Вашем любимом браузере: %s

Если Вы считаете это действие неправильным или запрос сделан по ошибке, просто проигнорируйте это письмо, и ничто не изменится.';
$lang['admin']['utmz'] = '156861353.1357695352.1.1.utmccn=(direct)|utmcsr=(direct)|utmcmd=(none)';
$lang['admin']['utma'] = '156861353.2110014820.1357695352.1357730232.1357752424.5';
$lang['admin']['utmc'] = '156861353';
$lang['admin']['utmb'] = '156861353';
?>