<script type="text/javascript">
$(function() {
    // prevent browser default drag/drop handling
    $(document).bind('drop dragover', function(e) {
        // prevent default drag/drop stuff.
        e.preventDefault();
    });

    $('#cancel').on('click',function(e){
        e.preventDefault();
        aborting = true;
        var ul = $('#fileupload').data('fileupload');
        if( typeof ul != 'undef' )
        {
          var data = {};
          data.errorThrown = 'abort';
	  ul._trigger('fail', e, data);
        }
    });

    // create our file upload area.
    $('#fileupload').fileupload({
        url: '{$url}',
        form: null,
        formData: { {$actionid}foo: 'bar' },
    	dataType: 'json',
    	dropZone: $('#dropzone'),
    	maxChunkSize: {$max_chunksize},
    	
    	start: function(e,data){
		$('#cancel').show();
    		$('#progressarea').show();
    	},
    	
        fail: function(e, data) {
        },

        progressall: function(e, data) {
        	// overall progress callback
        	var perc = (data.loaded / data.total * 100).toFixed(2);
            var total = null;
            total = (data.loaded / data.total * 100).toFixed(0);
            var str = perc + ' %';
        	//console.log(total);
        	barValue(total);
        		function barValue(total) {
                    	$("#progressarea").progressbar({
                    		value: parseInt(total)
                    	});
                    	$(".ui-progressbar-value").html(str);							    
        		}
        },

        stop: function(e, data) {
            $('#filesarea').load(refresh_url);
            $('#cancel').fadeOut();
            $('#progressarea').fadeOut();
        }  
    });
});
</script>

<style type="text/css">
.upload-wrapper {
	margin: 10px 0
}
.hcentered { 
	text-align: center
	}
.vcentered { 
	display: table-cell; 
	vertical-align: middle
   }
#dropzone { 
	margin: 15px 0;
	border-radius: 4px;
	border: 2px dashed #ccc 
	}
#dropzone:hover{
	cursor: move
}	
#progressarea { 
	margin: 15px;
	height: 2em;
	line-height: 2em;
	text-align: center; 
	border: 1px solid #aaa;
	border-radius: 4px;
	display: none
	}
</style>
<h3>{$prompt_path}&nbsp;{$path}</h3>

{$formstart}
<input type="hidden" name="disable_buffer" value="1"/>
<fieldset>
{if isset($is_ie)}
<div class="pageerrorcontainer message">
  <p class="pageerror">{$ie_upload_message}</p>
</div>
{/if}
<div class="upload-wrapper">
<div style="width: 60%; float: left;">
  {*<input type="hidden" name="MAX_FILE_SIZE" value="{$maxfilesize}" />*}{* recommendation for browser *}
  <input id="fileupload" type="file" name="{$actionid}files[]" multiple/>
  <div id="pageoverflow">
    <p class="pagetext"></p>
    <p class="pageinput">
      <input id="cancel" type="submit" value="{$mod->Lang('cancel')}" style="display: none;"/>
    </p>
  </div>
</div>
<div id="leftcol" style="height: 4em; width: 40%; float: left; display: table;">
  {if !isset($is_ie)}
  <div id="dropzone" class="vcentered hcentered"><p id="dropzonetext">{$mod->Lang('prompt_dropfiles')}</p></div>
  {/if}
</div>
<div class="clearb"></div>
<div id="progressarea"></div>
</div>
</fieldset>
{$formend}
