<?php
if (!isset($gCms)) exit;

// Set-up JS
$this->LoadJS();

//Get the image id
$image_id = '';
if (isset($params['image_id'])){
    $image_id = $params['image_id'];
}

//If submitted update the setting for the image
//update the db with the save button(no redirect)
if(isset($_POST['m1_save'])){
	$check = $this->CheckSettingsFields($params);
	if($check){
		$this->UpdateSetting($image_id, $params);
		echo $this->ShowMessage($this->Lang('setting_content_update'));
	}else{
		//show error
		echo $this->ShowErrors($this->Lang('setting_content_update_failure'));
	}
}elseif(isset($_POST['m1_submit'])){
	//update the db with the submit button(redirect)
	$check = $this->CheckSettingsFields($params);
	if($check){
		$this->UpdateSetting($image_id, $params);
		$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab' => 'preferences', 'image_update' => '1'));
	}else{
		echo $this->ShowErrors($this->Lang('image_content_update_failure'));
	}
}

//return to overview
if(isset($_POST['m1_cancel'])){
	$this->Redirect($id, 'defaultadmin');
}elseif(isset($_POST['m1_create'])){
	//insert into db
	$check = $this->CheckSettingsFields($params);
	if($check){
		//add record in database
		$this->AddSetting($params);
		$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab' => 'preferences', 'image_create' => '1'));
	}else{
		//return error
		echo $this->ShowErrors($this->Lang('image_content_update_failure'));
		
		$image = array();
		$fields = array('title', 'path', 'width', 'height');
		foreach($fields as $field){
			$image[$field] = $params[$field];
		}
		
	}
}

if (isset($params['image_id']) && !isset($_POST['m1_create'])){
	//Get the image information 
	$image = $this->GetSetting($image_id);
}

if(isset($_POST['m1_save']) || isset($_POST['m1_submit'])){
	$fields = array('title', 'path', 'width', 'height');
	foreach($fields as $field){
		$image[$field] = $params[$field];
	}
}

//Create form start and ending
if(isset($params['addimage']) || (isset($_POST['m1_create']))){
	$this->smarty->assign('create', $this->CreateInputSubmit($id, 'create', $this->Lang('create')));
	$this->smarty->assign('page_title', $this->Lang('image_setting_new'));
}else{
	$this->smarty->assign('save', $this->CreateInputSubmit($id, 'save', $this->Lang('save')));
	$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
	$this->smarty->assign('page_title', $this->Lang('image_title_update') .' '. $image['title']);
}

$inline = '';
$idsuffix = '';
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));
$this->smarty->assign('form_start', $this->CreateFormStart($id, 'addeditsetting', $returnid, 'post', 'multipart/form-data', $inline, $idsuffix, array("image_id" => $image_id)));
$this->smarty->assign('form_end', $this->CreateFormEnd());
$this->smarty->assign('locatie_uitleg', $this->lang('explain_path'));

//Create the inputfields
$fields = array('title', 'path', 'width', 'height');
foreach($fields as $field){
	if (isset($params['image_id']) || isset($_POST['m1_create'])){
		$value = $image[$field];
	}else{
		$value = '';
	}
	$this->smarty->assign('image_input_'. $field, $this->CreateInputText($id, $field, $value, 55));
}

//Create the field labels and check if they are required
$reqs = array('title' => '1', 'path' => '1', 'width' => '1', 'height' => '1');
$labels = array('title', 'path', 'width', 'height');
foreach($labels as $label){
	$require = (array_key_exists($label, $reqs)) ? ' * ':'';
	$this->smarty->assign('image_'. $label, $this->Lang('image_'. $label) .''. $require);
}

//assign tooltips to smarty vars
$tooltips = array('title', 'path', 'width', 'height');
foreach($tooltips as $tooltip) {
	$this->smarty->assign('image_'. $tooltip .'_help', $this->MakeToolTip($this->Lang('input_' . $tooltip . '_help')));
}

echo $this->ProcessTemplate('admin_addeditsetting.tpl');
?>