<?php
class BWImages extends CMSModule
{
	public static $teller = 0;

	function GetName()
	{
		return get_class($this); 
	}
	
	function GetFriendlyName()
  	{
		return $this->Lang('friendlyname');
  	}

  	function GetVersion()
  	{
    	return '1.1';
  	}	
  	
 	function GetHelp()
  	{
    	return $this->Lang('help');
  	}
  	
  	function GetAuthor()
  	{
    	return "Buildnet Webservices";
  	}
  	
   	function GetAuthorEmail()
  	{
   		return 'support@buildnet.nl';
  	}
  	
  	function GetChangeLog()
  	{
   		return $this->Lang('changelog');
  	}
  	
  	function IsPluginModule()
  	{
    	return true;
  	}

  	function HasAdmin()
  	{
    	return true;
  	}
  	
  	function GetAdminSection()
  	{
    	return 'content';
  	}
  	
 	function GetAdminDescription()
  	{
    	return $this->Lang('moddescription');
  	}

  	function VisibleToAdminUser()
  	{
  		return 	$this->CheckPermission('Upload images in BWImages') ||
  				$this->CheckPermission('Add settings BWImages');
  	}
  	
	function GetDependencies()
	{
	    return array();
	}
	
  	function MinimumCMSVersion()
  	{
    	return "1.1";
  	}
  	
  	function SetParameters()
  	{		
   		//$this->RegisterModulePlugin();
  	}

	

  	// -----------------------------------------------------------
  	/* Module functies */
  	// -----------------------------------------------------------
  	
  	//show all the image settings
	function SettingsOverview($object, $order = 'title', $by = 'DESC'){
		$db =& $this->GetDb();
		$gCms = cmsms();
		$vars = array();
	
		$query = 'SELECT id, title, path, width, height FROM '.cms_db_prefix().'module_bwimages_settings 
				  ORDER BY '. addslashes($order) .' '. $by .' ' ;
		
		$dbresult = $db->Execute($query, $vars);
		//echo $db->sql;
		if ($dbresult){
			$array = array();
			while($found = $dbresult->FetchRow()){
			  	$array[] = $found; 
			}
			
			return $array;
				
		}
		
		return false;
	}
	
	// Make tooltip for help
  	function MakeToolTip($tekst){
		$gCms = cmsms();
		
		$class = "help".rand(1000,9999);
	  	$icon = '<a title="'.$tekst.'" class="'.$class.'">'.$gCms->variables['admintheme']->DisplayImage('icons/system/info.gif', '','','','systemicon').'</a>';
	  	$icon .= '<script type="text/javascript">
	  	$("a.'.$class.'").tooltip()
	  	</script>';
	  	
	  	$return = $icon;
	  	
	  	return $return;
	  }

	 //give the module path back
	 function ModulePath(){
	 	$str = "/modules/".$this->GetName()."/";
		return $str;
	 }	 
	 
	//load javascript
	function LoadJS(){
	  	$libdir = $this->ModulePath() . "lib" . DIRECTORY_SEPARATOR . "js" . DIRECTORY_SEPARATOR;
	  	echo '<script type="text/javascript" src="'.$libdir.'jquery.tooltip.min.js" ></script>';
	  	echo '<link rel="stylesheet" type="text/css" href="'.$libdir.'jquery.tooltip.css" ></link>';
	  	//echo '<script src="'.$libdir.'jquery.min.js" type="text/javascript"></script>';
	  }
	  
	  function LoadJcrop() {
	  	$libdir = $this->ModulePath() . "lib" . DIRECTORY_SEPARATOR . "js" . DIRECTORY_SEPARATOR;
 		echo '<script src="'.$libdir.'jquery.Jcrop.js" type="text/javascript"></script>';
   		echo '<link rel="stylesheet" href="'.$libdir.'jquery.Jcrop.css" type="text/css" />';
   		echo '<script src="'.$libdir.'jquery.Jcrop.action.js" type="text/javascript"></script>';
	  }
	  
	  function LoadFancybox() {
	  	$libdir = $this->ModulePath() . "lib" . DIRECTORY_SEPARATOR . "js" . DIRECTORY_SEPARATOR;
	  	echo '<script type="text/javascript" src="' .$libdir. 'fancybox/jquery.fancybox.pack.js"></script>';
	  	echo '<link rel="stylesheet" href="' .$libdir. 'fancybox/jquery.fancybox.css" type="text/css" media="screen" />';
	  }
	

	//Delete a image setting
	function DeleteSetting($id){
		$db =& $this->GetDb();
		
		$vars = array();
		$vars[] = $id;
		$query = 'DELETE FROM '.cms_db_prefix().'module_bwimages_settings WHERE id = ?';
		
		$dbresult = $db->Execute($query, $vars);
	}
	
	//Add a new image setting
	function AddSetting($values){
		$db =& $this->GetDb();
		$vars = array();
		
		// Generate ID & Execute query
    	$imageid = $db->GenID(cms_db_prefix() . "module_bwimages_settings_seq");
    	//echo $imageid;
    	$vars[] = $imageid;
    	
		$items = array('title', 'path', 'width', 'height');
		foreach($items as $item){
			$vars[] = $values[$item];
		}   	
		$query = 'INSERT INTO '.cms_db_prefix().'module_bwimages_settings 
				  (id, title, path, width, height)
				  VALUES 
				  (?, ?, ?, ?, ?)';
		$dbresult = $db->Execute($query, $vars);
		//echo $db->sql;
	}
	
	//check if the fields are correct
	function CheckSettingsFields($values){
		$labels = array('title', 'path', 'width', 'height');
		$check = false;
		
		if(	$values['title'] && $values['path'] && $values['width'] 
			&& $values['height'] && is_numeric($values['width']) 
			&& is_numeric($values['height'])){ 
				$check =  true;
			}		
		return $check;
	}

	
	//Update a image setting
	function UpdateSetting($image_id, $values){
		$db =& $this->GetDb();

		$vars = array();
		$items = array('title', 'path', 'width', 'height');
		foreach($items as $item){
			$vars[] = $values[$item];
		}
		
		$vars[] = $image_id;
		
		$query = 'UPDATE '.cms_db_prefix().'module_bwimages_settings 
				  SET title = ?, path = ?, width = ?, height = ?
				  WHERE id = ?';
		$dbresult = $db->Execute($query, $vars);	
	}
	
	//Get image setting information
	function GetSetting($image_id){
		$db =& $this->GetDb();
		
		$query = 'SELECT id, title, path, width, height
				  FROM '.cms_db_prefix().'module_bwimages_settings  
				  WHERE id = ?' ;
		//echo $faq_id;
		$vars = array();
		$vars[] = $image_id;
		$dbresult = $db->Execute($query, $vars);
		//echo $db->sql;
		if ($dbresult){
			return $dbresult->FetchRow();
		}
		return false;
	}

	function GetSettingsTitles() {
		$db =& $this->GetDb();
		
		$query = 'SELECT id, title
				  FROM '.cms_db_prefix().'module_bwimages_settings  
				  ' ;
		//echo $faq_id;
		$dbresult = $db->Execute($query);
		//echo $db->sql;
		if ($dbresult){
			$array = array();
			while($found = $dbresult->FetchRow()){
			  	$array[$found['title']] = $found['id']; 
			}
			
			return $array;
				
		}
		
		return false;
	}
	
	// Function to check whether a file field has been defined in the news module
	function GetNewsField(){
		$db =& $this->GetDb();
		$query = "SELECT * FROM ".cms_db_prefix()."module_news_fielddefs WHERE type=? LIMIT 1";
		$vars = array('file');
		$dbresult = $db->Execute($query,$vars);
		return $dbresult->FetchRow();
	}
	
	// Function to get news items
	function GetNewsItems(){
		$db =& $this->GetDb();
		$query = "SELECT * FROM ".cms_db_prefix()."module_news ORDER BY news_date DESC";
		$dbresult = $db->Execute($query);
		if ($dbresult){
			$array = array();
			while($found = $dbresult->FetchRow()){
			  	$array[$found['news_title']] = $found['news_id']; 
			}
			return $array;
		}
		return false;
	}
	
	// Function to get settings for news images
	function GetNewsSettings(){
		$db =& $this->GetDb();
		$query = "SELECT * FROM ".cms_db_prefix()."module_bwimages_newssettings LIMIT 1";
		$dbresult = $db->Execute($query);
		if ($dbresult){			
			$found = $dbresult->FetchRow();			  	
			return $found;
		}
		return false;
	}
	
	// Function to update news settings
	function UpdateNewsSettings($width = 500,$height = 200){
		$db =& $this->GetDb();
		// Strip everything but numbers
		$width = preg_replace("/[^0-9]+/", "", $width);
		$height = preg_replace("/[^0-9]+/", "", $height);
		// Update database
		// Delete settings first
		$query = "DELETE FROM ".cms_db_prefix()."module_bwimages_newssettings";
		$dbresult = $db->Execute($query);
		$query = "INSERT INTO ".cms_db_prefix()."module_bwimages_newssettings (width,height) VALUES(?,?)";
		$vars = array($width,$height);
		$dbresult = $db->Execute($query,$vars);		
		return $dbresult;
	}
}
?>
