/*
 * Decompiled with CFR 0.152.
 */
package v9t9.launch;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import v9t9.launch.JarUtils;

public class Launcher {
    public static final String TOOL_PREFIX = "v9t9.tools.";
    private static final String LIBS = "libs";
    private byte[] buffer = new byte[8192];
    private File libDir;

    public static void main(String[] args) {
        Launcher launcher = new Launcher();
        try {
            launcher.launch(args);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
            System.err.println("\nV9t9 crashed!");
            System.exit(4);
        }
        catch (Throwable e1) {
            e1.printStackTrace();
            System.err.println("\nCould not launch V9t9!");
            System.exit(3);
        }
    }

    protected void launch(String[] args) throws InvocationTargetException, Throwable {
        File tmpDir = this.getExtractDir();
        this.libDir = new File(tmpDir, LIBS);
        for (int idx = 0; idx < args.length; ++idx) {
            if (!"-clean".equals(args[idx])) continue;
            args = this.remove(args, idx);
            this.recursiveDelete(tmpDir);
            break;
        }
        URL jarURL = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
        JarFile jarFile = JarUtils.getJarFile(jarURL);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (jarFile != null) {
            ArrayList<URL> jarURLs = new ArrayList<URL>();
            this.extractZipFileAndClose("Extracting V9t9 to " + tmpDir + "...", tmpDir, jarFile, jarURLs);
            classLoader = this.replaceClassLoader(jarURLs);
            try {
                jarFile.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String mainClass = "v9t9.gui.Emulator";
        for (int idx = 0; idx < args.length; ++idx) {
            if ("-help".equals(args[idx]) || "-h".equals(args[idx]) || "-?".equals(args[idx])) {
                System.out.println("V9t9 Launcher\n\nTo emulate a machine:\n\nv9t9.[sh|bat] [MachineName | --list-machines] [ClientName | --list-clients]\n\nTo use tools:\n\nv9t9.[sh|bat] -tool [class args...] \n");
                return;
            }
            if (!"-tool".equals(args[idx])) continue;
            mainClass = "ToolHelp";
            if (idx < (args = this.remove(args, idx)).length) {
                mainClass = args[idx];
                args = this.remove(args, idx);
            }
            if (mainClass.indexOf(46) >= 0) break;
            mainClass = TOOL_PREFIX + mainClass;
            break;
        }
        Class<?> klass = classLoader.loadClass(mainClass);
        Method main = klass.getMethod("main", String[].class);
        main.invoke(null, new Object[]{args});
    }

    private void recursiveDelete(File tmpDir) {
        File[] files = tmpDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.recursiveDelete(file);
                continue;
            }
            file.delete();
        }
    }

    private String[] remove(String[] args, int idx) {
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 0, newArgs, 0, idx);
        System.arraycopy(args, idx + 1, newArgs, idx, args.length - idx - 1);
        return newArgs;
    }

    protected URLClassLoader replaceClassLoader(List<URL> jarURLs) {
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(jarURLs.toArray(new URL[jarURLs.size()]), currentThreadClassLoader){

            @Override
            protected String findLibrary(String libname) {
                File libfile = new File(Launcher.this.libDir, System.mapLibraryName(libname));
                if (libfile.exists()) {
                    return libfile.getAbsolutePath();
                }
                return super.findLibrary(libname);
            }
        };
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        return urlClassLoader;
    }

    protected File getExtractDir() {
        File tmpDir;
        String v9t9Path = System.getProperty("v9t9.dir");
        if (v9t9Path != null && v9t9Path.length() > 0) {
            tmpDir = new File(v9t9Path);
        } else {
            String tmpPath = System.getProperty("java.io.tmpdir");
            tmpDir = new File(tmpPath, ".v9t9j/exec");
            tmpDir.mkdirs();
            if (!tmpDir.isDirectory()) {
                System.err.println("Cannot create " + tmpDir + " for extraction.");
                tmpDir = new File(System.getProperty("user.home"), ".v9t9j/exec");
            }
        }
        tmpDir.mkdirs();
        if (!tmpDir.isDirectory()) {
            System.err.println("Cannot create " + tmpDir + " for extraction.\n\n" + "Please use -Dv9t9.dir=... option to unpack V9t9 elsewhere.");
            System.exit(1);
        }
        return tmpDir;
    }

    protected void extractZipFileAndClose(String label, File targetDir, ZipFile zipFile, List<URL> jarURLs) {
        String myArch;
        boolean any = false;
        Enumeration<? extends ZipEntry> enm = zipFile.entries();
        String myOS = System.getProperty("os.name");
        if (myOS.equals("Linux")) {
            myOS = "linux";
        } else if (myOS.startsWith("Windows ")) {
            myOS = "win32";
        } else if (myOS.equals("Mac OS X")) {
            myOS = "macosx";
        }
        String genericArch = myArch = System.getProperty("os.arch");
        if (myArch.contains("64") && (myArch.contains("amd") || myArch.contains("x86"))) {
            myArch = "x86_64";
            genericArch = "intel";
        } else if (myArch.endsWith("86")) {
            myArch = "x86";
            genericArch = "intel";
        }
        while (enm.hasMoreElements()) {
            ZipEntry entry = enm.nextElement();
            String path = entry.getName();
            if (path.startsWith("META-INF")) continue;
            File target = new File(targetDir, path);
            if (entry.isDirectory()) {
                target.mkdirs();
                continue;
            }
            boolean doExtract = false;
            boolean doCopy = true;
            String name = target.getName();
            target.getParentFile().mkdirs();
            if (name.startsWith("org.eclipse.swt") && !name.equals("org.eclipse.swt.jar") && !name.matches("org.eclipse.swt..*" + myOS + "." + myArch + ".jar")) continue;
            if (name.startsWith("v9t9j-natives-")) {
                if (!name.matches("v9t9j-natives-" + myOS + "-" + genericArch + ".jar")) continue;
                doExtract = true;
            }
            long entTime = entry.getTime();
            long fileTime = target.lastModified();
            if (target.exists() && fileTime != 0L && entTime > 0L && Math.abs(fileTime - entTime) <= 2000L && entry.getSize() == target.length()) {
                doCopy = false;
            }
            if (doCopy) {
                if (!any) {
                    System.out.println(label);
                    any = true;
                }
                try {
                    InputStream is = zipFile.getInputStream(entry);
                    this.extractFileAndClose(is, target);
                    if (name.matches("(?i).*\\.(so|dylib|dll)")) {
                        target.setExecutable(true, false);
                    }
                    target.setLastModified(entTime);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(3);
                }
            }
            if (doExtract) {
                try {
                    File libDir = new File(targetDir, LIBS);
                    if (doCopy) {
                        this.extractZipFileAndClose("Extracting native libraries to " + targetDir + "...", libDir, new ZipFile(target), jarURLs);
                    }
                    jarURLs.add(libDir.toURI().toURL());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(5);
                }
                continue;
            }
            if (!path.endsWith(".jar")) continue;
            try {
                jarURLs.add(target.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            zipFile.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFileAndClose(InputStream is, File target) throws IOException {
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(target));
            while ((len = is.read(this.buffer)) > 0) {
                ((OutputStream)os).write(this.buffer, 0, len);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {}
            }
        }
    }
}

