﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using System.Collections.ObjectModel;
using Windows.Storage;

namespace LocalStorageWpApp
{
    public partial class ViewFiles : PhoneApplicationPage
    {
        public ViewFiles()
        {
            InitializeComponent();
        }

        List<StorageFile> FilesList { get; set; }

        protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
        {
            base.OnNavigatedTo(e);
            GetFilesList();
        }

        public async void GetFilesList()
        {
            StorageFolder folder = ApplicationData.Current.LocalFolder;

            IReadOnlyList<StorageFile> files = await folder.GetFilesAsync();

            FilesList = new List<StorageFile>(files);
            llsFiles.ItemsSource = FilesList;
            
        }

        private void LongListSelectorFiles_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (llsFiles.SelectedItem != null)
            {
                var file = llsFiles.SelectedItem as StorageFile;
                NavigationService.Navigate(new Uri("/SingleFile.xaml?filename=" + file.Name, UriKind.Relative));
                llsFiles.SelectedItem = null;
            }
        }
    }
}