﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using Windows.Storage;
using System.IO;
using System.Text;

namespace LocalStorageWpApp
{
    public partial class SingleFile : PhoneApplicationPage
    {
        public SingleFile()
        {
            InitializeComponent();
        }

        private void btnUpdate_Tap(object sender, System.Windows.Input.GestureEventArgs e)
        {
            UpdateFile();
        }

        private async void UpdateFile()
        {
            try
            {
                StorageFolder folder = ApplicationData.Current.LocalFolder;

                if (folder != null)
                {

                    StorageFile file = await folder.CreateFileAsync(txtFileName.Text, CreationCollisionOption.ReplaceExisting);

                    byte[] fileContent = Encoding.UTF8.GetBytes(txtFileContent.Text.ToCharArray());

                    Stream fileStream = await file.OpenStreamForWriteAsync();
                    fileStream.Write(fileContent, 0, fileContent.Length);
                    fileStream.Flush();
                    fileStream.Close();

                    MessageBox.Show("File Has Been Updated");
                    
                }


            }
            catch (Exception ex)
            {

                // Some Exception handling code
            }
        }

        private void btnCancel_Tap(object sender, System.Windows.Input.GestureEventArgs e)
        {
            NavigationService.GoBack();
        }

        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            
            base.OnNavigatedTo(e);
            string filename;

            if(NavigationContext.QueryString.TryGetValue("filename",out filename))
            {
                DisplayFile(filename);
            }
        }

        private async void DisplayFile(string filename)
        {
            StorageFolder local = ApplicationData.Current.LocalFolder;

            if(local != null)
            {

                try
                {
                    Stream file = await local.OpenStreamForReadAsync(filename);

                    StreamReader sr = new StreamReader(file);
                    string content = sr.ReadToEnd();
                    txtFileContent.Text = content;
                    txtFileName.Text = filename;
                    sr.Close();
                    file.Close();

                }
                catch(Exception ex)
                {
                    // SOme Exception Handling
                }


            }
        }
    }
}