﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using LocalStorageWpApp.Resources;
using Windows.Storage;
using System.Text;
using System.IO;

namespace LocalStorageWpApp
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        public MainPage()
        {
            InitializeComponent();

            // Sample code to localize the ApplicationBar
            //BuildLocalizedApplicationBar();
        }

        private void btnCreate_Tap(object sender, System.Windows.Input.GestureEventArgs e)
        {
            if(txtFileName.Text != string.Empty)
            {
                SaveFile();
            }
            else
            {
                MessageBox.Show("Please Enter File Name");
            }
        }

        private async void SaveFile()
        {
            try
            {
                StorageFolder folder = ApplicationData.Current.LocalFolder;

                if(folder != null)
                {

                    StorageFile file = await folder.CreateFileAsync(txtFileName.Text, CreationCollisionOption.ReplaceExisting);
                    
                    byte[] fileContent = Encoding.UTF8.GetBytes(txtFileContent.Text.ToCharArray());

                    Stream fileStream = await file.OpenStreamForWriteAsync();
                    fileStream.Write(fileContent, 0, fileContent.Length);
                    fileStream.Flush();
                    fileStream.Close();

                    MessageBox.Show("File Has Been Created");
                    txtFileContent.Text = "";
                    txtFileName.Text = "";
                }


            }
            catch (Exception ex)
            {
                
                // Some Exception handling code
            }

        }

        private void btnView_Tap(object sender, System.Windows.Input.GestureEventArgs e)
        {
            NavigationService.Navigate(new Uri("/ViewFiles.xaml", UriKind.Relative));
        }

        // Sample code for building a localized ApplicationBar
        //private void BuildLocalizedApplicationBar()
        //{
        //    // Set the page's ApplicationBar to a new instance of ApplicationBar.
        //    ApplicationBar = new ApplicationBar();

        //    // Create a new button and set the text value to the localized string from AppResources.
        //    ApplicationBarIconButton appBarButton = new ApplicationBarIconButton(new Uri("/Assets/AppBar/appbar.add.rest.png", UriKind.Relative));
        //    appBarButton.Text = AppResources.AppBarButtonText;
        //    ApplicationBar.Buttons.Add(appBarButton);

        //    // Create a new menu item with the localized string from AppResources.
        //    ApplicationBarMenuItem appBarMenuItem = new ApplicationBarMenuItem(AppResources.AppBarMenuItemText);
        //    ApplicationBar.MenuItems.Add(appBarMenuItem);
        //}
    }
}