﻿using LocalDatabaseWPApp.Model;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections.ObjectModel;

namespace LocalDatabaseWPApp.ViewModels
{
    public class StudentViewModel: INotifyPropertyChanged
    {
        private StudentDataContext context = new StudentDataContext(StudentDataContext.DBConnectionString);
        public ObservableCollection<Courses> Courses { get; private set; }
        
        private Courses _newcourse;
        public Courses NewCourse
        {
            get
            {
                return _newcourse;
            }
            set
            {
                _newcourse = value;
                NotifyPropertyChanged("NewCourse");
            }
        }

        private Student _student;
        public Student Student
        {
            get
            {
                return _student;
            }
            set
            {
                _student = value;
                NotifyPropertyChanged("Student");
            }
        }

        public StudentViewModel()
        {
            this.Student = new Student();
           
        }

        public StudentViewModel(int studentId)
        {
            this.Student = context.Students.Where(b => b.Id == studentId).FirstOrDefault();
            
            context.SubmitChanges();

            LoadCourses();
        }

        private void LoadCourses()
        {
            List<Courses> courseList = context.Courses
                .Where(n => n.StudentId == this.Student.Id)
                .ToList();
            this.Courses = new ObservableCollection<Courses>(courseList);   
        }

        public void Save()
        {
            if (Student.Id <= 0)
            {
               context.Students.InsertOnSubmit(Student);
            }

            context.SubmitChanges();
        }

        public void InitializeNewCourse()
        {
            NewCourse = new Courses();
            NewCourse.Student = this.Student;
            NewCourse.CourseName = "";
        }

        public void AddNewCourse()
        {
            context.Courses.InsertOnSubmit(NewCourse);
            context.SubmitChanges();
            LoadCourses();
        }

        public event PropertyChangedEventHandler PropertyChanged;
        private void NotifyPropertyChanged(String propertyName)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (null != handler)
            {
                handler(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }
}
