﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections.ObjectModel;
using LocalDatabaseWPApp.Model;

namespace LocalDatabaseWPApp.ViewModels
{
    public class MainViewModel : INotifyPropertyChanged
    {
        private StudentDataContext context;
        public ObservableCollection<Student> Students { get; private set; }
        public bool IsDataLoaded { get; private set; }

        public MainViewModel()
        {
            this.Students = new ObservableCollection<Student>();
            context = new StudentDataContext(StudentDataContext.DBConnectionString);

            if(!context.DatabaseExists())
            {
                context.CreateDatabase();
                context.SubmitChanges();
            }
        }

        public void LoadStudentsData()
        {
            if(context.Students.Count() > 0)
            {
                List<Student> studentList = context.Students.ToList();
                Students = new ObservableCollection<Student>(studentList);
            }

            IsDataLoaded = true;
        }

        public event PropertyChangedEventHandler PropertyChanged;
        private void NotifyPropertyChanged(String propertyName)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (null != handler)
            {
                handler(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }
}
