﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using LocalDatabaseWPApp.ViewModels;
using System.Windows.Input;

namespace LocalDatabaseWPApp
{
    public partial class StudentDetails : PhoneApplicationPage
    {
        private StudentViewModel _studentViewModel;

        public StudentDetails()
        {
            InitializeComponent();
        }

        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            int studentid = -1;
            string selectedIndex = "";
            if (NavigationContext.QueryString.TryGetValue("studentid", out selectedIndex))
            {
                studentid = int.Parse(selectedIndex);
                _studentViewModel = new StudentViewModel(studentid);
            }
            else
            {
                _studentViewModel = new StudentViewModel();
            }

            DataContext = _studentViewModel;
            ENableControlsBasedOnStudent();
        }

        private void ENableControlsBasedOnStudent()
        {
            if (ApplicationBar.Buttons.Count > 1)
            {
                ApplicationBarIconButton saveButton = (ApplicationBarIconButton)ApplicationBar.Buttons[0];
                ApplicationBarIconButton addCoursesButton = (ApplicationBarIconButton)ApplicationBar.Buttons[1];

                if (_studentViewModel.Student.Id > 0)
                {
                    ApplicationBar.Buttons.Remove(saveButton);
                    addCoursesButton.IsEnabled = true;
                }
                else
                {
                    saveButton.IsEnabled = true;
                    addCoursesButton.IsEnabled = false;
                }
            }


            txtName.IsEnabled = txtRollNo.IsEnabled = (_studentViewModel.Student.Id <= 0);
        }

        private void addButton_Click_1(object sender, RoutedEventArgs e)
        {
          
            popupAddCourse.IsOpen = false;
            _studentViewModel.AddNewCourse();
            llsCourses.ItemsSource = _studentViewModel.Courses;

            if (studentDetailsPivot.SelectedIndex != 1)
            {
                studentDetailsPivot.SelectedIndex = 1;
            }
        }

        private void cancelButton_Click_1(object sender, RoutedEventArgs e)
        {
            popupAddCourse.IsOpen = false;
            _studentViewModel.NewCourse = null;
        }

        private void ApplicationBarSaveButton_Click_1(object sender, EventArgs e)
        {
            UpdateTextBoxBinding();
            _studentViewModel.Save();
            ENableControlsBasedOnStudent();
        }

        private void ApplicationBarAddCourseButton_Click_1(object sender, EventArgs e)
        {
            UpdateTextBoxBinding();
            _studentViewModel.InitializeNewCourse();
            popupAddCourse.IsOpen = true;
            txtCourseDetails.Focus();
        }

        private void UpdateTextBoxBinding()
        {
            //force an update of the binding for the textbox that has focus 
            //so the current text is reflected in the viewmodel property
            object focusedElement = FocusManager.GetFocusedElement();
            if (focusedElement != null && focusedElement is TextBox)
            {
                TextBox textBox = (TextBox)focusedElement;
                var binding = textBox.GetBindingExpression(TextBox.TextProperty);
                binding.UpdateSource();
            }

        }
    }
}