﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LocalDatabaseWPApp.Model
{
    [Table(Name = "Student")]
    public class Student : INotifyPropertyChanged, INotifyPropertyChanging
    {
        public Student()
        {

            _courses = new EntitySet<Courses>(
                    course =>
                    {
                        NotifyPropertyChanging("Courses");
                        course.Student = this;
                    },
                    course =>
                    {
                        NotifyPropertyChanging("Courses");
                        course.Student = null;
                    }
                );
        }

        private int _id;

        [Column(IsPrimaryKey = true, IsDbGenerated = true, DbType = "INT NOT NULL Identity", CanBeNull = false, AutoSync = AutoSync.OnInsert)]
        public int Id
        {
            get
            {
                return _id;
            }
            set
            {
                if (_id != value)
                {
                    NotifyPropertyChanging("Id");
                    _id = value;
                    NotifyPropertyChanged("Id");
                }
            }
        }

        private string _name;

        [Column(DbType = "nvarchar(255)", CanBeNull = false)]
        public string Name
        {
            get
            {
                return _name;
            }
            set
            {
                if (_name != value)
                {
                    NotifyPropertyChanging("Name");
                    _name = value;
                    NotifyPropertyChanged("Name");
                }
            }
        }

        private string _rollno;

        [Column(DbType = "nvarchar(255)", CanBeNull = false)]
        public string RollNo
        {
            get
            {
                return _rollno;
            }
            set
            {
                if (_rollno != value)
                {
                    NotifyPropertyChanging("RollNo");
                    _rollno = value;
                    NotifyPropertyChanged("RollNo");
                }
            }
        }

        private EntitySet<Courses> _courses;

        [Association(Name = "FK_Student_Courses", Storage = "_courses", ThisKey = "Id", OtherKey = "StudentId")]
        public EntitySet<Courses> Courses
        {
            get
            {
                return _courses;
            }
            set
            {
                _courses.Assign(value);
            }
        }


        public event PropertyChangingEventHandler PropertyChanging;

        // Used to notify the data context that a data context property is about to change
        private void NotifyPropertyChanging(string propertyName)
        {
            if (PropertyChanging != null)
            {
                PropertyChanging(this, new PropertyChangingEventArgs(propertyName));
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        // Used to notify the page that a data context property changed
        private void NotifyPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }
}

    