﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LocalDatabaseWPApp.Model
{
    [Table(Name="Courses")]
    public class Courses : INotifyPropertyChanged, INotifyPropertyChanging
    {
        private int _courseid;
        [Column(IsPrimaryKey = true, IsDbGenerated = true, DbType = "INT NOT NULL Identity", CanBeNull = false, AutoSync = AutoSync.OnInsert)]
        public int CourseId
        {
            get
            {
                return _courseid;
            }

            set
            {
                if (_courseid != value)
                {
                    NotifyPropertyChanging("CourseId");
                    _courseid = value;
                    NotifyPropertyChanged("CourseId");
                }
            }
        }

        private string _coursename;
        [Column(DbType = "nvarchar(255)", CanBeNull = false)]
        public string CourseName
        {
            get
            {
                return _coursename;
            }

            set
            {
                if (_coursename != value)
                {
                    NotifyPropertyChanging("CourseName");
                    _coursename = value;
                    NotifyPropertyChanged("CourseName");
                }
            }
        }

        private EntityRef<Student> _student;
        [Association(Name = "FK_Student_Courses", Storage = "_student", ThisKey = "StudentId",
        OtherKey = "Id", IsForeignKey = true)]
        public Student Student
        {
            get
            {
                return _student.Entity;
            }
            set
            {
                NotifyPropertyChanging("Student");
                _student.Entity = value;

                if (value != null)
                {
                    _studentid = value.Id;
                }

                NotifyPropertyChanged("Student");
            }
        }

        public int _studentid;
        [Column(CanBeNull=false)]
        public int StudentId
        {
            get
            {
                return _studentid;
            }
            set
            {
                if (_studentid != value)
                {
                    NotifyPropertyChanging("StudentId");
                    _studentid = value;
                    NotifyPropertyChanged("StudentId");
                }
            }
        }

        

        public event PropertyChangingEventHandler PropertyChanging;

        // Used to notify the data context that a data context property is about to change
        private void NotifyPropertyChanging(string propertyName)
        {
            if (PropertyChanging != null)
            {
                PropertyChanging(this, new PropertyChangingEventArgs(propertyName));
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        // Used to notify the page that a data context property changed
        private void NotifyPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }
}


